/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.MethodType;
import com.qiniu.storage.ApiUpload;
import com.qiniu.storage.ApiUtils;
import com.qiniu.storage.UploadToken;
import com.qiniu.util.StringUtils;
import java.util.List;
import java.util.Map;

public class ApiQueryRegion
extends ApiUpload {
    public ApiQueryRegion(Client client) {
        super(client);
    }

    public Response request(Request request) throws QiniuException {
        return new Response(this.requestByClient(request));
    }

    public static class Response
    extends ApiUpload.Response {
        protected Response(com.qiniu.http.Response response) throws QiniuException {
            super(response);
        }

        public String getDefaultRegionId() {
            return this.getRegionId(this.getDefaultRegion());
        }

        public String getRegionId(Map<String, Object> region) {
            if (region == null) {
                return null;
            }
            Object regionId = ApiUtils.getValueFromMap(region, "region");
            return regionId.toString();
        }

        public Long getDefaultRegionTTL() {
            return this.getRegionTTL(this.getDefaultRegion());
        }

        public Long getRegionTTL(Map<String, Object> region) {
            if (region == null) {
                return null;
            }
            Object ttl = ApiUtils.getValueFromMap(region, "ttl");
            return ApiUtils.objectToLong(ttl);
        }

        public List<String> getDefaultRegionUpHosts() {
            return this.getRegionUpHosts(this.getDefaultRegion());
        }

        public List<String> getRegionUpHosts(Map<String, Object> region) {
            if (region == null) {
                return null;
            }
            Object domains = ApiUtils.getValueFromMap(region, "up", "domains");
            if (!(domains instanceof List)) {
                return null;
            }
            return (List)domains;
        }

        private Map<String, Object> getDefaultRegion() {
            return this.getRegion(0);
        }

        public Map<String, Object> getRegion(int index) {
            Object value = this.getValueFromDataMap("hosts");
            if (!(value instanceof List) || ((List)value).size() < index) {
                return null;
            }
            Object regionObject = ((List)value).get(index);
            if (!(regionObject instanceof Map)) {
                return null;
            }
            return (Map)regionObject;
        }
    }

    public static class Request
    extends ApiUpload.Request {
        private static final String DEFAULT_URL_PREFIX = "https://uc.qbox.me";

        public Request(String urlPrefix, String token) {
            super(StringUtils.isNullOrEmpty(urlPrefix) ? DEFAULT_URL_PREFIX : urlPrefix);
            this.setToken(token);
            this.setMethod(MethodType.GET);
        }

        @Override
        protected void buildQuery() throws QiniuException {
            UploadToken token = this.getUploadToken();
            this.addQueryPair("ak", token.getAccessKey());
            this.addQueryPair("bucket", token.getBucket());
            super.buildQuery();
        }

        @Override
        protected void buildPath() throws QiniuException {
            this.addPathSegment("v4");
            this.addPathSegment("query");
            super.buildPath();
        }
    }
}

