/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.MethodType;
import com.qiniu.http.RequestStreamBody;
import com.qiniu.storage.ApiUtils;
import com.qiniu.util.StringMap;
import com.qiniu.util.StringUtils;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import okhttp3.MediaType;
import okhttp3.RequestBody;

public class Api {
    private final Client client;

    protected Api(Client client) {
        this.client = client;
    }

    protected com.qiniu.http.Response requestByClient(Request request) throws QiniuException {
        if (this.client == null) {
            ApiUtils.throwInvalidRequestParamException("client");
        }
        if (request == null) {
            ApiUtils.throwInvalidRequestParamException("request");
        }
        request.prepareToRequest();
        if (request.method == MethodType.GET) {
            return this.client.get(request.getUrl().toString(), request.getHeader());
        }
        if (request.method == MethodType.POST) {
            return this.client.post(request.getUrl().toString(), request.getRequestBody(), request.getHeader());
        }
        if (request.method == MethodType.PUT) {
            return this.client.put(request.getUrl().toString(), request.getRequestBody(), request.getHeader());
        }
        if (request.method == MethodType.DELETE) {
            return this.client.delete(request.getUrl().toString(), request.getRequestBody(), request.getHeader());
        }
        throw QiniuException.unrecoverable("\u6682\u4e0d\u652f\u6301\u8fd9\u79cd\u8bf7\u6c42\u65b9\u5f0f");
    }

    public static class Response {
        private final StringMap dataMap;
        private final com.qiniu.http.Response response;

        protected Response(com.qiniu.http.Response response) throws QiniuException {
            this.dataMap = response.jsonToMap();
            this.response = response;
        }

        public StringMap getDataMap() {
            return this.dataMap;
        }

        public com.qiniu.http.Response getResponse() {
            return this.response;
        }

        public boolean isOK() {
            return this.response.isOK();
        }

        public String getStringValueFromDataMap(String ... keyPath) {
            Object value = this.getValueFromDataMap(keyPath);
            if (value == null) {
                return null;
            }
            return value.toString();
        }

        public Long getLongValueFromDataMap(String ... keyPath) {
            Object value = this.getValueFromDataMap(keyPath);
            return ApiUtils.objectToLong(value);
        }

        public Integer getIntegerValueFromDataMap(String ... keyPath) {
            Object value = this.getValueFromDataMap(keyPath);
            return ApiUtils.objectToInteger(value);
        }

        public Object getValueFromDataMap(String ... keyPath) {
            if (this.dataMap == null) {
                return null;
            }
            return ApiUtils.getValueFromMap(this.dataMap.map(), keyPath);
        }
    }

    public static class Request {
        private final String urlPrefix;
        private String path;
        private final List<String> pathSegments = new ArrayList<String>();
        private String query;
        private final List<Pair<String, String>> queryPairs = new ArrayList<Pair<String, String>>();
        private MethodType method;
        private final Map<String, String> header = new HashMap<String, String>();
        private RequestBody body;
        private long streamBodySinkSize = 10240L;

        protected Request(String urlPrefix) {
            this.urlPrefix = urlPrefix;
        }

        public String getUrlPrefix() {
            return this.urlPrefix;
        }

        public String getHost() throws QiniuException {
            try {
                URL url = new URL(this.urlPrefix);
                return url.getHost();
            }
            catch (Exception e) {
                throw new QiniuException(e);
            }
        }

        protected void addPathSegment(String segment) {
            if (segment == null) {
                return;
            }
            this.pathSegments.add(segment);
            this.path = null;
        }

        public String getPath() throws QiniuException {
            if (this.path == null) {
                this.buildPath();
            }
            return this.path;
        }

        protected void buildPath() throws QiniuException {
            this.path = "/" + StringUtils.join(this.pathSegments, "/");
        }

        protected void addQueryPair(String key, String value) {
            if (StringUtils.isNullOrEmpty(key)) {
                return;
            }
            this.queryPairs.add(new Pair<String, String>(key, value));
            this.query = null;
        }

        public String getQuery() throws QiniuException {
            if (StringUtils.isNullOrEmpty(this.query)) {
                this.buildQuery();
            }
            return this.query;
        }

        protected void buildQuery() throws QiniuException {
            StringBuilder builder = new StringBuilder();
            for (Pair<String, String> pair : this.queryPairs) {
                if (builder.length() > 0) {
                    builder.append("&");
                }
                try {
                    builder.append(URLEncoder.encode(pair.getKey(), "UTF-8"));
                    if (pair.getValue() == null) continue;
                    builder.append("=");
                    builder.append(URLEncoder.encode(pair.getValue(), "UTF-8"));
                }
                catch (Exception e) {
                    throw new QiniuException(e);
                }
            }
            this.query = builder.toString();
        }

        protected void setMethod(MethodType method) {
            this.method = method;
        }

        public void addHeaderField(String key, String value) {
            if (StringUtils.isNullOrEmpty(key) || StringUtils.isNullOrEmpty(value)) {
                return;
            }
            this.header.put(key, value);
        }

        public StringMap getHeader() throws QiniuException {
            StringMap header = new StringMap();
            for (String key : this.header.keySet()) {
                header.put(key, this.header.get(key));
            }
            return header;
        }

        public URL getUrl() throws QiniuException {
            try {
                String query;
                URL url = new URL(this.urlPrefix);
                String file = url.getFile();
                String path = this.getPath();
                if (!StringUtils.isNullOrEmpty(path)) {
                    file = file + path;
                }
                if (!StringUtils.isNullOrEmpty(query = this.getQuery())) {
                    file = file + '?' + query;
                }
                return new URL(url.getProtocol(), url.getHost(), url.getPort(), file);
            }
            catch (Exception e) {
                throw new QiniuException(e);
            }
        }

        protected void setBody(byte[] body, int offset, int size, String contentType) {
            if (StringUtils.isNullOrEmpty(contentType)) {
                contentType = "application/octet-stream";
            }
            MediaType type = MediaType.parse((String)contentType);
            this.body = RequestBody.create((MediaType)type, (byte[])body, (int)offset, (int)size);
        }

        protected void setBody(InputStream body, String contentType, long limitSize) {
            if (StringUtils.isNullOrEmpty(contentType)) {
                contentType = "application/octet-stream";
            }
            MediaType type = MediaType.parse((String)contentType);
            this.body = new RequestStreamBody(body, type, limitSize);
        }

        public Request setStreamBodySinkSize(long streamBodySinkSize) {
            this.streamBodySinkSize = streamBodySinkSize;
            return this;
        }

        public boolean hasBody() {
            return this.body != null;
        }

        private RequestBody getRequestBody() {
            if (this.hasBody()) {
                if (this.body instanceof RequestStreamBody) {
                    ((RequestStreamBody)this.body).setSinkSize(this.streamBodySinkSize);
                }
                return this.body;
            }
            return RequestBody.create(null, (byte[])new byte[0]);
        }

        protected void buildBodyInfo() throws QiniuException {
        }

        protected void prepareToRequest() throws QiniuException {
            this.buildPath();
            this.buildQuery();
            this.buildBodyInfo();
        }

        protected static class Pair<K, V> {
            private K key;
            private V value;

            K getKey() {
                return this.key;
            }

            V getValue() {
                return this.value;
            }

            protected Pair(K key, V value) {
                this.key = key;
                this.value = value;
            }

            public String toString() {
                return this.key + "=" + this.value;
            }

            public int hashCode() {
                return this.key.hashCode() * 13 + (this.value == null ? 0 : this.value.hashCode());
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o instanceof Pair) {
                    Pair pair = (Pair)o;
                    if (!Objects.equals(this.key, pair.key)) {
                        return false;
                    }
                    return Objects.equals(this.value, pair.value);
                }
                return false;
            }
        }
    }
}

