/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.qvs;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import com.qiniu.qvs.QvsMap;
import com.qiniu.qvs.QvsResponse;
import com.qiniu.qvs.model.Device;
import com.qiniu.qvs.model.PatchOperation;
import com.qiniu.qvs.model.PlayContral;
import com.qiniu.qvs.model.VoiceChat;
import com.qiniu.util.Auth;
import com.qiniu.util.StringMap;
import com.qiniu.util.UrlUtils;

public class DeviceManager {
    private final String apiServer;
    private final Client client;
    private final Auth auth;

    public DeviceManager(Auth auth) {
        this(auth, "http://qvs.qiniuapi.com");
    }

    public DeviceManager(Auth auth, String apiServer) {
        this(auth, apiServer, new Client());
    }

    public DeviceManager(Auth auth, String apiServer, Client client) {
        this.auth = auth;
        this.apiServer = apiServer;
        this.client = client;
    }

    public Response createDevice(String namespaceId, Device device) throws QiniuException {
        StringMap params = device.transferPostParam();
        String url = String.format("%s/v1/namespaces/%s/devices", this.apiServer, namespaceId);
        return QvsResponse.post(url, params, this.client, this.auth);
    }

    public Response deleteDevice(String namespaceId, String gbId) throws QiniuException {
        String url = String.format("%s/v1/namespaces/%s/devices/%s", this.apiServer, namespaceId, gbId);
        return QvsResponse.delete(url, this.client, this.auth);
    }

    public Response updateDevice(String namespaceId, String gbId, PatchOperation[] patchOperation) throws QiniuException {
        StringMap params = new StringMap().put("operations", patchOperation);
        String url = String.format("%s/v1/namespaces/%s/devices/%s", this.apiServer, namespaceId, gbId);
        return QvsResponse.patch(url, params, this.client, this.auth);
    }

    public Response queryDevice(String namespaceId, String gbId) throws QiniuException {
        String url = String.format("%s/v1/namespaces/%s/devices/%s", this.apiServer, namespaceId, gbId);
        return QvsResponse.get(url, this.client, this.auth);
    }

    public Response listDevice(String namespaceId, int offset, int line, String prefix, String state, int qtype) throws QiniuException {
        StringMap map = new StringMap().put("offset", offset).put("line", line).put("qtype", qtype).put("prefix", prefix).put("state", state);
        String requestUrl = String.format("%s/v1/namespaces/%s/devices?%s", this.apiServer, namespaceId, map.formString());
        return QvsResponse.get(requestUrl, this.client, this.auth);
    }

    public Response listChannels(String namespaceId, String gbId, String prefix) throws QiniuException {
        StringMap map = new StringMap().put("prefix", prefix);
        String requestUrl = String.format("%s/v1/namespaces/%s/devices/%s/channels?%s", this.apiServer, namespaceId, gbId, map.formString());
        return QvsResponse.get(requestUrl, this.client, this.auth);
    }

    public Response startDevice(String namespaceId, String gbId, String[] channels) throws QiniuException {
        String url = String.format("%s/v1/namespaces/%s/devices/%s/start", this.apiServer, namespaceId, gbId);
        StringMap params = new StringMap().put("channels", channels);
        return QvsResponse.post(url, params, this.client, this.auth);
    }

    public Response stopDevice(String namespaceId, String gbId, String[] channels) throws QiniuException {
        String url = String.format("%s/v1/namespaces/%s/devices/%s/stop", this.apiServer, namespaceId, gbId);
        StringMap params = new StringMap().put("channels", channels);
        return QvsResponse.post(url, params, this.client, this.auth);
    }

    public Response fetchCatalog(String namespaceId, String gbId) throws QiniuException {
        String url = String.format("%s/v1/namespaces/%s/devices/%s/catalog/fetch", this.apiServer, namespaceId, gbId);
        return QvsResponse.post(url, new StringMap(), this.client, this.auth);
    }

    public Response queryChannel(String namespaceId, String gbId, String channelId) throws QiniuException {
        String url = String.format("%s/v1/namespaces/%s/devices/%s/channels/%s", this.apiServer, namespaceId, gbId, channelId);
        return QvsResponse.get(url, this.client, this.auth);
    }

    public Response deleteChannel(String namespaceId, String gbId, String channelId) throws QiniuException {
        String url = String.format("%s/v1/namespaces/%s/devices/%s/channels/%s", this.apiServer, namespaceId, gbId, channelId);
        return QvsResponse.delete(url, this.client, this.auth);
    }

    public Response queryGBRecordHistories(String namespaceId, String gbId, String channelId, int start, int end) throws QiniuException {
        String url = String.format("%s/v1/namespaces/%s/devices/%s/recordhistories", this.apiServer, namespaceId, gbId);
        StringMap map = new StringMap().put("start", start).put("end", end).putNotNull("chId", channelId);
        url = UrlUtils.composeUrlWithQueries(url, map);
        return QvsResponse.get(url, this.client, this.auth);
    }

    public Response getVoiceChatUrl(String namespaceId, String gbId, VoiceChat voiceChat) throws QiniuException {
        String url = String.format("%s/v1/namespaces/%s/devices/%s/talk", this.apiServer, namespaceId, gbId);
        StringMap params = QvsMap.getVoiceChatMap(voiceChat);
        return QvsResponse.post(url, params, this.client, this.auth);
    }

    public Response sendVoiceChatData(String url, String base64_pcm) throws QiniuException {
        StringMap params = new StringMap().putNotNull("base64_pcm", base64_pcm);
        return QvsResponse.post(url, params, this.client, this.auth);
    }

    public Response controlGBRecord(String namespaceId, String streamId, PlayContral playContral) throws QiniuException {
        String url = String.format("%s/v1/namespaces/%s/streams/%s/playback/control", this.apiServer, namespaceId, streamId);
        StringMap params = QvsMap.getPlayContralMap(playContral);
        return QvsResponse.post(url, params, this.client, this.auth);
    }
}

