/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.util;

import com.oscar.Driver;
import java.lang.ref.SoftReference;
import java.util.Hashtable;
import java.util.Map;
import java.util.Stack;

public abstract class ImportBufferManager {
    private static volatile long maxUsingBufferSize = Runtime.getRuntime().maxMemory();
    private static volatile long usingBufferSize = 0L;
    private static final int waitTime = 180000;
    private static final int perWaitTime = 10000;
    private static final Object lock = new Object();
    private static Hashtable<Integer, SoftReference<Stack<byte[]>>> cacheBuffer = new Hashtable();
    private static final boolean printLog = Driver.getLogLevel() == -1 || Driver.getLogLevel() > 0;

    public static void setMaxUsingBufferSize(int bufferSize) {
        long buffer = bufferSize;
        maxUsingBufferSize = buffer * 1024L * 1024L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBufferAllways(int bufferSize) {
        byte[] result;
        int retryTimes = 0;
        Error error = null;
        while (true) {
            if (retryTimes > 300) {
                throw new RuntimeException("getBufferAllways timeout", error);
            }
            ++retryTimes;
            Object object = lock;
            synchronized (object) {
                SoftReference<Stack<byte[]>> sr;
                Stack<byte[]> stack;
                if (cacheBuffer.containsKey(bufferSize) && (stack = (sr = cacheBuffer.get(bufferSize)).get()) != null && stack.size() > 0) {
                    return stack.pop();
                }
            }
            result = null;
            try {
                result = new byte[bufferSize];
            }
            catch (Error e) {
                error = e;
                Driver.writeLog("ImportBufferManager.getBufferAllways--", e);
                System.gc();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                continue;
            }
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBuffer(int bufferSize) throws InterruptedException {
        Throwable error = null;
        long currentTimeBef = System.currentTimeMillis();
        while (true) {
            Object object = lock;
            synchronized (object) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - currentTimeBef > 180000L) {
                    String message = error != null ? error.toString() : "get buffer timeout, current using :" + usingBufferSize + " maxUsingBufferSize:" + maxUsingBufferSize;
                    throw new RuntimeException(message);
                }
                if (usingBufferSize + (long)bufferSize <= maxUsingBufferSize) {
                    Stack<byte[]> stack;
                    SoftReference<Stack<byte[]>> sr;
                    if (printLog) {
                        Driver.writeLog(Thread.currentThread().getId() + " success get buffer " + bufferSize + ", current using :" + usingBufferSize + " maxUsingBufferSize:" + maxUsingBufferSize);
                    }
                    if ((sr = cacheBuffer.get(bufferSize)) != null && (stack = sr.get()) != null && stack.size() > 0) {
                        usingBufferSize += (long)bufferSize;
                        return stack.pop();
                    }
                    byte[] result = null;
                    try {
                        result = new byte[bufferSize];
                        usingBufferSize += (long)bufferSize;
                    }
                    catch (Error e) {
                        Driver.writeLog(String.format("totalMemory::%s, maxMemory::%s, freeMemory::%s", "" + Runtime.getRuntime().totalMemory(), "" + Runtime.getRuntime().maxMemory(), "" + Runtime.getRuntime().freeMemory()));
                        Driver.writeLog(e);
                        error = e;
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                        }
                        continue;
                    }
                    return result;
                }
                if (printLog) {
                    Driver.writeLog("wait buffer " + bufferSize + ", current using :" + usingBufferSize + " maxUsingBufferSize:" + maxUsingBufferSize);
                }
                int oldSize = ImportBufferManager.computeUsingBufferSize();
                System.gc();
                int newSize = ImportBufferManager.computeUsingBufferSize();
                usingBufferSize = -(oldSize - newSize);
                if (usingBufferSize + (long)bufferSize <= maxUsingBufferSize) {
                    continue;
                }
                lock.wait(10000L);
            }
        }
    }

    private static int computeUsingBufferSize() {
        int total = 0;
        for (Map.Entry<Integer, SoftReference<Stack<byte[]>>> entry : cacheBuffer.entrySet()) {
            Stack<byte[]> stack;
            SoftReference<Stack<byte[]>> sr = entry.getValue();
            if (sr == null || (stack = sr.get()) == null) continue;
            total += entry.getKey() * stack.size();
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseCache(byte[] buffer) {
        if (buffer == null) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            SoftReference<Stack<byte[]>> sr = cacheBuffer.get(buffer.length);
            if (sr != null) {
                Stack<byte[]> stack = sr.get();
                if (stack == null) {
                    cacheBuffer.put(buffer.length, ImportBufferManager.newSoftReference(buffer));
                } else {
                    stack.push(buffer);
                }
            } else {
                cacheBuffer.put(buffer.length, ImportBufferManager.newSoftReference(buffer));
            }
            lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseBuffer(byte[] buffer) {
        if (buffer == null) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            SoftReference<Stack<byte[]>> sr;
            usingBufferSize -= (long)buffer.length;
            if (printLog) {
                Driver.writeLog(" release buffer " + buffer.length + ", current using :" + usingBufferSize);
            }
            if ((sr = cacheBuffer.get(buffer.length)) != null) {
                Stack<byte[]> stack = sr.get();
                if (stack == null) {
                    cacheBuffer.put(buffer.length, ImportBufferManager.newSoftReference(buffer));
                } else {
                    stack.push(buffer);
                }
            } else {
                cacheBuffer.put(buffer.length, ImportBufferManager.newSoftReference(buffer));
            }
            lock.notifyAll();
        }
    }

    public static void releaseIncludeSelf() {
        cacheBuffer.clear();
    }

    private static SoftReference<Stack<byte[]>> newSoftReference(byte[] buffer) {
        Stack<byte[]> stack = new Stack<byte[]>();
        stack.push(buffer);
        SoftReference<Stack<byte[]>> sr = new SoftReference<Stack<byte[]>>(stack);
        return sr;
    }
}

