/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.Driver;
import com.oscar.cluster.Cluster;
import com.oscar.cluster.ClusterImportHandler;
import com.oscar.core.BaseConnection;
import com.oscar.core.BaseResultSet;
import com.oscar.core.BaseStatement;
import com.oscar.core.DistributeImportHandler;
import com.oscar.core.Encoding;
import com.oscar.core.ExportHandler;
import com.oscar.core.FieldMetadata;
import com.oscar.core.ImportHandler;
import com.oscar.core.ProviderImportHandler;
import com.oscar.core.QueryExecutor;
import com.oscar.dispatcher.entity.DispatchConnection;
import com.oscar.fastpath.Fastpath;
import com.oscar.gis.OscarBox;
import com.oscar.gis.OscarBox2d;
import com.oscar.gis.OscarBox3d;
import com.oscar.gis.OscarCircle;
import com.oscar.gis.OscarGeography;
import com.oscar.gis.OscarGeometry;
import com.oscar.gis.OscarLine;
import com.oscar.gis.OscarLseg;
import com.oscar.gis.OscarObject;
import com.oscar.gis.OscarPath;
import com.oscar.gis.OscarPoint;
import com.oscar.gis.OscarPolygon;
import com.oscar.jdbc.ConnectionArray;
import com.oscar.jdbc.EscapeProcessor;
import com.oscar.jdbc.EscapeProcessorResult;
import com.oscar.jdbc.ExceptionUtil;
import com.oscar.jdbc.OSCARSavepoint;
import com.oscar.jdbc.OSCARTransfer;
import com.oscar.jdbc.OscarBfile;
import com.oscar.jdbc.OscarBlob;
import com.oscar.jdbc.OscarCallableStatement;
import com.oscar.jdbc.OscarCallableStatementV2;
import com.oscar.jdbc.OscarClob;
import com.oscar.jdbc.OscarDatabaseMetaData;
import com.oscar.jdbc.OscarExportHandler;
import com.oscar.jdbc.OscarImportHandler;
import com.oscar.jdbc.OscarPreparedStatement;
import com.oscar.jdbc.OscarPreparedStatementV2;
import com.oscar.jdbc.OscarProviderImportHandle;
import com.oscar.jdbc.OscarSQLXML;
import com.oscar.jdbc.OscarStatement;
import com.oscar.jdbc.OscarStatementV2;
import com.oscar.jdbc.StringUtils;
import com.oscar.jdbcx.optional.PooledConnectionImpl;
import com.oscar.protocol.OSCARProtocol;
import com.oscar.protocol.OSCARProtocolV2;
import com.oscar.protocol.ProtocolManager;
import com.oscar.protocol.ProtocolVersion;
import com.oscar.protocol.packets.BasePacket;
import com.oscar.util.ImportBufferManager;
import com.oscar.util.LRUStatementCache;
import com.oscar.util.LRUStatementCacheV2;
import com.oscar.util.OSQLException;
import com.oscar.util.VersionConfig;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketException;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLPermission;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import javax.sql.StatementEventListener;

public class OscarJdbc2Connection
implements BaseConnection,
Connection {
    public Integer sessionID = -1;
    protected BaseStatement stmt;
    protected OSCARProtocol protocol;
    protected boolean compressTransfer = false;
    private Connection masterConnection = null;
    protected final Properties _clientInfo;
    private final String[] clientPro = new String[]{"ApplicationName", "ClientUser", "ClientHostname"};
    protected long randNum;
    protected static final int KEY1 = 1103515245;
    protected static final int KEY2 = 12345;
    protected static final int KEY_MAX = 0x40000000;
    protected ProtocolVersion version = null;
    protected int pid = -1;
    protected int ckey = -1;
    private Encoding clientEncoding = Encoding.defaultEncoding();
    private Encoding dbEncoding = null;
    protected boolean autoCommit = true;
    private boolean readOnly = false;
    private boolean inTransaction = false;
    private Driver this_driver;
    private String this_url;
    private String cursor = null;
    private Fastpath fastpath = null;
    protected int holdability = 2;
    protected Vector<byte[]> planIDVec;
    protected Vector<String> cursorVec;
    protected DatabaseMetaData metadata;
    protected volatile boolean closed;
    public SQLWarning warnings = null;
    private int isolationLevel = 2;
    protected int preparedCacheSize = 0;
    protected boolean compatibleOracle = false;
    protected boolean notRealPrepare = false;
    protected boolean verifyPoolConnection = false;
    ProtocolManager protocolManager = null;
    protected int statementFetchSize = 16;
    private Properties connectionProperty = null;
    private static ConcurrentMap<Integer, Integer> sqlTypeCache = new ConcurrentHashMap<Integer, Integer>();
    private static ConcurrentMap<Integer, String> DBTypeCache = new ConcurrentHashMap<Integer, String>();
    private static ConcurrentMap<String, Integer> typeOidCache = new ConcurrentHashMap<String, Integer>();
    private static ConcurrentMap<String, Integer> jdbcTypes = new ConcurrentHashMap<String, Integer>();
    private static ConcurrentMap<Integer, Integer> oscarTypeCache = new ConcurrentHashMap<Integer, Integer>();
    private static ConcurrentMap<String, Class<? extends OscarObject>> DBTypeClassCache = new ConcurrentHashMap<String, Class<? extends OscarObject>>();
    private byte[] hdSymEncryptKey;
    protected int timeOut_MilliSecond = 0;
    private final QueryExecutor executor;
    private int batchBufferSize = 0;
    private int endianType = 1;
    protected boolean netDataByStr = false;
    protected boolean numericKeepPrecision = true;
    protected boolean compatibleOldProtocol = false;
    protected boolean receiveStringByLen = true;
    protected boolean prepareSimpleExecute = true;
    protected LRUStatementCache statementCache = null;
    protected int lobDisplayMaxSize = -1;
    protected boolean logFlag = Driver.getLogLevel() >= 2;
    protected boolean stLogFlag = Driver.getLogLevel() >= 1;
    protected int batchCount = 0;
    protected boolean useAsynBatch = false;
    protected List<Statement> stList;
    private boolean isClearSt = false;
    private long lsnValue = 0L;
    private int transStatus;
    private DispatchConnection dispatchConn = null;
    private String validTestString;
    protected boolean isSlave = false;
    private boolean checkDBLinkSql = false;
    private List<StatementEventListener> statementListeners = new LinkedList<StatementEventListener>();
    private PooledConnectionImpl pc;
    private boolean sendBinaryTypeAsHex = false;
    private int clusterImportNodeRetryTime = 0;
    private Cluster cluster = null;
    private long sleepEndTime = 0L;
    private static final SQLPermission SET_NETWORK_TIMEOUT_PERM = new SQLPermission("setNetworkTimeout");
    private static final SQLPermission ABORT_PERM = new SQLPermission("abort");
    private String[] searchPath = null;
    private boolean supportAuto = true;
    private boolean supportGenerated = true;
    private final Map<FieldMetadata.Key, FieldMetadata> fieldMetadataCache = new HashMap<FieldMetadata.Key, FieldMetadata>();
    private Calendar calendar;
    private static final int AUTO_GENERATED_OID = 1;
    private static final int AUTO_GENERATED_COLINDEX = 2;
    private static final int AUTO_GENERATED_COLNAME = 3;
    private boolean enableCe;
    protected Map<String, Class<?>> typemap;

    @Override
    public OSCARProtocol getProtocol() throws SQLException {
        if (this.protocol == null) {
            throw new OSQLException("OSCAR-00211", "08003", 211);
        }
        return this.protocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openConnection(String host, int port, Properties info, String database, String url, Driver driver) throws SQLException {
        String socketTimeout;
        if (this.logFlag) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ", openConnection()");
        }
        this.connectionProperty = info;
        int timeout = 0;
        ImportBufferManager.setMaxUsingBufferSize(Integer.parseInt(info.getProperty("MAXUSINGBUFFERSIZE", "5120")));
        if (info.getProperty("REQUESTTIMEOUT") != null) {
            timeout = Integer.parseInt(info.getProperty("REQUESTTIMEOUT"));
        }
        if ((socketTimeout = info.getProperty("SOCKETTIMEOUT")) != null) {
            timeout = Integer.parseInt(socketTimeout);
        }
        if (timeout > 0 && timeout != this.timeOut_MilliSecond) {
            this.timeOut_MilliSecond = timeout;
        }
        int batchcount = 0;
        if (info.getProperty("BATCHCOUNT") != null) {
            batchcount = Integer.parseInt(info.getProperty("BATCHCOUNT"));
        }
        if (batchcount > 0) {
            this.batchCount = batchcount;
        }
        this.useAsynBatch = Boolean.valueOf(info.getProperty("USEASYNBATCH", "false"));
        String authType = info.getProperty("AUTH_TYPE", "PW");
        if (info.getProperty("OSAUTHEN", "f").equalsIgnoreCase("t")) {
            info.setProperty("AUTH_TYPE", "OS");
            authType = "OS";
        }
        if (!(authType.equalsIgnoreCase("PW") || authType.equalsIgnoreCase("OS") || authType.equalsIgnoreCase("RA") || authType.equalsIgnoreCase("FP"))) {
            throw new OSQLException("OSCAR-00118", "08001", 118);
        }
        if (authType.equalsIgnoreCase("FP") && (info.get("FINGERPRINT") == null || !(info.get("FINGERPRINT") instanceof byte[]))) {
            throw new OSQLException("OSCAR-00110", "08001", 110);
        }
        if (!authType.equalsIgnoreCase("OS") && info.getProperty("USER") == null) {
            throw new OSQLException("OSCAR-00119", "08001", 119);
        }
        this.this_driver = driver;
        this.this_url = url;
        this.validTestString = info.getProperty("VALIDTESTSTRING", "select 1");
        this.checkDBLinkSql = Boolean.valueOf(info.getProperty("CHECKDBLINKSQL", "false"));
        this.sendBinaryTypeAsHex = Boolean.valueOf(info.getProperty("SENDBINARYTYPEASHEX", "false"));
        this.clientEncoding = Encoding.getEncoding(System.getProperty("file.encoding"));
        this.compatibleOldProtocol = Boolean.valueOf(info.getProperty("COMPATIBLEOLDPROTOCOL", "false"));
        this.receiveStringByLen = Boolean.valueOf(info.getProperty("RECEIVESTRINGBYLEN", "true"));
        this.verifyPoolConnection = Boolean.valueOf(info.getProperty("VERIFYPOOLCONNECTION", "false"));
        try {
            this.protocolManager = this.timeOut_MilliSecond > 0 ? new ProtocolManager(this, host, port, database, info.getProperty("USER"), info, this.timeOut_MilliSecond) : new ProtocolManager(this, host, port, database, info.getProperty("USER"), info);
            boolean useSSL = false;
            if (info.getProperty("SSL", "f").equals("t") && Driver.sslEnabled()) {
                useSSL = true;
            }
            this.protocolManager.startup(useSSL, this.compatibleOldProtocol);
            this.protocol = this.protocolManager.createProtocol(this.compatibleOldProtocol);
            this.enableCe = Boolean.valueOf(this.connectionProperty.getProperty("ENABLE_CE")) != false && this.version.getProtocolType() >= 5;
        }
        catch (ConnectException ex) {
            Driver.writeLog("create socket timeout,", ex);
            throw new OSQLException("OSCAR-00201", "08001", 201, ex.getMessage(), ex);
        }
        catch (IOException e) {
            Driver.writeLog("create socket failed,", e);
            throw new OSQLException("OSCAR-00201", "08001", 201, e.getMessage(), e);
        }
        catch (SQLException e) {
            Driver.writeLog("new connection failed,", e);
            if (this.protocolManager.getoStream() != null) {
                try {
                    this.protocolManager.getoStream().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw e;
        }
        try {
            this.openConnectionV2(host, port, info, database, url, driver);
        }
        catch (SQLException ex) {
            try {
                if (this.protocol != null) {
                    this.protocol.close();
                }
            }
            catch (SQLException sQLException) {
            }
            catch (IOException iOException) {
            }
            finally {
                this.protocol = null;
            }
            throw ex;
        }
    }

    private void openConnectionV2(String host, int port, Properties info, String database, String url, Driver d) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ", openConnectionV2()");
        }
        if (this.protocol != null) {
            boolean extentedQueryProtocol;
            this.pid = this.protocol.getPID();
            this.ckey = this.protocol.getCKEY();
            this.setDBEncoding();
            this.prepareSimpleExecute = Boolean.valueOf(info.getProperty("PREPARESIMPLEEXECUTE", "true"));
            if (this.getProtocolVersion().getProtocolType() >= 2) {
                this.netDataByStr = Boolean.valueOf(info.getProperty("NETDATABYSTR", "false"));
                if (this.netDataByStr) {
                    this.execSQL("SET NET_DATA_BY_STR=TRUE");
                } else {
                    this.execSQL("SET NET_DATA_BY_STR=FALSE");
                }
                if (!this.netDataByStr) {
                    this.numericKeepPrecision = Boolean.valueOf(info.getProperty("NUMERICKEEPPRECISION", "true"));
                    if (this.numericKeepPrecision) {
                        this.execSQL("SET SEND_FLOATINGNUMBER_KEEP_PRECISION=TRUE");
                    } else {
                        this.execSQL("SET SEND_FLOATINGNUMBER_KEEP_PRECISION=FALSE");
                    }
                }
            }
            this.setTransactionIsolation(2);
            this.execSQL("SET AUTOCOMMIT TO TRUE");
            this.execSQL("SET DISPLAY_LOBLOCATOR=ON");
            this.batchBufferSize = Integer.parseInt(info.getProperty("BATCHBUFFERSIZE", "128"));
            if (this.batchBufferSize > 0x100000) {
                this.batchBufferSize = 0x100000;
            } else if (this.batchBufferSize < 1) {
                this.batchBufferSize = 1;
            }
            this.preparedCacheSize = Integer.parseInt(info.getProperty("PREPARECACHESIZE", "0"));
            if (this.preparedCacheSize > 0) {
                this.setStatementCacheSize(this.preparedCacheSize);
                this.setImplicitCachingEnabled(true);
            }
            this.compatibleOracle = Boolean.valueOf(info.getProperty("COMPATIBLEORACLE", "false"));
            this.notRealPrepare = Boolean.valueOf(info.getProperty("NOTREALPREPARE", "false"));
            boolean stmtRollback = Boolean.valueOf(info.getProperty("STMTROLLBACK", "true"));
            try {
                if (stmtRollback) {
                    this.execSQL("SET STMT_ROLLBACK=1");
                } else {
                    this.execSQL("SET STMT_ROLLBACK=0");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String currentSchema = info.getProperty("CURRENTSCHEMA");
            if (!StringUtils.isNullOrEmpty(currentSchema)) {
                this.setSchema(currentSchema);
            }
            this.statementFetchSize = Integer.parseInt(info.getProperty("FETCHSIZE", "16"));
            if (this.statementFetchSize > 5000) {
                this.statementFetchSize = 5000;
            }
            if (this.statementFetchSize < 0) {
                this.statementFetchSize = 0;
            }
            if ((extentedQueryProtocol = Boolean.valueOf(info.getProperty("EXTENTEDQUERYPROTOCOL", "false")).booleanValue()) && this.version.isMpp5()) {
                try {
                    this.execSQL("SET ENABLE_EXTENTED_QUERY_PROTOCOL=TRUE");
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            this.lobDisplayMaxSize = this.getLobDisplayMaxSize();
            this.isClearSt = Boolean.valueOf(info.getProperty("CLEANSTATEMENT", "false"));
            String timeZone = info.getProperty("SERVERTIMEZONE", "GMT+8");
            this.calendar = Calendar.getInstance(TimeZone.getTimeZone(timeZone));
            this.closed = false;
        }
    }

    @Override
    public boolean isPrepareSimpleExecute() {
        return this.prepareSimpleExecute;
    }

    public OscarJdbc2Connection() {
        this.executor = new QueryExecutor();
        this._clientInfo = new Properties();
    }

    public Driver getDriver() {
        return this.this_driver;
    }

    @Override
    public void addWarning(String msg, String code) {
        if (this.logFlag) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ", addWarning()");
        }
        if (this.warnings != null) {
            this.warnings.setNextWarning(new SQLWarning(msg, code));
        } else {
            this.warnings = new SQLWarning(msg);
        }
    }

    @Override
    public BaseResultSet execSQL(String s) throws SQLException {
        if (this.stLogFlag || this.logFlag) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ", execSQL(String s), paras: " + s);
        }
        return this.execSQL(s, this.getDefaultStatement());
    }

    @Override
    public BaseResultSet execSQL(String s, BaseStatement stmt) throws SQLException {
        return this.execSQL(s, stmt, (BaseResultSet)stmt.getRealResultSet());
    }

    @Override
    public BaseResultSet execSQL(String s, BaseStatement stmt, BaseResultSet res) throws SQLException {
        try {
            if (this.stLogFlag || this.logFlag) {
                Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ", execSQL(String s, BaseStatement stmt)" + s);
            }
            if (this.protocol == null) {
                throw new OSQLException("OSCAR-00211", "08003", 211);
            }
            int maxRows = stmt.getMaxRows();
            return this.protocol.query(s, maxRows, stmt, res);
        }
        catch (SQLException e) {
            this.checkConnectionClosed(e);
            throw e;
        }
    }

    @Override
    public void setCursorName(String cursor) throws SQLException {
        this.cursor = cursor;
    }

    @Override
    public String getCursorName() throws SQLException {
        return this.cursor;
    }

    public String getURL() {
        return this.this_url;
    }

    public String getUserName() throws SQLException {
        String userNameString = this.connectionProperty.getProperty("USER");
        if (userNameString.length() > 1 && userNameString.charAt(0) == '\"' && userNameString.charAt(userNameString.length() - 1) == '\"') {
            return userNameString.substring(1, userNameString.length() - 1);
        }
        return userNameString.toUpperCase();
    }

    @Override
    public Encoding getClientEncoding() {
        return this.clientEncoding;
    }

    @Override
    public void setClientEncoding(String encode) {
        if (encode == null || "".equals(encode)) {
            return;
        }
        this.clientEncoding = Encoding.getEncoding(encode);
    }

    @Override
    public Encoding getEncoding() {
        return this.dbEncoding;
    }

    @Override
    public Fastpath getFastpathAPI() throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ", getFastpathAPI()");
        }
        if (this.fastpath == null) {
            this.fastpath = new Fastpath(this);
        }
        return this.fastpath;
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ", close()");
        }
        if (this.closed) {
            return;
        }
        if (this.getImplicitCachingEnabled() && this.getStatementCacheSize() > 0) {
            this.statementCache.close();
        }
        if (this.stList != null && this.stList.size() > 0) {
            for (int i = 0; i < this.stList.size(); ++i) {
                if (this.stList.get(i) == null) continue;
                this.stList.get(i).close();
            }
        }
        this.stmt = null;
        this.clientEncoding = null;
        this.dbEncoding = null;
        this.planIDVec = null;
        this.this_url = null;
        this.cursor = null;
        this.fastpath = null;
        this.metadata = null;
        this.stList = null;
        if (this.protocol != null) {
            try {
                this.protocol.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.protocol = null;
            }
        } else if (this.protocolManager != null && this.protocolManager.getoStream() != null) {
            try {
                this.protocolManager.getoStream().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.cluster != null) {
            this.cluster.close();
        }
        this.cluster = null;
        this.closed = true;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        if (sql == null) {
            return null;
        }
        Object escapedSqlResult = EscapeProcessor.escapeSQL(sql, true);
        if (escapedSqlResult instanceof String) {
            return (String)escapedSqlResult;
        }
        return ((EscapeProcessorResult)escapedSqlResult).escapedSql;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.warnings;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkClosed();
        this.readOnly = readOnly;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkClosed();
        return this.readOnly;
    }

    @Override
    public void setInTranscation(boolean tran) {
        this.inTransaction = tran;
    }

    @Override
    public boolean isInTransaction() {
        return this.inTransaction;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
        if (this.logFlag) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ", setAutoCommit(boolean autoCommit), parameters: " + autoCommit);
        }
        if (this.inTransaction) {
            if (autoCommit) {
                this.execSQL("commit");
            }
        } else if (!autoCommit) {
            this.execSQL("begin");
        }
        this.autoCommit = autoCommit;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        return this.autoCommit;
    }

    @Override
    public void commit() throws SQLException {
        this.checkClosed();
        if (this.logFlag) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ", commit() autoCommit=" + this.autoCommit);
        }
        if (!this.autoCommit) {
            this.closeCursor();
            if (this.holdability == 2) {
                this.releasePlanID();
            }
            this.execSQL("commit");
            try {
                this.execSQL("begin");
            }
            catch (OSQLException oe) {
                oe.setExtraState(1);
                throw oe;
            }
        }
    }

    @Override
    public synchronized void rollback() throws SQLException {
        this.checkClosed();
        if (this.logFlag) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ", rollback()");
        }
        if (!this.autoCommit) {
            this.closeCursor();
            if (this.holdability == 2) {
                this.releasePlanID();
            }
            this.execSQL("rollback");
            this.execSQL("begin");
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        return this.isolationLevel;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkClosed();
        if (this.logFlag) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ", setTransactionIsolation(int level), paras: " + level);
        }
        String isolationLevelSQL = "SET SESSION CHARACTERISTICS AS TRANSACTION ISOLATION LEVEL ";
        switch (level) {
            case 1: {
                isolationLevelSQL = isolationLevelSQL + "READ UNCOMMITTED";
                this.isolationLevel = 1;
                break;
            }
            case 2: {
                isolationLevelSQL = isolationLevelSQL + "READ COMMITTED";
                this.isolationLevel = 2;
                break;
            }
            case 4: {
                isolationLevelSQL = isolationLevelSQL + "REPEATABLE READ";
                this.isolationLevel = 4;
                break;
            }
            case 8: {
                isolationLevelSQL = isolationLevelSQL + "SERIALIZABLE";
                this.isolationLevel = 8;
                break;
            }
            default: {
                throw new OSQLException("OSCAR-00204", "88888", 204);
            }
        }
        this.execSQL(isolationLevelSQL);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkClosed();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public synchronized int getSQLType(int oid) throws SQLException {
        Integer sqlType = (Integer)sqlTypeCache.get(oid);
        if (sqlType == null) {
            String sql = "SELECT typname FROM INFO_SCHEM.sys_type WHERE oid = " + oid;
            BaseResultSet result = this.execSQL(sql);
            if (result.getColumnCount() != 1 || result.getTupleCount() != 1) {
                throw new OSQLException("OSCAR-00205", "88888", 205);
            }
            result.next();
            String DBType = result.getString(1);
            result.close();
            Integer iOid = oid;
            sqlType = this.getSQLType(DBType);
            sqlTypeCache.put(iOid, sqlType);
            DBTypeCache.put(iOid, DBType);
        }
        return sqlType;
    }

    @Override
    public int getOscarType(int oid) throws SQLException {
        Integer sqlType = (Integer)oscarTypeCache.get(oid);
        if (sqlType == null) {
            return 0;
        }
        return sqlType;
    }

    @Override
    public int getDBTypeOid(String typeName) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ", getDBTypeOid(String typeName), paras: " + typeName);
        }
        int oid = -1;
        if (typeName != null) {
            Integer oidValue = (Integer)typeOidCache.get(typeName);
            if (oidValue != null) {
                oid = oidValue;
            } else {
                String sql = "SELECT oid FROM INFO_SCHEM.sys_type WHERE typname='" + typeName + "'";
                BaseResultSet result = this.execSQL(sql);
                if (result.getColumnCount() != 1 || result.getTupleCount() != 1) {
                    throw new OSQLException("OSCAR-00205", "88888", 205);
                }
                result.next();
                oid = Integer.parseInt(result.getString(1));
                typeOidCache.put(typeName, oid);
                result.close();
            }
        }
        return oid;
    }

    @Override
    public synchronized String getDBType(int oid) throws SQLException {
        String DBType;
        if (this.logFlag) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ", getDBType(int oid), paras: " + oid);
        }
        if ((DBType = (String)DBTypeCache.get(oid)) == null) {
            String sql = "SELECT typname FROM INFO_SCHEM.sys_type WHERE oid = " + oid;
            BaseResultSet result = this.execSQL(sql);
            if (result.getColumnCount() != 1 || result.getTupleCount() != 1) {
                throw new OSQLException("OSCAR-00205", "88888", 205);
            }
            result.next();
            DBType = result.getString(1);
            result.close();
            DBTypeCache.put(oid, DBType);
            sqlTypeCache.put(oid, 12);
        }
        return DBType;
    }

    @Override
    public synchronized Class<? extends OscarObject> getOscarObject(String type) {
        if (this.logFlag) {
            Driver.writeLog("session: " + this.sessionID + ", " + OscarJdbc2Connection.class + ", getOscarObject(String type), paras: " + type);
        }
        return (Class)DBTypeClassCache.get(type);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public synchronized int getSQLType(String DBTypeName) {
        int defaultType = 12;
        if (jdbcTypes.get(DBTypeName) != null) {
            defaultType = (Integer)jdbcTypes.get(DBTypeName);
        }
        return defaultType;
    }

    @Override
    public void cancelQuery() throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ", cancelQuery()");
        }
        if (null == this.protocol) {
            return;
        }
        try {
            this.protocol.cancelRequest(this.pid, this.ckey);
        }
        catch (IOException e) {
            throw new OSQLException("OSCAR-00206", "08001", 206, e.getMessage(), e);
        }
    }

    @Override
    public void addCursor(String cursorName) {
        if (this.logFlag) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ", addCursor(String cursorName), paras: " + cursorName);
        }
        if (this.cursorVec == null) {
            this.cursorVec = new Vector();
        }
        if (cursorName != null && !"".equals(cursorName)) {
            this.cursorVec.add(cursorName);
        }
    }

    @Override
    public void addPlanID(byte[] planID) {
        if (this.logFlag && planID != null) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ", addCursor(String cursorName), paras: " + planID[0] + planID[1]);
        }
        if (this.planIDVec == null) {
            this.planIDVec = new Vector();
        }
        int index = -1;
        if (planID != null && (index = this.checkPlanID(planID)) == -1) {
            this.planIDVec.add(planID);
        }
    }

    @Override
    public void removePlanID(int index) {
        if (this.planIDVec != null && 0 <= index && index < this.planIDVec.size()) {
            this.planIDVec.remove(index);
        }
    }

    private synchronized void closeCursor() throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ", closeCursor()");
        }
        if (this.cursorVec != null) {
            StringBuffer sql = new StringBuffer();
            int size = this.cursorVec.size();
            String cursorName = null;
            for (int i = size - 1; i >= 0; --i) {
                cursorName = this.cursorVec.remove(i);
                sql.delete(0, sql.length());
                sql.append("CLOSE ").append(cursorName).append(";DEALLOCATE ").append(cursorName);
                if (this.isClosed()) continue;
                this.execSQL(sql.toString(), this.stmt);
            }
        }
    }

    @Override
    public synchronized void closeCursor(String cursorName, BaseStatement statement) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ", closeCursor(cursorName,statement)");
        }
        if (this.cursorVec != null && this.cursorVec.contains(cursorName)) {
            this.cursorVec.remove(cursorName);
            StringBuffer sql = new StringBuffer();
            sql.delete(0, sql.length());
            sql.append("CLOSE ").append(cursorName).append(";DEALLOCATE ").append(cursorName);
            if (!this.isClosed()) {
                this.execSQL(sql.toString(), this.stmt);
            }
        }
    }

    private void releasePlanID() throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ", releasePlanID()");
        }
        if (this.planIDVec != null) {
            int size = this.planIDVec.size();
            byte[] planID = null;
            for (int i = size - 1; i >= 0; --i) {
                planID = this.planIDVec.remove(i);
                ((OSCARProtocolV2)this.getProtocol()).fetchMore(null, null, null, null, planID, 0, 0, true, false, this.getDefaultStatement(), false);
            }
        }
    }

    @Override
    public void removeCursor(String cursorName) {
        if (this.logFlag) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ", removeCursor(String cursorName), paras: " + cursorName);
        }
        if (this.cursorVec != null) {
            this.cursorVec.remove(cursorName);
        }
    }

    @Override
    public boolean hasCursor(String cursorName) {
        if (this.logFlag) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ", hasCursor(String cursorName), paras: " + cursorName);
        }
        boolean hasCur = false;
        if (this.cursorVec == null) {
            return hasCur;
        }
        if (cursorName == null) {
            return hasCur;
        }
        hasCur = this.cursorVec.contains(cursorName);
        return hasCur;
    }

    @Override
    public BaseStatement getDefaultStatement() throws SQLException {
        if (this.stmt == null) {
            this.stmt = (BaseStatement)((Object)this.createStatement(1003, 1007, this.holdability));
        }
        return this.stmt;
    }

    @Override
    public int getPreapredCacheSize() {
        return this.preparedCacheSize;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1003, 1007);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.typemap;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.typemap = map;
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkClosed();
        if (holdability != 2 && holdability != 1) {
            return;
        }
        this.holdability = holdability;
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkClosed();
        return this.holdability;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkClosed();
        if (this.autoCommit) {
            throw new OSQLException("OSCAR-00208", "25000", 208);
        }
        return OSCARSavepoint.setSavepoint(this);
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkClosed();
        if (this.autoCommit) {
            throw new OSQLException("OSCAR-00208", "25000", 208);
        }
        return OSCARSavepoint.setSavepoint(name, this);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        if (this.autoCommit) {
            throw new OSQLException("OSCAR-00209", "25000", 209);
        }
        OSCARSavepoint.rollbackSavepoint(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        if (this.autoCommit) {
            throw new OSQLException("OSCAR-00209", "25000", 209);
        }
        OSCARSavepoint.releaseSavepoint(savepoint);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, this.getHoldability());
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, this.getHoldability());
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(sql, resultSetType, resultSetConcurrency, this.getHoldability());
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        int autoGeneratedInfo = -1;
        if (autoGeneratedKeys == 2) {
            autoGeneratedInfo = -1;
        } else if (autoGeneratedKeys == 1) {
            autoGeneratedInfo = 1;
        } else {
            throw new OSQLException("OSCAR-00210", "88888", 210);
        }
        PreparedStatement ps = this.prepareStatement(sql);
        ((OscarStatement)((Object)ps)).setAutoGeneratedInfo(autoGeneratedInfo);
        return ps;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        PreparedStatement ps = this.prepareStatement(sql);
        ((OscarStatement)((Object)ps)).setAutoGeneratedInfo(2);
        ((OscarStatement)((Object)ps)).setAutoGeneratedIndexes(columnIndexes);
        return ps;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        PreparedStatement ps = this.prepareStatement(sql);
        ((OscarStatement)((Object)ps)).setAutoGeneratedInfo(3);
        ((OscarStatement)((Object)ps)).setAutoGeneratedNames(columnNames);
        return ps;
    }

    @Override
    public OscarBfile getBfileInstance(String locatorStr) throws SQLException {
        return OscarBfile.createByLocator(this, locatorStr);
    }

    @Override
    public OscarBlob getBlobInstance(String locatorStr) throws SQLException {
        return OscarBlob.createByLocator(this, locatorStr);
    }

    @Override
    public OscarClob getClobInstance(String locatorStr) throws SQLException {
        return OscarClob.createByLocator(this, locatorStr);
    }

    @Override
    public OscarBlob createBlob() throws SQLException {
        return this.createTempBlob(true, 0);
    }

    @Override
    public OscarBlob createTempBlob(boolean cache, int duration) throws SQLException {
        return OscarBlob.createTemporary(this, cache, duration);
    }

    @Override
    public OscarClob createClob() throws SQLException {
        return this.createTempClob(true, 0);
    }

    @Override
    public OscarClob createTempClob(boolean cache, int duration) throws SQLException {
        return OscarClob.createTemporary(this, cache, duration);
    }

    @Override
    public OSCARTransfer getTransfer() {
        return new OSCARTransfer(this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        if (this.logFlag) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ",createStatement, paras: resultSetType: " + resultSetType + ", concurrency: " + resultSetConcurrency + ", holdability: " + resultSetHoldability);
        }
        if (resultSetType != 1003 && resultSetType != 1004 && resultSetType != 1005) {
            throw new OSQLException("OSCAR-00422", "88888", 422);
        }
        if (resultSetConcurrency != 1007 && resultSetConcurrency != 1008) {
            throw new OSQLException("OSCAR-00423", "88888", 423);
        }
        if (resultSetHoldability != 2 && resultSetHoldability != 1) {
            throw new OSQLException("OSCAR-00207", "88888", 207);
        }
        if (this.stList == null) {
            this.stList = new LinkedList<Statement>();
        }
        if (this.version.getProtocolType() == 1) {
            OscarStatement s = new OscarStatement(this);
            s.setResultSetType(resultSetType);
            s.setResultSetConcurrency(resultSetConcurrency);
            s.setResultSetHoldability(resultSetHoldability);
            s.setFetchSize(this.statementFetchSize);
            this.setHoldability(resultSetHoldability);
            if (this.isClearSt) {
                this.stList.add(s);
            }
            return s;
        }
        OscarStatementV2 s = new OscarStatementV2(this);
        s.setResultSetType(resultSetType);
        s.setResultSetConcurrency(resultSetConcurrency);
        s.setResultSetHoldability(resultSetHoldability);
        s.setFetchSize(this.statementFetchSize);
        this.setHoldability(resultSetHoldability);
        if (this.isClearSt) {
            this.stList.add(s);
        }
        return s;
    }

    boolean isValidPrepare(String prepareName) throws SQLException {
        if (this.isClosed()) {
            return false;
        }
        int paraCount = 1;
        int[] paraLength = new int[paraCount];
        Object[] paraValue = new Object[paraCount];
        paraValue[0] = prepareName.getBytes();
        paraLength[0] = ((byte[])paraValue[0]).length;
        Object[] result = this.getProtocol().functionCall(4638, paraCount, paraLength, paraValue);
        if (!((Boolean)result[0]).booleanValue()) {
            int sz = (Integer)result[1];
            Integer isValid = BasePacket.bytesToIntR((byte[])result[2], sz);
            return isValid.equals(1);
        }
        return false;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        sql = sql.trim();
        if (this.stLogFlag || this.logFlag) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ",prepareStatement, paras: sql: " + sql + ", resultSetType: " + resultSetType + ", concurrency: " + resultSetConcurrency + ", holdability: " + resultSetHoldability);
        }
        if (resultSetType != 1003 && resultSetType != 1004 && resultSetType != 1005) {
            throw new OSQLException("OSCAR-00422", "88888", 422);
        }
        if (resultSetConcurrency != 1007 && resultSetConcurrency != 1008) {
            throw new OSQLException("OSCAR-00423", "88888", 423);
        }
        if (resultSetHoldability != 2 && resultSetHoldability != 1) {
            resultSetHoldability = 2;
        }
        if (this.stList == null) {
            this.stList = new LinkedList<Statement>();
        }
        if (this.version.getProtocolType() == 1) {
            OscarPreparedStatement s = null;
            if (this.statementCache != null) {
                s = (OscarPreparedStatement)this.statementCache.searchImplicitCache(sql, 1, resultSetType);
            }
            if (s == null) {
                s = OscarStatement.getPreparedInstance(this, sql);
                if (resultSetConcurrency == 1008) {
                    s.setUseTid(true);
                }
                if (s.isNotSupportPrePare()) {
                    if (this.isClearSt) {
                        this.stList.add(s);
                    }
                    return s;
                }
                s.prepare();
            }
            s.setFetchSize(this.statementFetchSize);
            s.setResultSetType(resultSetType);
            s.setResultSetConcurrency(resultSetConcurrency);
            s.setResultSetHoldability(resultSetHoldability);
            if (this.isClearSt) {
                this.stList.add(s);
            }
            return s;
        }
        OscarPreparedStatementV2 s = null;
        if (this.statementCache != null) {
            s = (OscarPreparedStatementV2)this.statementCache.searchImplicitCache(sql, 1, resultSetType);
        }
        if (s == null) {
            s = OscarStatement.getPreparedInstanceV2(this, sql);
            if (resultSetConcurrency == 1008) {
                s.setUseTid(true);
            }
            if (s.isNotSupportPrePare()) {
                if (this.isClearSt) {
                    this.stList.add(s);
                }
                return s;
            }
            s.prepare();
        }
        s.setFetchSize(this.statementFetchSize);
        s.setResultSetType(resultSetType);
        s.setResultSetConcurrency(resultSetConcurrency);
        s.setResultSetHoldability(resultSetHoldability);
        s.setLobDisplayMaxSize(this.lobDisplayMaxSize);
        if (this.isClearSt) {
            this.stList.add(s);
        }
        return s;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        if (resultSetType != 1003 && resultSetType != 1004 && resultSetType != 1005) {
            throw new OSQLException("OSCAR-00422", "88888", 422);
        }
        if (resultSetConcurrency != 1007 && resultSetConcurrency != 1008) {
            throw new OSQLException("OSCAR-00423", "88888", 423);
        }
        if (resultSetHoldability != 2 && resultSetHoldability != 1) {
            throw new OSQLException("OSCAR-00207", "88888", 207);
        }
        if (this.stList == null) {
            this.stList = new LinkedList<Statement>();
        }
        if (this.version.getProtocolType() == 1) {
            OscarCallableStatement s = new OscarCallableStatement(this, sql);
            s.setResultSetType(resultSetType);
            s.setResultSetConcurrency(resultSetConcurrency);
            s.setResultSetHoldability(resultSetHoldability);
            s.setFetchSize(this.statementFetchSize);
            this.setHoldability(resultSetHoldability);
            s.prepare();
            if (this.isClearSt) {
                this.stList.add(s);
            }
            return s;
        }
        OscarCallableStatementV2 s = new OscarCallableStatementV2(this, sql);
        s.setResultSetType(resultSetType);
        s.setResultSetConcurrency(resultSetConcurrency);
        s.setResultSetHoldability(resultSetHoldability);
        s.setFetchSize(this.statementFetchSize);
        this.setHoldability(resultSetHoldability);
        s.prepare();
        s.setLobDisplayMaxSize(this.lobDisplayMaxSize);
        if (this.isClearSt) {
            this.stList.add(s);
        }
        return s;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (this.metadata == null) {
            this.metadata = new OscarDatabaseMetaData(this);
        }
        return this.metadata;
    }

    @Override
    public long getAccessHandle() {
        this.randNum = (this.randNum * 1103515245L + 12345L) % 0x40000000L;
        return this.randNum;
    }

    @Override
    public void setSeed(long seed) {
        this.randNum = seed % 0x40000000L;
    }

    @Override
    public VersionConfig getVersion() {
        return this.version.getVersion();
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.version;
    }

    @Override
    public void setVersion(ProtocolVersion version) {
        this.version = version;
    }

    @Override
    public boolean isUsePrepareCache() {
        return this.preparedCacheSize > 0;
    }

    @Override
    public boolean isCompatibleOracle() {
        return this.compatibleOracle;
    }

    public void setCompatibleOracle(boolean compatibleOracle) {
        this.compatibleOracle = compatibleOracle;
    }

    @Override
    public boolean isNotRealPrepare() {
        return this.notRealPrepare;
    }

    @Override
    public QueryExecutor getQueryExecutor() {
        return this.executor;
    }

    public int getStatementFetchSize() {
        return this.statementFetchSize;
    }

    @Override
    public boolean isCompressTransfer() {
        return this.compressTransfer;
    }

    @Override
    public void setCompressTransfer(boolean compressTransfer) {
    }

    @Override
    public ImportHandler createImportHandler(String tableName) throws SQLException {
        if (this.getProtocolVersion().isMpp5()) {
            return this.createDistributeImportHandler(tableName);
        }
        return new OscarImportHandler(this, null, tableName);
    }

    @Override
    public ImportHandler createImportHandler() throws SQLException {
        return new OscarImportHandler(this);
    }

    @Override
    public ImportHandler createImportHandler(String schemName, String tableName) throws SQLException {
        if (this.getProtocolVersion().isMpp5()) {
            return this.createDistributeImportHandler(schemName, tableName);
        }
        return new OscarImportHandler(this, schemName, tableName);
    }

    @Override
    public ProviderImportHandler createProviderImportHandler(String tableName) throws SQLException {
        return new OscarProviderImportHandle(this, tableName);
    }

    @Override
    public ProviderImportHandler createProviderImportHandler(String schemName, String tableName) throws SQLException {
        return new OscarProviderImportHandle(this, schemName, tableName);
    }

    @Override
    public ExportHandler createExportHandler() throws SQLException {
        return new OscarExportHandler(this);
    }

    @Override
    public int getBatchBufferSize() {
        return this.batchBufferSize;
    }

    @Override
    public void setBatchBufferSize(int defaultBatchBufferSize) {
        if (defaultBatchBufferSize > 0x100000) {
            defaultBatchBufferSize = 0x100000;
        } else if (defaultBatchBufferSize < 1) {
            defaultBatchBufferSize = 1;
        }
        this.batchBufferSize = defaultBatchBufferSize;
    }

    @Override
    public int getEndianType() {
        return this.endianType;
    }

    @Override
    public void setEndianType(int endianType) {
        this.endianType = endianType;
    }

    @Override
    public int checkPlanID(byte[] planID) {
        if (this.planIDVec != null) {
            byte[] tmp = null;
            for (int i = 0; i < this.planIDVec.size(); ++i) {
                tmp = this.planIDVec.get(i);
                if (!Arrays.equals(planID, tmp)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public Integer getSessionID() {
        return this.sessionID;
    }

    @Override
    public int getPlanID() {
        return this.pid;
    }

    public int getCkey() {
        return this.ckey;
    }

    @Override
    public boolean isNetDataByStr() {
        return this.netDataByStr;
    }

    @Override
    public boolean isNumericKeepPrecision() {
        return this.numericKeepPrecision;
    }

    public int getStatementCacheSize() throws SQLException {
        return this.statementCache.getCacheSize();
    }

    public void setStatementCacheSize(int size) throws SQLException {
        if (this.statementCache == null) {
            this.statementCache = this.version.getProtocolType() == 1 ? new LRUStatementCache(size) : new LRUStatementCacheV2(size);
        } else {
            this.statementCache.resize(size);
        }
    }

    public boolean getImplicitCachingEnabled() throws SQLException {
        if (this.statementCache == null) {
            return false;
        }
        return this.statementCache.getImplicitCachingEnabled();
    }

    public void setImplicitCachingEnabled(boolean cacheEnabled) throws SQLException {
        if (this.statementCache == null) {
            this.statementCache = this.version.getProtocolType() == 1 ? new LRUStatementCache(0) : new LRUStatementCacheV2(0);
        }
        this.statementCache.setImplicitCachingEnabled(cacheEnabled);
    }

    public boolean isStatementCacheInitialized() {
        if (this.statementCache == null) {
            return false;
        }
        return this.statementCache.getCacheSize() != 0;
    }

    public final void purgeStatementCache() throws SQLException {
        if (this.isStatementCacheInitialized()) {
            this.statementCache.purgeImplicitCache();
        }
    }

    public final void closeStatementCache() throws SQLException {
        if (this.isStatementCacheInitialized()) {
            this.statementCache.close();
            this.statementCache = null;
        }
    }

    public synchronized void cacheImplicitStatement(OscarPreparedStatement paramOraclePreparedStatement, String sql, int statementType, int resultSetType) throws SQLException {
        if (this.statementCache == null) {
            throw new SQLException("The statement cache is not enabled.", "");
        }
        this.statementCache.addToImplicitCache(paramOraclePreparedStatement, sql, statementType, resultSetType);
    }

    public synchronized void cacheImplicitStatement(OscarPreparedStatementV2 paramOraclePreparedStatementV2, String sql, int statementType, int resultSetType) throws SQLException {
        if (this.statementCache == null) {
            throw new SQLException("The statement cache is not enabled.", "");
        }
        this.statementCache.addToImplicitCache(paramOraclePreparedStatementV2, sql, statementType, resultSetType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getLobDisplayMaxSize() {
        if (this.lobDisplayMaxSize == -1) {
            ResultSet rs = null;
            Statement temp = null;
            try {
                temp = this.createStatement();
                rs = this.execSQL("show LOB_DISPLAY_MAX_SIZE", (BaseStatement)((Object)temp));
                this.lobDisplayMaxSize = rs.next() ? rs.getInt(2) : 4000;
            }
            catch (SQLException sqle) {
                this.lobDisplayMaxSize = 4000;
            }
            catch (Exception e) {
                this.lobDisplayMaxSize = 4000;
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception sqle) {}
                }
                if (temp != null) {
                    try {
                        temp.close();
                    }
                    catch (Exception sqle) {}
                }
            }
        }
        return this.lobDisplayMaxSize;
    }

    @Override
    public boolean isTcpKeepAlive() {
        boolean tcpKeepAlive = false;
        Socket currentSocket = this.protocol.oStream.getCurrentSocket();
        if (currentSocket != null) {
            try {
                tcpKeepAlive = currentSocket.getKeepAlive();
            }
            catch (SocketException e) {
                Driver.writeLog(e.getMessage());
            }
        }
        return tcpKeepAlive;
    }

    @Override
    public void setTcpKeepAlive(boolean tcpKeepAlive) {
        Socket currentSocket = this.protocol.oStream.getCurrentSocket();
        if (currentSocket != null) {
            try {
                currentSocket.setKeepAlive(tcpKeepAlive);
            }
            catch (SocketException e) {
                Driver.writeLog(e.getMessage());
            }
        }
    }

    @Override
    public boolean isValidate() {
        return this.isValidate(1000);
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new OSQLException("OSCAR-00124", "88888", 124);
        }
        if (this.logFlag) {
            Driver.writeLog("isValid(int timeout) start, timeout=" + timeout);
        }
        return this.isValidate(timeout * 1000);
    }

    @Override
    public boolean isValid() throws SQLException {
        return this.isValid(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValidate(int timeout) {
        if (this.closed) {
            return false;
        }
        Statement stmt = null;
        boolean isValidate = false;
        try {
            if (this.logFlag) {
                Driver.writeLog("isValidate(int timeout) start, timeout(ms)=" + timeout);
            }
            this.protocol.oStream.setSocketTimeOut(timeout);
            stmt = this.createStatement();
            stmt.execute(this.validTestString);
            this.protocol.oStream.setSocketTimeOut(this.timeOut_MilliSecond);
            isValidate = true;
            if (this.logFlag) {
                Driver.writeLog("isValidate(int timeout): connection is valid");
            }
        }
        catch (SocketException e) {
            if (this.logFlag) {
                Driver.writeLog("isValidate(int timeout): SocketException " + e.getMessage());
            }
        }
        catch (SQLException e) {
            if (this.logFlag) {
                Driver.writeLog("isValidate(int timeout): SQLException" + e.getMessage());
            }
        }
        finally {
            block22: {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!this.logFlag) break block22;
                    Driver.writeLog("isValidate(int timeout):close statement SQLException" + e.getMessage());
                }
            }
        }
        return isValidate;
    }

    @Override
    public boolean isVerifyPoolConnection() {
        return this.verifyPoolConnection;
    }

    protected void setDBEncoding() throws SQLException {
        ResultSet rs = null;
        Statement temp = null;
        try {
            temp = this.createStatement();
            rs = this.execSQL("select ENCODING from v_sys_database ", (BaseStatement)((Object)temp));
            this.dbEncoding = rs != null && rs.next() ? Encoding.getEncoding(rs.getInt(1)) : this.clientEncoding;
        }
        catch (UnsupportedEncodingException e) {
            throw new OSQLException("OSCAR-00903", "88888", 903);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (temp != null) {
                try {
                    temp.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public int getBatchCount() {
        return this.batchCount;
    }

    @Override
    public boolean isUseAsynBatch() {
        return this.useAsynBatch;
    }

    @Override
    public boolean isReceiveStringByLen() {
        return this.receiveStringByLen;
    }

    @Override
    public void setMasterConnection(Connection conn) {
        this.masterConnection = conn;
    }

    @Override
    public Connection getMasterConnection() {
        if (this.masterConnection == null) {
            return this;
        }
        return this.masterConnection;
    }

    @Override
    public Properties getConnectionProperties() {
        return this.connectionProperty;
    }

    public long getLsnValue() {
        return this.lsnValue;
    }

    public void setLsnValue(long lsnValue) {
        this.lsnValue = lsnValue;
    }

    @Override
    public void setTransStatus(int transStatus) {
        this.transStatus = transStatus;
    }

    @Override
    public int getTransStatus() {
        return this.transStatus;
    }

    public DispatchConnection getDispatchConn() {
        return this.dispatchConn;
    }

    public void setDispatchConn(DispatchConnection dispatchConn) {
        this.dispatchConn = dispatchConn;
    }

    @Override
    public boolean isSlave() {
        return this.isSlave;
    }

    @Override
    public void setIsSlave(boolean isSlave) {
        this.isSlave = isSlave;
    }

    @Override
    public <T> T unwrap(Class<T> paramClass) throws SQLException {
        if (paramClass.isAssignableFrom(this.getClass())) {
            return paramClass.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + paramClass.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> paramClass) throws SQLException {
        return paramClass.isAssignableFrom(this.getClass());
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return new ConnectionArray(this, typeName, elements);
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("This connection has been closed.");
        }
        return new OscarSQLXML(this);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("This connection has been closed.");
        }
        throw Driver.notImplemented();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("This connection has been closed.");
        }
        return this._clientInfo;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("This connection has been closed.");
        }
        return this._clientInfo.getProperty(name);
    }

    @Override
    public void setClientInfo(Properties pro) throws SQLClientInfoException {
        if (pro != null) {
            for (String name : this.clientPro) {
                this.setClientInfo(name, pro.getProperty(name, null));
            }
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        if (this.closed) {
            throw new SQLClientInfoException("This connection has been closed.", null);
        }
        if (this.clientPro[0].equals(name) || this.clientPro[1].equals(name) || this.clientPro[2].equals(name)) {
            if (value == null) {
                this._clientInfo.remove(name);
            } else {
                this._clientInfo.put(name, value);
            }
            return;
        }
        this.addWarning("ClientInfo property not supported.", "0A000");
    }

    public void setStatementListeners(List<StatementEventListener> statementListeners) {
        this.statementListeners = statementListeners;
    }

    @Override
    public List<StatementEventListener> getStatementListeners() {
        return this.statementListeners;
    }

    @Override
    public PooledConnectionImpl getPc() {
        return this.pc;
    }

    public void setPc(PooledConnectionImpl pc) {
        this.pc = pc;
    }

    @Override
    public boolean checkDBLinkSql() {
        return this.checkDBLinkSql;
    }

    @Override
    public boolean sendBinaryTypeAsHex() {
        return this.sendBinaryTypeAsHex;
    }

    void checkConnectionClosed(Exception e) {
        switch (ExceptionUtil.isConnectionClosed(e)) {
            case 1: {
                try {
                    this.close();
                }
                catch (SQLException e1) {
                    if (this.stLogFlag) {
                        Driver.writeLog("OscarJdbc2Connection checkConnectionClosed() ::" + e1.getMessage());
                    }
                    this.closed = true;
                }
                break;
            }
            case 2: {
                this.closed = true;
                break;
            }
        }
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        BaseResultSet pathRs;
        this.checkClosed();
        if (schema == null) {
            throw new SQLException("Schema name can not be null!");
        }
        if (this.searchPath == null && (pathRs = this.execSQL("SHOW SEARCH_PATH")).next()) {
            this.searchPath = pathRs.getString(2).split(",");
        }
        ArrayList<String> total = new ArrayList<String>();
        total.add(schema);
        if (this.searchPath != null) {
            for (String path : this.searchPath) {
                if (total.contains(path)) continue;
                total.add(path);
            }
        }
        StringBuilder sb = new StringBuilder("SET SEARCH_PATH=");
        for (String path : total) {
            if (path == null || path.length() <= 0) continue;
            sb.append("'").append(path.trim()).append("'");
            sb.append(",");
        }
        this.execSQL(sb.deleteCharAt(sb.length() - 1).toString());
    }

    @Override
    public byte[] getHdSymEncryptKey() {
        return this.hdSymEncryptKey;
    }

    @Override
    public void setHdSymEncryptKey(byte[] key) {
        this.hdSymEncryptKey = key;
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkClosed();
        String sql = "select current_schema();";
        String schema = null;
        try (BaseResultSet rs = null;){
            rs = this.execSQL(sql);
            if (rs.next()) {
                schema = rs.getString(1);
            }
        }
        return schema;
    }

    @Override
    public DistributeImportHandler createDistributeImportHandler(String schemName, String tableName) throws SQLException {
        return new ClusterImportHandler(this, schemName, tableName);
    }

    @Override
    public DistributeImportHandler createDistributeImportHandler(String tableName) throws SQLException {
        return new ClusterImportHandler(this, null, tableName);
    }

    @Override
    public void setClusterImportNodeRetryTime(int time) {
        this.clusterImportNodeRetryTime = time;
    }

    @Override
    public int getClusterImportNodeRetryTime() {
        return this.clusterImportNodeRetryTime;
    }

    public long getSleepEndTime() {
        return this.sleepEndTime;
    }

    @Override
    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    @Override
    public Cluster getCluster() {
        return this.cluster;
    }

    public void setSleepEndTime(long sleepEndTime) {
        this.sleepEndTime = sleepEndTime;
    }

    public List<Statement> getStList() {
        return this.stList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMaster() {
        boolean isMaster = false;
        BaseResultSet rs = null;
        try {
            rs = this.execSQL("select * from info_schem.v_sys_ha_slave_info");
            if (rs.next()) {
                isMaster = true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return isMaster;
    }

    @Override
    public final void abort(Executor executor) throws SQLException {
        SecurityManager sec = System.getSecurityManager();
        if (sec != null) {
            sec.checkPermission(ABORT_PERM);
        }
        if (executor == null) {
            throw new SQLException("Executor can not be null");
        }
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    OscarJdbc2Connection.this.close();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Override
    public final void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.checkClosed();
        if (milliseconds < 0) {
            throw new OSQLException("OSCAR-00124", "88888", 124);
        }
        SecurityManager sec = System.getSecurityManager();
        if (sec != null) {
            sec.checkPermission(SET_NETWORK_TIMEOUT_PERM);
        }
        try {
            this.protocol.oStream.getCurrentSocket().setSoTimeout(milliseconds);
            this.timeOut_MilliSecond = milliseconds;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.timeOut_MilliSecond;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Map<String, String>> initSlavesInfo(Properties props) {
        HashMap<String, Map<String, String>> slaveConnInfo = new HashMap<String, Map<String, String>>();
        ResultSet rs = null;
        StringBuilder sb = new StringBuilder(OscarJdbc2Connection.class + ", initSlavesInfo(), ");
        try {
            boolean useAsynchronousNode = Boolean.valueOf(props.getProperty("USEASYNCHRONOUSNODE", "false"));
            boolean useNonSynchronized = Boolean.valueOf(props.getProperty("USENONSYNCHRONIZED", "true"));
            StringBuilder sql = new StringBuilder("SELECT ADDRESS, PORT FROM INFO_SCHEM.V_SYS_HA_SLAVE_INFO WHERE READABLE = TRUE ");
            if (useNonSynchronized) {
                sb.append(" useNonSynchronized=true, ");
            } else {
                sql.append(" AND SYNCHRONIZED = TRUE");
                sb.append(" useNonSynchronized=false, ");
            }
            if (useAsynchronousNode) {
                sb.append(" useAsynchronousNode=true, slave nodes: ");
            } else {
                sql.append(" AND SYNCLOG = TRUE");
                sb.append(" useAsynchronousNode=false, slave nodes:");
            }
            rs = this.execSQL(sql.toString());
            int index = 0;
            while (rs.next()) {
                String key = "slave" + index;
                HashMap<String, String> info = new HashMap<String, String>();
                slaveConnInfo.put(key, info);
                info.put("ADDRESS", rs.getString("ADDRESS"));
                info.put("PORT", rs.getString("PORT"));
                sb.append(key + ":" + ((Object)info).toString() + "  ");
                ++index;
            }
            if (this.logFlag) {
                Driver.writeLog(this.sessionID, this.pid, sb.toString());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return slaveConnInfo;
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed()) {
            throw new OSQLException("OSCAR-00211", "08003", 211);
        }
    }

    public boolean isSupportAuto() {
        return this.supportAuto;
    }

    public boolean isSupportGenerated() {
        return this.supportGenerated;
    }

    public void setSupportAuto(boolean supportAuto) {
        this.supportAuto = supportAuto;
    }

    public void setSupportGenerated(boolean supportGenerated) {
        this.supportGenerated = supportGenerated;
    }

    public Map<FieldMetadata.Key, FieldMetadata> getFieldMetadataCache() {
        return this.fieldMetadataCache;
    }

    @Override
    public boolean enableCe() {
        return this.enableCe;
    }

    @Override
    public Calendar getCalendar() {
        return this.calendar;
    }

    public String[] getClientpro() {
        return this.clientPro;
    }

    static {
        Integer tinyintoid = 972;
        Integer smallintoid = 21;
        Integer intoid = 23;
        Integer oidoid = 26;
        Integer bigintoid = 20;
        Integer bitoid = 1560;
        Integer booleanoid = 16;
        Integer numericoid = 1700;
        Integer decimaloid = 2315;
        Integer realoid = 700;
        Integer lpfloatoid = 2174;
        Integer hpfloatoid = 2175;
        Integer doubleoid = 701;
        Integer charoid = 1042;
        Integer varcharoid = 1043;
        Integer textoid = 25;
        Integer nameoid = 19;
        Integer binaryoid = 1365;
        Integer varbinaryoid = 3100;
        Integer dateoid = 1082;
        Integer timeoid = 1083;
        Integer timestampoid = 1114;
        Integer timetzoid = 1266;
        Integer timestamptzoid = 1184;
        Integer bloboid = 3000;
        Integer cloboid = 3001;
        Integer bfileoid = 3002;
        Integer _aclitemoid = 1034;
        Integer refcursoroid = 1790;
        Integer byteaoid = 17;
        Integer voidoid = 2278;
        Integer varchararray = 1009;
        Integer intervaldts = 1188;
        Integer intervalytm = 1186;
        Integer char1oid = 18;
        Integer int2oid = 21;
        Integer int2vectoroid = 22;
        Integer int4oid = 23;
        Integer regprocoid = 24;
        Integer oidvectoroid = 30;
        Integer setoid = 32;
        Integer sys_typeoid = 71;
        Integer sys_attribute = 75;
        Integer sys_procoid = 81;
        Integer sys_classoid = 83;
        Integer abstimeoid = 702;
        Integer unknownoid = 705;
        Integer int1oid = 972;
        Integer _booloid = 1000;
        Integer _byteaoid = 1001;
        Integer _charoid = 1002;
        Integer _nameoid = 1003;
        Integer _int2oid = 1005;
        Integer _int2vectoroid = 1006;
        Integer _int4oid = 1007;
        Integer _regprocoid = 1008;
        Integer _textoid = 1009;
        Integer _oidoid = 1028;
        Integer _oidvectoroid = 1013;
        Integer _bpcharoid = 1014;
        Integer _varcharoid = 1015;
        Integer _int8oid = 1016;
        Integer _float4oid = 1021;
        Integer _float8oid = 1022;
        Integer aclitemoid = 1033;
        Integer _timestampoid = 1115;
        Integer _dateoid = 1182;
        Integer _timeoid = 1183;
        Integer _timestamptzoid = 1185;
        Integer _intervalytmoid = 1187;
        Integer _intervaldtsoid = 1189;
        Integer _int1oid = 1200;
        Integer _numericoid = 1231;
        Integer _timetzoid = 1270;
        Integer _bitoid = 1561;
        Integer varbitoid = 1562;
        Integer _varbitoid = 1563;
        Integer _binaryoid = 2097;
        Integer _lpfloatoid = 2176;
        Integer _hpfloatoid = 2177;
        Integer _refcursoroid = 2201;
        Integer regprocedureoid = 2202;
        Integer regoperoid = 2203;
        Integer regoperatoroid = 2204;
        Integer regclassoid = 2205;
        Integer regtypeoid = 2206;
        Integer _regprocedureoid = 2207;
        Integer _regoperoid = 2208;
        Integer _regoperatoroid = 2209;
        Integer _regclassoid = 2210;
        Integer _regtypeoid = 2211;
        Integer recordoid = 2249;
        Integer cstringoid = 2275;
        Integer anyoid = 2276;
        Integer anyarrayoid = 2277;
        Integer triggeroid = 2279;
        Integer language_handleroid = 2280;
        Integer internaloid = 2281;
        Integer _varbinaryoid = 3101;
        Integer labeloid = 3200;
        Integer xmloid = 3300;
        Integer _xmloid = 3301;
        Integer collectionoid = 3302;
        Integer plsql_recordoid = 3303;
        Integer jsonoid = 3304;
        Integer _jsonoid = 3305;
        Integer spheroid = 85;
        Integer geometry = 86;
        Integer box3d = 87;
        Integer box2d = 88;
        Integer box2df = 89;
        Integer gidx = 90;
        Integer geometry_dump = 91;
        Integer valid_detail = 92;
        Integer geography = 94;
        Integer pointoid = 600;
        Integer lsegoid = 601;
        Integer pathoid = 602;
        Integer boxoid = 603;
        Integer polygonoid = 604;
        Integer lineoid = 628;
        Integer circleoid = 718;
        DBTypeCache.put(tinyintoid, "tinyint");
        DBTypeCache.put(smallintoid, "smallint");
        DBTypeCache.put(intoid, "int");
        DBTypeCache.put(oidoid, "OID");
        DBTypeCache.put(bigintoid, "bigint");
        DBTypeCache.put(bitoid, "bit");
        DBTypeCache.put(booleanoid, "boolean");
        DBTypeCache.put(numericoid, "numeric");
        DBTypeCache.put(decimaloid, "decimal");
        DBTypeCache.put(realoid, "real");
        DBTypeCache.put(lpfloatoid, "float");
        DBTypeCache.put(hpfloatoid, "float");
        DBTypeCache.put(doubleoid, "double precision");
        DBTypeCache.put(charoid, "char");
        DBTypeCache.put(varcharoid, "varchar");
        DBTypeCache.put(textoid, "text");
        DBTypeCache.put(nameoid, "name");
        DBTypeCache.put(binaryoid, "binary");
        DBTypeCache.put(varbinaryoid, "varbinary");
        DBTypeCache.put(dateoid, "date");
        DBTypeCache.put(timeoid, "time");
        DBTypeCache.put(timestampoid, "timestamp");
        DBTypeCache.put(timetzoid, "timetz");
        DBTypeCache.put(timestamptzoid, "timestamptz");
        DBTypeCache.put(bloboid, "blob");
        DBTypeCache.put(cloboid, "clob");
        DBTypeCache.put(bfileoid, "bfile");
        DBTypeCache.put(_aclitemoid, "_ACLITEM");
        DBTypeCache.put(refcursoroid, "REFCURSOR");
        DBTypeCache.put(byteaoid, "BYTEA");
        DBTypeCache.put(voidoid, "VOID");
        DBTypeCache.put(intervaldts, "INTERVALDTS");
        DBTypeCache.put(intervalytm, "INTERVALYTM");
        DBTypeCache.put(char1oid, "\"CHAR\"");
        DBTypeCache.put(int2oid, "int2");
        DBTypeCache.put(int2vectoroid, "int2vector");
        DBTypeCache.put(int4oid, "int4");
        DBTypeCache.put(regprocoid, "regproc");
        DBTypeCache.put(oidvectoroid, "oidvector");
        DBTypeCache.put(setoid, "set");
        DBTypeCache.put(sys_typeoid, "sys_type");
        DBTypeCache.put(sys_attribute, "sys_attribute");
        DBTypeCache.put(sys_procoid, "sys_proc");
        DBTypeCache.put(sys_classoid, "sys_class");
        DBTypeCache.put(abstimeoid, "abstime");
        DBTypeCache.put(unknownoid, "unknown");
        DBTypeCache.put(int1oid, "int1");
        DBTypeCache.put(_booloid, "_bool");
        DBTypeCache.put(_byteaoid, "_bytea");
        DBTypeCache.put(_charoid, "_char");
        DBTypeCache.put(_nameoid, "_name");
        DBTypeCache.put(_int2oid, "_int2");
        DBTypeCache.put(_int2vectoroid, "_int2vector");
        DBTypeCache.put(_int4oid, "_int4");
        DBTypeCache.put(_regprocoid, "_regproc");
        DBTypeCache.put(_textoid, "_text");
        DBTypeCache.put(_oidoid, "_oid");
        DBTypeCache.put(_oidvectoroid, "_oidvector");
        DBTypeCache.put(_bpcharoid, "_bpchar");
        DBTypeCache.put(_varcharoid, "_varchar");
        DBTypeCache.put(_int8oid, "_int8");
        DBTypeCache.put(_float4oid, "_float4");
        DBTypeCache.put(_float8oid, "_float8");
        DBTypeCache.put(aclitemoid, "aclitem");
        DBTypeCache.put(_timestampoid, "_timestamp");
        DBTypeCache.put(_dateoid, "_date");
        DBTypeCache.put(_timeoid, "_time");
        DBTypeCache.put(_timestamptzoid, "_timestamptz");
        DBTypeCache.put(_intervalytmoid, "_intervalytm");
        DBTypeCache.put(_intervaldtsoid, "_intervaldts");
        DBTypeCache.put(_int1oid, "_int1");
        DBTypeCache.put(_numericoid, "_numeric");
        DBTypeCache.put(_timetzoid, "_timetz");
        DBTypeCache.put(_bitoid, "_bit");
        DBTypeCache.put(varbitoid, "varbit");
        DBTypeCache.put(_varbitoid, "_varbit");
        DBTypeCache.put(_binaryoid, "_binary");
        DBTypeCache.put(_lpfloatoid, "_lpfloat");
        DBTypeCache.put(_hpfloatoid, "_hpfloat");
        DBTypeCache.put(_refcursoroid, "_refcursor");
        DBTypeCache.put(regprocedureoid, "regprocedure");
        DBTypeCache.put(regoperoid, "regoper");
        DBTypeCache.put(regoperatoroid, "regoperator");
        DBTypeCache.put(regclassoid, "regclass");
        DBTypeCache.put(regtypeoid, "regtype");
        DBTypeCache.put(_regprocedureoid, "_regprocedure");
        DBTypeCache.put(_regoperoid, "_regoper");
        DBTypeCache.put(_regoperatoroid, "_regoperator");
        DBTypeCache.put(_regclassoid, "_regclass");
        DBTypeCache.put(_regtypeoid, "_regtype");
        DBTypeCache.put(recordoid, "record");
        DBTypeCache.put(cstringoid, "cstring");
        DBTypeCache.put(anyoid, "any");
        DBTypeCache.put(anyarrayoid, "anyarray");
        DBTypeCache.put(triggeroid, "trigger");
        DBTypeCache.put(language_handleroid, "language_handler");
        DBTypeCache.put(internaloid, "internal");
        DBTypeCache.put(_varbinaryoid, "_varbinary");
        DBTypeCache.put(labeloid, "label");
        DBTypeCache.put(xmloid, "xml");
        DBTypeCache.put(_xmloid, "_xml");
        DBTypeCache.put(collectionoid, "collection");
        DBTypeCache.put(plsql_recordoid, "plsql_record");
        DBTypeCache.put(jsonoid, "json");
        DBTypeCache.put(_jsonoid, "_json");
        DBTypeCache.put(pointoid, "point");
        DBTypeCache.put(boxoid, "box");
        DBTypeCache.put(pathoid, "path");
        DBTypeCache.put(polygonoid, "polygon");
        DBTypeCache.put(lsegoid, "lseg");
        DBTypeCache.put(lineoid, "line");
        DBTypeCache.put(circleoid, "circle");
        DBTypeCache.put(spheroid, "spheroid");
        DBTypeCache.put(box2d, "box2d");
        DBTypeCache.put(box2df, "box2df");
        DBTypeCache.put(box3d, "box3d");
        DBTypeCache.put(gidx, "gidx");
        DBTypeCache.put(geometry_dump, "geometry_dump");
        DBTypeCache.put(valid_detail, "valid_detail");
        DBTypeCache.put(geometry, "geometry");
        DBTypeCache.put(geography, "geography");
        DBTypeClassCache.put("point", OscarPoint.class);
        DBTypeClassCache.put("box", OscarBox.class);
        DBTypeClassCache.put("path", OscarPath.class);
        DBTypeClassCache.put("polygon", OscarPolygon.class);
        DBTypeClassCache.put("lseg", OscarLseg.class);
        DBTypeClassCache.put("line", OscarLine.class);
        DBTypeClassCache.put("circle", OscarCircle.class);
        DBTypeClassCache.put("geometry", OscarGeometry.class);
        DBTypeClassCache.put("box3d", OscarBox3d.class);
        DBTypeClassCache.put("gidx", OscarBox3d.class);
        DBTypeClassCache.put("box2d", OscarBox2d.class);
        DBTypeClassCache.put("box2df", OscarBox2d.class);
        DBTypeClassCache.put("geography", OscarGeography.class);
        oscarTypeCache.put(tinyintoid, 23);
        oscarTypeCache.put(smallintoid, 23);
        oscarTypeCache.put(intoid, 23);
        oscarTypeCache.put(bigintoid, 23);
        oscarTypeCache.put(booleanoid, 33);
        oscarTypeCache.put(numericoid, 34);
        oscarTypeCache.put(decimaloid, 34);
        oscarTypeCache.put(realoid, 34);
        oscarTypeCache.put(hpfloatoid, 34);
        oscarTypeCache.put(lpfloatoid, 34);
        oscarTypeCache.put(doubleoid, 34);
        oscarTypeCache.put(charoid, 24);
        oscarTypeCache.put(varcharoid, 24);
        oscarTypeCache.put(textoid, 24);
        oscarTypeCache.put(nameoid, 24);
        oscarTypeCache.put(oidoid, 24);
        oscarTypeCache.put(bitoid, 24);
        oscarTypeCache.put(binaryoid, 35);
        oscarTypeCache.put(varbinaryoid, 35);
        oscarTypeCache.put(dateoid, 25);
        oscarTypeCache.put(timeoid, 26);
        oscarTypeCache.put(timestampoid, 28);
        oscarTypeCache.put(timetzoid, 27);
        oscarTypeCache.put(timestamptzoid, 29);
        oscarTypeCache.put(bloboid, 50);
        oscarTypeCache.put(cloboid, 51);
        oscarTypeCache.put(bfileoid, 52);
        oscarTypeCache.put(intervaldts, 31);
        oscarTypeCache.put(intervalytm, 30);
        oscarTypeCache.put(_aclitemoid, 2003);
        oscarTypeCache.put(refcursoroid, 24);
        oscarTypeCache.put(byteaoid, 24);
        oscarTypeCache.put(voidoid, 24);
        oscarTypeCache.put(varchararray, 2003);
        oscarTypeCache.put(jsonoid, 24);
        oscarTypeCache.put(pointoid, 24);
        oscarTypeCache.put(boxoid, 24);
        oscarTypeCache.put(pathoid, 24);
        oscarTypeCache.put(polygonoid, 24);
        oscarTypeCache.put(lsegoid, 24);
        oscarTypeCache.put(lineoid, 24);
        oscarTypeCache.put(circleoid, 24);
        oscarTypeCache.put(spheroid, 24);
        oscarTypeCache.put(geometry, 24);
        oscarTypeCache.put(box3d, 24);
        oscarTypeCache.put(box2d, 24);
        oscarTypeCache.put(box2df, 24);
        oscarTypeCache.put(gidx, 24);
        oscarTypeCache.put(geometry_dump, 24);
        oscarTypeCache.put(valid_detail, 24);
        oscarTypeCache.put(geography, 24);
        sqlTypeCache.put(tinyintoid, -6);
        sqlTypeCache.put(smallintoid, 5);
        sqlTypeCache.put(intoid, 4);
        sqlTypeCache.put(oidoid, -5);
        sqlTypeCache.put(bigintoid, -5);
        sqlTypeCache.put(bitoid, -7);
        sqlTypeCache.put(booleanoid, 16);
        sqlTypeCache.put(numericoid, 2);
        sqlTypeCache.put(decimaloid, 3);
        sqlTypeCache.put(realoid, 7);
        sqlTypeCache.put(hpfloatoid, 6);
        sqlTypeCache.put(lpfloatoid, 6);
        sqlTypeCache.put(doubleoid, 8);
        sqlTypeCache.put(charoid, 1);
        sqlTypeCache.put(varcharoid, 12);
        sqlTypeCache.put(char1oid, 1);
        sqlTypeCache.put(textoid, 12);
        sqlTypeCache.put(nameoid, 12);
        sqlTypeCache.put(binaryoid, -2);
        sqlTypeCache.put(varbinaryoid, -3);
        sqlTypeCache.put(dateoid, 91);
        sqlTypeCache.put(timeoid, 92);
        sqlTypeCache.put(timestampoid, 93);
        sqlTypeCache.put(timetzoid, 92);
        sqlTypeCache.put(timestamptzoid, 93);
        sqlTypeCache.put(bloboid, 2004);
        sqlTypeCache.put(cloboid, 2005);
        sqlTypeCache.put(bfileoid, -11);
        sqlTypeCache.put(_aclitemoid, 2003);
        sqlTypeCache.put(_lpfloatoid, 2003);
        sqlTypeCache.put(refcursoroid, 12);
        sqlTypeCache.put(byteaoid, 12);
        sqlTypeCache.put(voidoid, 0);
        sqlTypeCache.put(jsonoid, -1);
        sqlTypeCache.put(spheroid, 1111);
        sqlTypeCache.put(geometry, 1111);
        sqlTypeCache.put(box2d, 1111);
        sqlTypeCache.put(box2df, 1111);
        sqlTypeCache.put(box3d, 1111);
        sqlTypeCache.put(gidx, 1111);
        sqlTypeCache.put(geometry_dump, 1111);
        sqlTypeCache.put(valid_detail, 1111);
        sqlTypeCache.put(geography, 1111);
        sqlTypeCache.put(pointoid, 1111);
        sqlTypeCache.put(boxoid, 1111);
        sqlTypeCache.put(pathoid, 1111);
        sqlTypeCache.put(polygonoid, 1111);
        sqlTypeCache.put(lsegoid, 1111);
        sqlTypeCache.put(lineoid, 1111);
        sqlTypeCache.put(circleoid, 1111);
        jdbcTypes.put("TINYINT", -6);
        jdbcTypes.put("SMALLINT", 5);
        jdbcTypes.put("INTEGER", 4);
        jdbcTypes.put("OID", 4);
        jdbcTypes.put("BIGINT", -5);
        jdbcTypes.put("BIT", -7);
        jdbcTypes.put("NUMERIC", 2);
        jdbcTypes.put("DECIMAL", 3);
        jdbcTypes.put("REAL", 7);
        jdbcTypes.put("MONEY", 7);
        jdbcTypes.put("FLOAT", 6);
        jdbcTypes.put("DOUBLE", 8);
        jdbcTypes.put("CHAR", 1);
        jdbcTypes.put("VARCHAR", 12);
        jdbcTypes.put("TEXT", -1);
        jdbcTypes.put("NAME", 12);
        jdbcTypes.put("BINARY", -2);
        jdbcTypes.put("VARBINARY", -3);
        jdbcTypes.put("BOOLEAN", 16);
        jdbcTypes.put("DATE", 91);
        jdbcTypes.put("TIME", 92);
        jdbcTypes.put("TIMESTAMP", 93);
        jdbcTypes.put("TIMESTAMPTZ", 93);
        jdbcTypes.put("BLOB", 2004);
        jdbcTypes.put("CLOB", 2005);
        jdbcTypes.put("BYTEA", -3);
        jdbcTypes.put("LABEL", 1111);
        jdbcTypes.put("INT1", -6);
        jdbcTypes.put("_INT1", 2003);
        jdbcTypes.put("INT2", 5);
        jdbcTypes.put("_INT2", 2003);
        jdbcTypes.put("INT4", 4);
        jdbcTypes.put("_INT4", 2003);
        jdbcTypes.put("INT8", -5);
        jdbcTypes.put("_INT8", 2003);
        jdbcTypes.put("_VARCHAR", 2003);
        jdbcTypes.put("_varchar", 2003);
        jdbcTypes.put("_BOOL", 2003);
        jdbcTypes.put("_bool", 2003);
        jdbcTypes.put("_HPFLOAT", 2003);
        jdbcTypes.put("_hpfloat", 2003);
        jdbcTypes.put("_FLOAT4", 2003);
        jdbcTypes.put("_float4", 2003);
        jdbcTypes.put("_FLOAT8", 2003);
        jdbcTypes.put("_float8", 2003);
        jdbcTypes.put("_TEXT", 2003);
        jdbcTypes.put("_text", 2003);
        jdbcTypes.put("_BPCHAR", 2003);
        jdbcTypes.put("_bpchar", 2003);
        jdbcTypes.put("_BIT", 2003);
        jdbcTypes.put("_bit", 2003);
        jdbcTypes.put("_NUMERIC", 2003);
        jdbcTypes.put("_numeric", 2003);
        jdbcTypes.put("_BINARY", 2003);
        jdbcTypes.put("_binary", 2003);
        jdbcTypes.put("_VARBINARY", 2003);
        jdbcTypes.put("_varbinary", 2003);
        jdbcTypes.put("_DATE", 2003);
        jdbcTypes.put("_date", 2003);
        jdbcTypes.put("_INTERVALYTM", 2003);
        jdbcTypes.put("_intervalytm", 2003);
        jdbcTypes.put("_INTERVALDTS", 2003);
        jdbcTypes.put("_intervaldts", 2003);
        jdbcTypes.put("_XML", 2003);
        jdbcTypes.put("_xml", 2003);
        jdbcTypes.put("_bytea", 2003);
        jdbcTypes.put("_BYTEA", 2003);
        jdbcTypes.put("_name", 2003);
        jdbcTypes.put("_NAME", 2003);
        jdbcTypes.put("_oid", 2003);
        jdbcTypes.put("_OID", 2003);
        jdbcTypes.put("int1", -6);
        jdbcTypes.put("_int1", 2003);
        jdbcTypes.put("int2", 5);
        jdbcTypes.put("_int2", 2003);
        jdbcTypes.put("int4", 4);
        jdbcTypes.put("_int4", 2003);
        jdbcTypes.put("int8", -5);
        jdbcTypes.put("_int8", 2003);
        jdbcTypes.put("tinyint", -6);
        jdbcTypes.put("smallint", 5);
        jdbcTypes.put("integer", 4);
        jdbcTypes.put("oid", 4);
        jdbcTypes.put("bigint", -5);
        jdbcTypes.put("bit", -7);
        jdbcTypes.put("numeric", 2);
        jdbcTypes.put("decimal", 3);
        jdbcTypes.put("real", 7);
        jdbcTypes.put("money", 7);
        jdbcTypes.put("float", 6);
        jdbcTypes.put("double", 8);
        jdbcTypes.put("char", 1);
        jdbcTypes.put("varchar", 12);
        jdbcTypes.put("text", -1);
        jdbcTypes.put("name", 12);
        jdbcTypes.put("binary", -2);
        jdbcTypes.put("varbinary", -3);
        jdbcTypes.put("boolean", 16);
        jdbcTypes.put("date", 91);
        jdbcTypes.put("time", 92);
        jdbcTypes.put("timestamp", 93);
        jdbcTypes.put("timestamptz", 93);
        jdbcTypes.put("blob", 2004);
        jdbcTypes.put("clob", 2005);
        jdbcTypes.put("bytea", -3);
        jdbcTypes.put("label", 1111);
        jdbcTypes.put("json", -1);
        jdbcTypes.put("_json", 2003);
        jdbcTypes.put("JSON", -1);
        jdbcTypes.put("_JSON", 2003);
        jdbcTypes.put("GEOMETRY_DUMP", 1111);
        jdbcTypes.put("VALID_DETAIL", 1111);
    }
}

