/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.gis;

import com.oscar.gis.OscarObject;
import com.oscar.gis.OscarPoint;
import com.oscar.util.OscarTokenizer;
import java.io.Serializable;
import java.sql.SQLException;

public class OscarCircle
extends OscarObject
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 6507295651335704535L;
    private OscarPoint center;
    private double radius;

    public OscarCircle(double x, double y, double r) {
        this(new OscarPoint(x, y), r);
    }

    public OscarCircle(OscarPoint c, double r) {
        this();
        this.center = c;
        this.radius = r;
    }

    public OscarCircle(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public OscarCircle() {
        this.setType("circle");
    }

    @Override
    public void setValue(String s) throws SQLException {
        OscarTokenizer t = new OscarTokenizer(OscarTokenizer.removeAngle(s), ',');
        if (t.getSize() != 2) {
            throw new SQLException("Conversion to type" + this.type + "failed: " + s);
        }
        try {
            this.center = new OscarPoint(t.getToken(0));
            this.radius = Double.parseDouble(t.getToken(1));
        }
        catch (NumberFormatException e) {
            throw new SQLException("Conversion to type" + this.type + "failed: " + s);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof OscarCircle) {
            OscarCircle p = (OscarCircle)obj;
            return p.center.equals(this.center) && p.radius == this.radius;
        }
        return false;
    }

    @Override
    public int hashCode() {
        long v = Double.doubleToLongBits(this.radius);
        return (int)((long)this.center.hashCode() ^ v ^ v >>> 32);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        OscarCircle newOscarCircle = (OscarCircle)super.clone();
        if (newOscarCircle.center != null) {
            newOscarCircle.center = (OscarPoint)newOscarCircle.center.clone();
        }
        return newOscarCircle;
    }

    @Override
    public String getValue() {
        return "<" + this.center + "," + this.radius + ">";
    }
}

