/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.gis;

import com.oscar.gis.OscarObject;
import com.oscar.gis.util.Geometry;
import com.oscar.gis.util.GeometryBuilder;
import com.oscar.gis.util.GeometryTokenizer;
import com.oscar.gis.util.Point;
import java.sql.SQLException;
import java.util.List;

public abstract class OscarBoxbase
extends OscarObject {
    private static final long serialVersionUID = 256L;
    protected Point llb;
    protected Point urt;

    public abstract String getPrefix();

    public abstract String getOscartype();

    public OscarBoxbase() {
        this.setType(this.getOscartype());
    }

    public OscarBoxbase(Point llb, Point urt) {
        this();
        this.llb = llb;
        this.urt = urt;
    }

    public OscarBoxbase(String value) throws SQLException {
        this();
        this.setValue(value);
    }

    @Override
    public void setValue(String value) throws SQLException {
        String myPrefix;
        int srid = 0;
        if ((value = value.trim()).startsWith("SRID=")) {
            String[] temp = GeometryBuilder.splitSRID(value);
            value = temp[1].trim();
            srid = Geometry.parseSRID(Integer.parseInt(temp[0].substring(5)));
        }
        if (value.startsWith(myPrefix = this.getPrefix())) {
            value = value.substring(myPrefix.length()).trim();
        }
        String valueNoParans = GeometryTokenizer.removeLeadingAndTrailingStrings(value.trim(), "(", ")");
        List<String> tokens = GeometryTokenizer.tokenize(valueNoParans, ',');
        this.llb = new Point(tokens.get(0));
        this.urt = new Point(tokens.get(1));
        if (srid != 0) {
            this.llb.setSrid(srid);
            this.urt.setSrid(srid);
        }
    }

    @Override
    public String getValue() {
        StringBuffer sb = new StringBuffer();
        this.outerWKT(sb);
        return sb.toString();
    }

    private void outerWKT(StringBuffer sb) {
        sb.append(this.getPrefix());
        sb.append('(');
        this.llb.innerWKT(sb);
        sb.append(',');
        this.urt.innerWKT(sb);
        sb.append(')');
    }

    @Override
    public String toString() {
        return this.getValue();
    }

    public Point getLLB() {
        return this.llb;
    }

    public Point getURT() {
        return this.urt;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof OscarBoxbase) {
            OscarBoxbase otherbox = (OscarBoxbase)other;
            return OscarBoxbase.compareLazyDim(this.llb, otherbox.llb) && OscarBoxbase.compareLazyDim(this.urt, otherbox.urt);
        }
        return super.equals(other);
    }

    protected static boolean compareLazyDim(Point first, Point second) {
        return !(first.getX() != second.getX() || first.getY() != second.getY() || (first.dimension != 2 && first.getZ() != 0.0 || second.dimension != 2 && second.getZ() != 0.0) && first.getZ() != second.getZ());
    }

    @Override
    public Object clone() {
        OscarBoxbase obj = this.newInstance();
        obj.llb = this.llb;
        obj.urt = this.urt;
        obj.setType(this.type);
        return obj;
    }

    protected abstract OscarBoxbase newInstance();
}

