/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.signing.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.oracle.bmc.InternalSdk;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Constants {
    static final String AUTHORIZATION_HEADER = "authorization";
    static final String REQUEST_TARGET = "(request-target)";
    static final String DATE = "date";
    static final String CONTENT_LENGTH = "content-length";
    static final String CONTENT_TYPE = "content-type";
    static final String X_CONTENT_SHA256 = "x-content-sha256";
    @InternalSdk(backwardCompatibilityRequired=true)
    public static final String HOST = "host";
    public static final String CROSS_TENANCY_REQUEST_HEADER_NAME = "x-cross-tenancy-request";
    static final String X_SUBSCRIPTION = "x-subscription";
    public static final String OPC_OBO_TOKEN = "opc-obo-token";
    static final String JSON_CONTENT_TYPE = "application/json";
    @InternalSdk(backwardCompatibilityRequired=true)
    public static final List<String> GENERIC_HEADERS_LIST = Collections.unmodifiableList(Arrays.asList("date", "(request-target)", "host"));
    @Deprecated
    @InternalSdk(backwardCompatibilityRequired=true)
    public static final ImmutableList<String> GENERIC_HEADERS = ImmutableList.copyOf(GENERIC_HEADERS_LIST);
    public static final List<String> BODY_HEADERS_LIST = Collections.unmodifiableList(Arrays.asList("content-length", "content-type", "x-content-sha256"));
    @Deprecated
    public static final ImmutableList<String> BODY_HEADERS = ImmutableList.copyOf(BODY_HEADERS_LIST);
    public static final List<String> ALL_HEADERS_LIST;
    @Deprecated
    public static final ImmutableList<String> ALL_HEADERS;
    public static final Map<String, List<String>> REQUIRED_SIGNING_HEADERS_MAP;
    @Deprecated
    public static final ImmutableMap<String, List<String>> REQUIRED_SIGNING_HEADERS;
    @Deprecated
    public static final Map<String, List<String>> REQUIRED_OBJECTSTORAGE_SIGNING_HEADERS_MAP;
    @Deprecated
    public static final ImmutableMap<String, List<String>> REQUIRED_OBJECTSTORAGE_SIGNING_HEADERS;
    public static final Map<String, List<String>> REQUIRED_EXCLUDE_BODY_SIGNING_HEADERS_MAP;
    @Deprecated
    public static final ImmutableMap<String, List<String>> REQUIRED_EXCLUDE_BODY_SIGNING_HEADERS;
    public static final List<String> OPTIONAL_HEADERS_NAMES;
    public static final Map<String, List<String>> OPTIONAL_SIGNING_HEADERS_MAP;
    @Deprecated
    public static final ImmutableMap<String, List<String>> OPTIONAL_SIGNING_HEADERS;
    static final String DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";

    @Deprecated
    @InternalSdk(backwardCompatibilityRequired=true)
    public static ImmutableMap<String, List<String>> createHeadersToSignMap(List<String> getHeaders, List<String> headHeaders, List<String> deleteHeaders, List<String> putHeaders, List<String> postHeaders, List<String> patchHeaders) {
        return ImmutableMap.copyOf(Constants.createHeadersToSignForVerbMap(getHeaders, headHeaders, deleteHeaders, putHeaders, postHeaders, patchHeaders));
    }

    @InternalSdk(backwardCompatibilityRequired=true)
    public static Map<String, List<String>> createHeadersToSignForVerbMap(List<String> getHeaders, List<String> headHeaders, List<String> deleteHeaders, List<String> putHeaders, List<String> postHeaders, List<String> patchHeaders) {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        headers.put("get", getHeaders);
        headers.put("head", headHeaders);
        headers.put("delete", deleteHeaders);
        headers.put("put", putHeaders);
        headers.put("post", postHeaders);
        headers.put("patch", patchHeaders);
        return Collections.unmodifiableMap(headers);
    }

    static {
        ArrayList<String> tempAllHeaders = new ArrayList<String>(GENERIC_HEADERS_LIST);
        tempAllHeaders.addAll(BODY_HEADERS_LIST);
        ALL_HEADERS_LIST = Collections.unmodifiableList(tempAllHeaders);
        ALL_HEADERS = ImmutableList.copyOf(ALL_HEADERS_LIST);
        REQUIRED_SIGNING_HEADERS_MAP = Constants.createHeadersToSignForVerbMap(GENERIC_HEADERS_LIST, GENERIC_HEADERS_LIST, GENERIC_HEADERS_LIST, ALL_HEADERS_LIST, ALL_HEADERS_LIST, ALL_HEADERS_LIST);
        REQUIRED_SIGNING_HEADERS = ImmutableMap.copyOf(REQUIRED_SIGNING_HEADERS_MAP);
        REQUIRED_OBJECTSTORAGE_SIGNING_HEADERS_MAP = Constants.createHeadersToSignForVerbMap(GENERIC_HEADERS_LIST, GENERIC_HEADERS_LIST, GENERIC_HEADERS_LIST, GENERIC_HEADERS_LIST, ALL_HEADERS, ALL_HEADERS);
        REQUIRED_OBJECTSTORAGE_SIGNING_HEADERS = ImmutableMap.copyOf(REQUIRED_OBJECTSTORAGE_SIGNING_HEADERS_MAP);
        REQUIRED_EXCLUDE_BODY_SIGNING_HEADERS_MAP = Constants.createHeadersToSignForVerbMap(GENERIC_HEADERS_LIST, GENERIC_HEADERS_LIST, GENERIC_HEADERS_LIST, GENERIC_HEADERS_LIST, GENERIC_HEADERS_LIST, GENERIC_HEADERS_LIST);
        REQUIRED_EXCLUDE_BODY_SIGNING_HEADERS = ImmutableMap.copyOf(REQUIRED_EXCLUDE_BODY_SIGNING_HEADERS_MAP);
        OPTIONAL_HEADERS_NAMES = Collections.unmodifiableList(Arrays.asList(OPC_OBO_TOKEN, CROSS_TENANCY_REQUEST_HEADER_NAME, X_SUBSCRIPTION));
        OPTIONAL_SIGNING_HEADERS_MAP = Constants.createHeadersToSignForVerbMap(OPTIONAL_HEADERS_NAMES, OPTIONAL_HEADERS_NAMES, OPTIONAL_HEADERS_NAMES, OPTIONAL_HEADERS_NAMES, OPTIONAL_HEADERS_NAMES, OPTIONAL_HEADERS_NAMES);
        OPTIONAL_SIGNING_HEADERS = ImmutableMap.copyOf(OPTIONAL_SIGNING_HEADERS_MAP);
    }
}

