/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.signing;

import com.google.common.collect.ImmutableMap;
import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.signing.internal.Constants;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;

@InternalSdk
public enum SigningStrategy {
    STANDARD((Map<String, List<String>>)Constants.REQUIRED_SIGNING_HEADERS, (Map<String, List<String>>)Constants.OPTIONAL_SIGNING_HEADERS, false),
    OBJECT_STORAGE((Map<String, List<String>>)Constants.REQUIRED_OBJECTSTORAGE_SIGNING_HEADERS, (Map<String, List<String>>)Constants.OPTIONAL_SIGNING_HEADERS, true),
    EXCLUDE_BODY((Map<String, List<String>>)Constants.REQUIRED_EXCLUDE_BODY_SIGNING_HEADERS, (Map<String, List<String>>)Constants.OPTIONAL_SIGNING_HEADERS, true);

    private final Map<String, List<String>> headersToSign;
    private final Map<String, List<String>> optionalHeadersToSign;
    private final boolean skipContentHeadersForStreamingPutRequests;

    @ConstructorProperties(value={"headersToSign", "optionalHeadersToSign", "skipContentHeadersForStreamingPutRequests"})
    private SigningStrategy(Map<String, List<String>> headersToSign, Map<String, List<String>> optionalHeadersToSign, boolean skipContentHeadersForStreamingPutRequests) {
        this.headersToSign = headersToSign;
        this.optionalHeadersToSign = optionalHeadersToSign;
        this.skipContentHeadersForStreamingPutRequests = skipContentHeadersForStreamingPutRequests;
    }

    public ImmutableMap<String, List<String>> getHeadersToSign() {
        return ImmutableMap.copyOf(this.headersToSign);
    }

    public ImmutableMap<String, List<String>> getOptionalHeadersToSign() {
        return ImmutableMap.copyOf(this.optionalHeadersToSign);
    }

    public boolean isSkipContentHeadersForStreamingPutRequests() {
        return this.skipContentHeadersForStreamingPutRequests;
    }
}

