/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.internal;

import com.oracle.bmc.ServiceDetails;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.WithHeaders;
import java.beans.ConstructorProperties;
import java.util.function.Function;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

public class ResponseConversionFunctionFactoryV2 {
    public Function<Response, WithHeaders<Void>> create() {
        return new ParseResponseOnlyHeadersFunction(ServiceDetails.UNKNOWN_SERVICE_DETAILS);
    }

    public Function<Response, WithHeaders<Void>> create(ServiceDetails serviceDetails) {
        return new ParseResponseOnlyHeadersFunction(serviceDetails);
    }

    public <T> Function<Response, WithHeaders<T>> create(Class<T> clazz) {
        return new ParseResponseWithHeadersFunction<T>(clazz, ServiceDetails.UNKNOWN_SERVICE_DETAILS);
    }

    public <T> Function<Response, WithHeaders<T>> create(Class<T> clazz, ServiceDetails serviceDetails) {
        return new ParseResponseWithHeadersFunction<T>(clazz, serviceDetails);
    }

    public <T> Function<Response, WithHeaders<T>> create(GenericType<T> type) {
        return new ParseGenericResponseWithHeadersFunction<T>(type, ServiceDetails.UNKNOWN_SERVICE_DETAILS);
    }

    public <T> Function<Response, WithHeaders<T>> create(GenericType<T> type, ServiceDetails serviceDetails) {
        return new ParseGenericResponseWithHeadersFunction<T>(type, serviceDetails);
    }

    private static abstract class ValidatingParseResponseFunction<T>
    implements Function<Response, T> {
        protected ServiceDetails serviceDetails;

        @ConstructorProperties(value={"serviceDetails"})
        ValidatingParseResponseFunction(ServiceDetails serviceDetails) {
            this.serviceDetails = serviceDetails;
        }

        @Override
        public final T apply(Response response) {
            ResponseHelper.throwIfNotSuccessful(response, this.serviceDetails);
            return this.doApply(response);
        }

        protected abstract T doApply(Response var1);
    }

    private static final class ParseResponseOnlyHeadersFunction
    extends ValidatingParseResponseFunction<WithHeaders<Void>> {
        ParseResponseOnlyHeadersFunction(ServiceDetails serviceDetails) {
            super(serviceDetails);
        }

        @Override
        protected WithHeaders<Void> doApply(Response response) {
            ResponseHelper.readWithoutEntity(response);
            return new WithHeaders<Object>(null, (MultivaluedMap<String, String>)response.getStringHeaders(), response.getStatus());
        }
    }

    private static final class ParseGenericResponseWithHeadersFunction<T>
    extends ValidatingParseResponseFunction<WithHeaders<T>> {
        private final GenericType<T> genericType;

        @Override
        protected WithHeaders<T> doApply(Response response) {
            T entity = ResponseHelper.readEntity(response, this.genericType);
            return new WithHeaders<T>(entity, (MultivaluedMap<String, String>)response.getStringHeaders(), response.getStatus());
        }

        @ConstructorProperties(value={"genericType", "serviceDetails"})
        public ParseGenericResponseWithHeadersFunction(GenericType<T> genericType, ServiceDetails serviceDetails) {
            super(serviceDetails);
            this.genericType = genericType;
        }
    }

    private static final class ParseResponseWithHeadersFunction<T>
    extends ValidatingParseResponseFunction<WithHeaders<T>> {
        private final Class<T> responseClass;

        @Override
        protected WithHeaders<T> doApply(Response response) {
            T entity = ResponseHelper.readEntity(response, this.responseClass);
            return new WithHeaders<T>(entity, (MultivaluedMap<String, String>)response.getStringHeaders(), response.getStatus());
        }

        @ConstructorProperties(value={"responseClass", "serviceDetails"})
        public ParseResponseWithHeadersFunction(Class<T> responseClass, ServiceDetails serviceDetails) {
            super(serviceDetails);
            this.responseClass = responseClass;
        }
    }
}

