/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http;

import com.oracle.bmc.http.ApacheConnectorProperties;
import com.oracle.bmc.http.ClientConfigDecorator;
import com.oracle.bmc.util.JavaRuntimeUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLContext;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLInitializationException;
import org.glassfish.jersey.SslConfigurator;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheConnectorPropertiesClientConfigDecorator
implements ClientConfigDecorator {
    private static final Logger LOG = LoggerFactory.getLogger(ApacheConnectorPropertiesClientConfigDecorator.class);
    private final ApacheConnectorProperties config;

    public ApacheConnectorPropertiesClientConfigDecorator(@Nonnull ApacheConnectorProperties config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.config = config;
    }

    @Override
    public void customizeClientConfig(ClientConfig clientConfig) {
        Validate.notNull(clientConfig, "ClientConfig must not be null", new Object[0]);
        ConnectorProvider provider = clientConfig.getConnectorProvider();
        Validate.isInstanceOf(ApacheConnectorProvider.class, provider, String.format("ConnectorProvider of type [%s] is not supported. Expected ApacheConnectorProvider", provider.getClass().getCanonicalName()), new Object[0]);
        if (this.config.getConnectionManager() != null) {
            clientConfig.property("jersey.config.apache.client.connectionManager", (Object)this.config.getConnectionManager());
        } else if (this.config.isConnectionPooling()) {
            Registry<ConnectionSocketFactory> registry = this.getRegistry();
            Map.Entry<Integer, TimeUnit> ttl = this.config.getConnectionPoolConfig().getTtl();
            PoolingHttpClientConnectionManager poolConnectionManager = registry != null ? (ttl != null ? new PoolingHttpClientConnectionManager(registry, null, null, null, (long)ttl.getKey().intValue(), ttl.getValue()) : new PoolingHttpClientConnectionManager(registry)) : (ttl != null ? new PoolingHttpClientConnectionManager((long)ttl.getKey().intValue(), ttl.getValue()) : new PoolingHttpClientConnectionManager());
            poolConnectionManager.setMaxTotal(this.config.getConnectionPoolConfig().getTotalOpenConnections());
            poolConnectionManager.setDefaultMaxPerRoute(this.config.getConnectionPoolConfig().getDefaultMaxConnectionsPerRoute());
            clientConfig.property("jersey.config.apache.client.connectionManager", (Object)poolConnectionManager);
        } else if (!this.config.isConnectionPooling()) {
            BasicHttpClientConnectionManager basicHttpClientConnectionManager = new BasicHttpClientConnectionManager();
            clientConfig.property("jersey.config.apache.client.connectionManager", (Object)basicHttpClientConnectionManager);
        }
        if (this.config.getKeepAliveStrategy() != null) {
            clientConfig.property("jersey.config.apache.client.keepAliveStrategy", (Object)this.config.getKeepAliveStrategy());
        }
        if (this.config.getConnectionReuseStrategy() != null) {
            clientConfig.property("jersey.config.apache.client.reuseStrategy", (Object)this.config.getConnectionReuseStrategy());
        }
        if (this.config.getConnectionClosingStrategy() != null) {
            clientConfig.property("jersey.config.apache.client.connectionClosingStrategy", (Object)this.config.getConnectionClosingStrategy());
        }
        if (this.config.getRequestRetryHandler() != null) {
            clientConfig.property("jersey.config.apache.client.retryHandler", (Object)this.config.getRequestRetryHandler());
        }
        RequestConfig requestConfig = RequestConfig.custom().setContentCompressionEnabled(false).setExpectContinueEnabled(false).build();
        clientConfig.property("jersey.config.apache.client.requestConfig", (Object)requestConfig);
        clientConfig.property("jersey.config.apache.client.connectionManagerShared", (Object)this.config.isConnectionManagerShared());
    }

    private Registry<ConnectionSocketFactory> getRegistry() {
        Registry registry;
        RegistryBuilder registryBuilder = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
        SSLConnectionSocketFactory sslConnectionSocketFactory = null;
        if (this.config.getSslContext() != null) {
            sslConnectionSocketFactory = new SSLConnectionSocketFactory(this.config.getSslContext(), this.config.getHostnameVerifier());
        }
        try {
            registry = sslConnectionSocketFactory != null ? registryBuilder.register("https", sslConnectionSocketFactory).build() : registryBuilder.register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).build();
        }
        catch (SSLInitializationException e) {
            registry = registryBuilder.register("https", (Object)PlainConnectionSocketFactory.getSocketFactory()).build();
        }
        return registry;
    }

    private SSLContext getSslContext() {
        JavaRuntimeUtils.JreVersion version = JavaRuntimeUtils.getRuntimeVersion();
        if (version == JavaRuntimeUtils.JreVersion.Java_7) {
            LOG.info("Running on 1.7 VM, manually setting security protocol to TLSv1.2");
            SSLContext sslContext = SslConfigurator.newInstance((boolean)true).securityProtocol("TLSv1.2").createSSLContext();
            return sslContext;
        }
        if (version == JavaRuntimeUtils.JreVersion.Unsupported) {
            LOG.error("Using an unsupported runtime only 1.7+ is supported");
        } else if (version == JavaRuntimeUtils.JreVersion.Unknown) {
            LOG.warn("Using an unknown runtime, calls may not work");
        }
        return null;
    }
}

