/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http;

import com.oracle.bmc.http.ApacheConnectionPoolConfig;
import com.oracle.bmc.http.ClientConfigDecorator;
import com.oracle.bmc.util.internal.Validate;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheConnectionPoolingClientConfigDecorator
implements ClientConfigDecorator {
    private static final Logger LOG = LoggerFactory.getLogger(ApacheConnectionPoolingClientConfigDecorator.class);
    private final ApacheConnectionPoolConfig config;
    private PoolingHttpClientConnectionManager poolConnectionManager;

    public ApacheConnectionPoolingClientConfigDecorator(@Nonnull ApacheConnectionPoolConfig config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.config = config;
    }

    public PoolingHttpClientConnectionManager getPoolingHttpClientConnectionManager() {
        return this.poolConnectionManager;
    }

    @Override
    public void customizeClientConfig(ClientConfig clientConfig) {
        Validate.notNull(clientConfig, "ClientConfig must not be null", new Object[0]);
        ConnectorProvider provider = clientConfig.getConnectorProvider();
        Validate.isInstanceOf(ApacheConnectorProvider.class, provider, String.format("ConnectorProvider of type [%s] is not supported. Expected ApacheConnectorProvider", provider.getClass().getCanonicalName()), new Object[0]);
        LOG.info("ApacheConnectionPoolConfig: {}", (Object)this.config);
        Map.Entry<Integer, TimeUnit> ttl = this.config.getTtl();
        this.poolConnectionManager = ttl != null ? new PoolingHttpClientConnectionManager((long)ttl.getKey().intValue(), ttl.getValue()) : new PoolingHttpClientConnectionManager();
        this.poolConnectionManager.setMaxTotal(this.config.getTotalOpenConnections());
        this.poolConnectionManager.setDefaultMaxPerRoute(this.config.getDefaultMaxConnectionsPerRoute());
        clientConfig.property("jersey.config.apache.client.connectionManager", (Object)this.poolConnectionManager);
    }
}

