/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http;

import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ApacheConnectionPoolConfig {
    private final int totalOpenConnections;
    private final int defaultMaxConnectionsPerRoute;
    private final Map.Entry<Integer, TimeUnit> ttl;

    public static ApacheConnectionPoolConfig newDefault() {
        return ApacheConnectionPoolConfig.builder().defaultMaxConnectionsPerRoute(50).totalOpenConnections(50).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private ApacheConnectionPoolConfig(Builder builder) {
        this.totalOpenConnections = builder.totalOpenConnections;
        this.defaultMaxConnectionsPerRoute = builder.defaultMaxConnectionsPerRoute;
        this.ttl = builder.ttl;
    }

    public int getTotalOpenConnections() {
        return this.totalOpenConnections;
    }

    public int getDefaultMaxConnectionsPerRoute() {
        return this.defaultMaxConnectionsPerRoute;
    }

    public Map.Entry<Integer, TimeUnit> getTtl() {
        return this.ttl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApacheConnectionPoolConfig)) {
            return false;
        }
        ApacheConnectionPoolConfig other = (ApacheConnectionPoolConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotalOpenConnections() != other.getTotalOpenConnections()) {
            return false;
        }
        if (this.getDefaultMaxConnectionsPerRoute() != other.getDefaultMaxConnectionsPerRoute()) {
            return false;
        }
        Map.Entry<Integer, TimeUnit> this$ttl = this.getTtl();
        Map.Entry<Integer, TimeUnit> other$ttl = other.getTtl();
        return !(this$ttl == null ? other$ttl != null : !((Object)this$ttl).equals(other$ttl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApacheConnectionPoolConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTotalOpenConnections();
        result = result * 59 + this.getDefaultMaxConnectionsPerRoute();
        Map.Entry<Integer, TimeUnit> $ttl = this.getTtl();
        result = result * 59 + ($ttl == null ? 43 : ((Object)$ttl).hashCode());
        return result;
    }

    public String toString() {
        return "ApacheConnectionPoolConfig(totalOpenConnections=" + this.getTotalOpenConnections() + ", defaultMaxConnectionsPerRoute=" + this.getDefaultMaxConnectionsPerRoute() + ", ttl=" + this.getTtl() + ")";
    }

    public static final class Builder {
        private int totalOpenConnections;
        private int defaultMaxConnectionsPerRoute;
        private Map.Entry<Integer, TimeUnit> ttl;

        public Builder totalOpenConnections(int totalOpenConnections) {
            this.totalOpenConnections = totalOpenConnections;
            return this;
        }

        public Builder defaultMaxConnectionsPerRoute(int defaultMaxConnectionsPerRoute) {
            this.defaultMaxConnectionsPerRoute = defaultMaxConnectionsPerRoute;
            return this;
        }

        public Builder ttlInMillis(int ttlInMillis) {
            this.ttl = new AbstractMap.SimpleEntry<Integer, TimeUnit>(ttlInMillis, TimeUnit.MILLISECONDS);
            return this;
        }

        public Builder ttl(int ttl, TimeUnit ttlTimeUnit) {
            this.ttl = new AbstractMap.SimpleEntry<Integer, TimeUnit>(ttl, ttlTimeUnit);
            return this;
        }

        public ApacheConnectionPoolConfig build() {
            return new ApacheConnectionPoolConfig(this);
        }
    }
}

