/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth.internal;

import com.oracle.bmc.auth.InstancePrincipalsAuthenticationDetailsProvider;
import com.oracle.bmc.auth.SessionKeySupplier;
import com.oracle.bmc.auth.internal.AbstractFederationClient;
import com.oracle.bmc.auth.internal.AuthUtils;
import com.oracle.bmc.auth.internal.GetResourcePrincipalSessionTokenRequest;
import com.oracle.bmc.auth.internal.GetResourcePrincipalTokenResponse;
import com.oracle.bmc.auth.internal.RptPathProvider;
import com.oracle.bmc.auth.internal.SecurityTokenAdapter;
import com.oracle.bmc.auth.internal.X509FederationClient;
import com.oracle.bmc.circuitbreaker.CircuitBreakerConfiguration;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import java.net.URI;
import java.security.KeyPair;
import java.security.interfaces.RSAPublicKey;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcePrincipalsFederationClient
extends AbstractFederationClient {
    private static final Logger LOG = LoggerFactory.getLogger(ResourcePrincipalsFederationClient.class);
    private final InstancePrincipalsAuthenticationDetailsProvider provider;
    private final RptPathProvider resourcePrincipalTokenPathProvider;

    public ResourcePrincipalsFederationClient(String resourcePrincipalTokenEndpoint, RptPathProvider resourcePrincipalTokenPathProvider, String resourcePrincipalSessionTokenEndpoint, SessionKeySupplier sessionKeySupplier, InstancePrincipalsAuthenticationDetailsProvider instancePrincipalsAuthenticationDetailsProvider, ClientConfigurator clientConfigurator, CircuitBreakerConfiguration circuitBreakerConfiguration) {
        super(resourcePrincipalTokenEndpoint, resourcePrincipalSessionTokenEndpoint, sessionKeySupplier, instancePrincipalsAuthenticationDetailsProvider, clientConfigurator, circuitBreakerConfiguration);
        this.provider = instancePrincipalsAuthenticationDetailsProvider;
        this.resourcePrincipalTokenPathProvider = resourcePrincipalTokenPathProvider;
    }

    @Override
    protected SecurityTokenAdapter getSecurityTokenFromServer() {
        LOG.info("Getting security token from the auth server");
        KeyPair keyPair = this.sessionKeySupplier.getKeyPair();
        if (keyPair == null) {
            throw new IllegalStateException("Keypair for session was not provided");
        }
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        if (publicKey == null) {
            throw new IllegalArgumentException("Public key is not present");
        }
        this.provider.refresh();
        this.restClient.setEndpoint(this.resourcePrincipalTokenEndpoint);
        WrappedWebTarget target = this.restClient.getBaseTarget().path(this.resourcePrincipalTokenPathProvider.getPath());
        Invocation.Builder ib = target.request();
        URI requestUri = target.getUri();
        Response response = this.makeCall(ib, requestUri);
        ResponseHelper.throwIfNotSuccessful(response);
        GetResourcePrincipalTokenResponse getResourcePrincipalTokenResponse = ResponseHelper.readEntity(response, GetResourcePrincipalTokenResponse.class);
        String servicePrincipalSessionToken = getResourcePrincipalTokenResponse.getServicePrincipalSessionToken();
        String resourcePrincipalToken = getResourcePrincipalTokenResponse.getResourcePrincipalToken();
        this.restClient.setEndpoint(this.federationEndpoint);
        GetResourcePrincipalSessionTokenRequest getResourcePrincipalSessionTokenRequest = new GetResourcePrincipalSessionTokenRequest(resourcePrincipalToken, servicePrincipalSessionToken, AuthUtils.base64EncodeNoChunking(publicKey));
        target = this.restClient.getBaseTarget().path("v1").path("resourcePrincipalSessionToken");
        ib = target.request();
        requestUri = target.getUri();
        response = this.makeCall(ib, requestUri, getResourcePrincipalSessionTokenRequest);
        ResponseHelper.throwIfNotSuccessful(response);
        X509FederationClient.SecurityToken securityToken = (X509FederationClient.SecurityToken)((WithHeaders)SECURITY_TOKEN_FN.apply(response)).getItem();
        return new SecurityTokenAdapter(securityToken.getToken(), this.sessionKeySupplier);
    }
}

