/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth;

import com.google.common.base.Supplier;
import com.oracle.bmc.util.internal.FileUtils;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class SimplePrivateKeySupplier
implements java.util.function.Supplier<InputStream>,
Supplier<InputStream> {
    private final String pemFilePath;

    @ConstructorProperties(value={"pemFilePath"})
    public SimplePrivateKeySupplier(String pemFilePath) {
        this.pemFilePath = pemFilePath;
    }

    @Override
    public InputStream get() {
        try {
            return new FileInputStream(new File(FileUtils.expandUserHome(this.pemFilePath)));
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Could not find private key: " + this.pemFilePath, e);
        }
    }

    public String toString() {
        return "SimplePrivateKeySupplier(pemFilePath=" + this.pemFilePath + ")";
    }
}

