/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth;

import com.oracle.bmc.ConfigFileReader;
import com.oracle.bmc.Realm;
import com.oracle.bmc.Region;
import com.oracle.bmc.auth.AuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicConfigFileAuthenticationProvider;
import com.oracle.bmc.auth.InstancePrincipalsAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.auth.ResourcePrincipalAuthenticationDetailsProvider;
import com.oracle.bmc.auth.SimpleAuthenticationDetailsProvider;
import com.oracle.bmc.auth.SimplePrivateKeySupplier;
import com.oracle.bmc.auth.internal.ConfigFileDelegationTokenUtils;
import com.oracle.bmc.auth.internal.DelegationTokenConfigurator;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.util.internal.StringUtils;
import com.oracle.bmc.util.internal.Validate;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigFileAuthenticationDetailsProvider
implements AuthenticationDetailsProvider,
RegionProvider,
ProvidesClientConfigurators {
    private static final String OCI_REGION_ENV_VAR_NAME = "OCI_REGION";
    private static final String AUTHENTICATION_TYPE_KEY = "authentication_type";
    private static final String INSTANCE_PRINCIPAL_AUTHENTICATION_TYPE_VALUE = "instance_principal";
    private static final String RESOURCE_PRINCIPAL_AUTHENTICATION_TYPE_VALUE = "resource_principal";
    private static final Logger LOG = LoggerFactory.getLogger(ConfigFileAuthenticationDetailsProvider.class);
    protected final BasicConfigFileAuthenticationProvider delegate;
    private final Region region;
    private static final String CONFIG_FILE_DEBUG_INFORMATION_LOG = "\nFor more information about OCI configuration file and how to get required information, see https://docs.oracle.com/en-us/iaas/Content/API/Concepts/sdkconfig.htm";

    public ConfigFileAuthenticationDetailsProvider(String profile) throws IOException {
        this(ConfigFileReader.parseDefault(profile));
    }

    public ConfigFileAuthenticationDetailsProvider(String configurationFilePath, String profile) throws IOException {
        this(ConfigFileReader.parse(configurationFilePath, profile));
    }

    public ConfigFileAuthenticationDetailsProvider(ConfigFileReader.ConfigFile configFile) {
        String authentication_type = configFile.get(AUTHENTICATION_TYPE_KEY);
        if (INSTANCE_PRINCIPAL_AUTHENTICATION_TYPE_VALUE.equals(authentication_type)) {
            this.delegate = new ConfigFileInstancePrincipalAuthenticationDetailsProvider(configFile);
        } else if (RESOURCE_PRINCIPAL_AUTHENTICATION_TYPE_VALUE.equals(authentication_type)) {
            LOG.debug("Authentication type in config file: " + configFile.get(AUTHENTICATION_TYPE_KEY));
            this.delegate = new ConfigFileResourcePrincipalAuthenticationDetailsProvider(configFile);
        } else {
            this.delegate = new ConfigFileSimpleAuthenticationDetailsProvider(configFile);
        }
        this.region = ConfigFileAuthenticationDetailsProvider.getRegionFromConfigFile(configFile);
    }

    public static Region getRegionFromConfigFile(ConfigFileReader.ConfigFile configFile) {
        Region region = null;
        String regionId = configFile.get("region");
        if (StringUtils.isBlank(regionId)) {
            regionId = System.getenv(OCI_REGION_ENV_VAR_NAME);
            LOG.info("regionId from OCI_REGION env variable: " + regionId);
        }
        if (regionId != null) {
            try {
                region = Region.fromRegionId(regionId);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Found regionId '{}' in config file or OCI_REGION env variable, but not supported by this version of the SDK\nFor more information about OCI configuration file and how to get required information, see https://docs.oracle.com/en-us/iaas/Content/API/Concepts/sdkconfig.htm", (Object)regionId, (Object)e);
                region = Region.register(regionId, Realm.OC1);
            }
        } else {
            LOG.info("Region not specified in Config file or OCI_REGION env variable. Proceeding without setting a region.");
        }
        return region;
    }

    @Override
    public String getFingerprint() {
        return this.delegate.getFingerprint();
    }

    @Override
    public String getTenantId() {
        return this.delegate.getTenantId();
    }

    @Override
    public String getUserId() {
        return this.delegate.getUserId();
    }

    @Override
    public List<ClientConfigurator> getClientConfigurators() {
        return this.delegate.getClientConfigurators();
    }

    @Override
    @Deprecated
    public String getPassPhrase() {
        return this.delegate.getPassPhrase();
    }

    @Override
    public char[] getPassphraseCharacters() {
        return this.delegate.getPassphraseCharacters();
    }

    @Override
    public InputStream getPrivateKey() {
        return this.delegate.getPrivateKey();
    }

    @Override
    public String getKeyId() {
        return this.delegate.getKeyId();
    }

    @Override
    public Region getRegion() {
        return this.region;
    }

    public String getPemFilePath() {
        return this.delegate.getPemFilePath();
    }

    public String toString() {
        return "ConfigFileAuthenticationDetailsProvider(delegate=" + this.delegate + ", region=" + this.getRegion() + ")";
    }

    protected static class ConfigFileResourcePrincipalAuthenticationDetailsProvider
    implements BasicConfigFileAuthenticationProvider {
        private final ResourcePrincipalAuthenticationDetailsProvider delegate = ResourcePrincipalAuthenticationDetailsProvider.builder().build();
        private final String tenantId;
        private final List<ClientConfigurator> clientConfigurators;

        protected ConfigFileResourcePrincipalAuthenticationDetailsProvider(ConfigFileReader.ConfigFile configFile) {
            String tenantId = configFile.get("tenancy");
            if (tenantId == null) {
                tenantId = "";
            }
            this.tenantId = tenantId;
            this.clientConfigurators = new ArrayList<ClientConfigurator>();
            try {
                String delegationToken = ConfigFileDelegationTokenUtils.parseAndGetToken(configFile);
                if (!StringUtils.isBlank(delegationToken)) {
                    this.clientConfigurators.add(new DelegationTokenConfigurator(delegationToken));
                }
            }
            catch (Exception e) {
                LOG.debug("Could not load delegation token!", (Throwable)e);
            }
        }

        @Override
        public String getFingerprint() {
            return null;
        }

        @Override
        public String getTenantId() {
            return this.tenantId;
        }

        @Override
        public String getUserId() {
            return null;
        }

        @Override
        public String getKeyId() {
            return this.delegate.getKeyId();
        }

        @Override
        public InputStream getPrivateKey() {
            return this.delegate.getPrivateKey();
        }

        @Override
        public String getPassPhrase() {
            return null;
        }

        @Override
        public char[] getPassphraseCharacters() {
            return null;
        }

        @Override
        public String getPemFilePath() {
            return null;
        }

        @Override
        public List<ClientConfigurator> getClientConfigurators() {
            return this.clientConfigurators;
        }
    }

    protected static class ConfigFileInstancePrincipalAuthenticationDetailsProvider
    implements BasicConfigFileAuthenticationProvider {
        private final InstancePrincipalsAuthenticationDetailsProvider delegate = InstancePrincipalsAuthenticationDetailsProvider.builder().build();
        private final String tenantId;
        private final List<ClientConfigurator> clientConfigurators;

        protected ConfigFileInstancePrincipalAuthenticationDetailsProvider(ConfigFileReader.ConfigFile configFile) {
            String tenantId = configFile.get("tenancy");
            if (tenantId == null) {
                tenantId = "";
            }
            this.tenantId = tenantId;
            this.clientConfigurators = new ArrayList<ClientConfigurator>();
            try {
                String delegationToken = ConfigFileDelegationTokenUtils.parseAndGetToken(configFile);
                if (!StringUtils.isBlank(delegationToken)) {
                    this.clientConfigurators.add(new DelegationTokenConfigurator(delegationToken));
                }
            }
            catch (Exception e) {
                LOG.debug("Could not load delegation token!", (Throwable)e);
            }
        }

        @Override
        public String getFingerprint() {
            return null;
        }

        @Override
        public String getTenantId() {
            return this.tenantId;
        }

        @Override
        public String getUserId() {
            return null;
        }

        @Override
        public String getKeyId() {
            return this.delegate.getKeyId();
        }

        @Override
        public InputStream getPrivateKey() {
            return this.delegate.getPrivateKey();
        }

        @Override
        public String getPassPhrase() {
            return null;
        }

        @Override
        public char[] getPassphraseCharacters() {
            return null;
        }

        @Override
        public String getPemFilePath() {
            return null;
        }

        @Override
        public List<ClientConfigurator> getClientConfigurators() {
            return this.clientConfigurators;
        }
    }

    protected static class ConfigFileSimpleAuthenticationDetailsProvider
    implements BasicConfigFileAuthenticationProvider {
        private final SimpleAuthenticationDetailsProvider delegate;
        private final String pemFilePath;
        private final List<ClientConfigurator> clientConfigurators;

        protected ConfigFileSimpleAuthenticationDetailsProvider(ConfigFileReader.ConfigFile configFile) {
            String fingerprint = Validate.notNull(configFile.get("fingerprint"), "Missing fingerprint in config.\nFor more information about OCI configuration file and how to get required information, see https://docs.oracle.com/en-us/iaas/Content/API/Concepts/sdkconfig.htm", new Object[0]);
            String tenantId = Validate.notNull(configFile.get("tenancy"), "Missing tenancy in config.\nFor more information about OCI configuration file and how to get required information, see https://docs.oracle.com/en-us/iaas/Content/API/Concepts/sdkconfig.htm", new Object[0]);
            String userId = Validate.notNull(configFile.get("user"), "Missing user in config.\nFor more information about OCI configuration file and how to get required information, see https://docs.oracle.com/en-us/iaas/Content/API/Concepts/sdkconfig.htm", new Object[0]);
            String pemFilePath = Validate.notNull(configFile.get("key_file"), "Missing key_file in config.\nFor more information about OCI configuration file and how to get required information, see https://docs.oracle.com/en-us/iaas/Content/API/Concepts/sdkconfig.htm", new Object[0]);
            String passPhrase = configFile.get("pass_phrase");
            SimplePrivateKeySupplier privateKeySupplier = new SimplePrivateKeySupplier(pemFilePath);
            SimpleAuthenticationDetailsProvider.SimpleAuthenticationDetailsProviderBuilder builder = SimpleAuthenticationDetailsProvider.builder().privateKeySupplier(privateKeySupplier).fingerprint(fingerprint).userId(userId).tenantId(tenantId);
            if (passPhrase != null) {
                builder = builder.passphraseCharacters(passPhrase.toCharArray());
            }
            this.delegate = builder.build();
            this.pemFilePath = pemFilePath;
            this.clientConfigurators = new ArrayList<ClientConfigurator>();
        }

        @Override
        public String getFingerprint() {
            return this.delegate.getFingerprint();
        }

        @Override
        public String getTenantId() {
            return this.delegate.getTenantId();
        }

        @Override
        public String getUserId() {
            return this.delegate.getUserId();
        }

        @Override
        @Deprecated
        public String getPassPhrase() {
            return this.delegate.getPassPhrase();
        }

        @Override
        @Deprecated
        public char[] getPassphraseCharacters() {
            return this.delegate.getPassphraseCharacters();
        }

        @Override
        public InputStream getPrivateKey() {
            return this.delegate.getPrivateKey();
        }

        @Override
        public String getKeyId() {
            return this.delegate.getKeyId();
        }

        @Override
        public String getPemFilePath() {
            return this.pemFilePath;
        }

        @Override
        public List<ClientConfigurator> getClientConfigurators() {
            return this.clientConfigurators;
        }
    }
}

