/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.client.pki;

abstract class Hex {
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    private Hex() {
    }

    static String encode(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    static byte[] decode(CharSequence hex) {
        int length = hex.length();
        byte[] bytes = new byte[length / 2];
        for (int i = 0; i < length; ++i) {
            int highNibble = Character.digit(hex.charAt(i), 16) << 4;
            int lowNibble = Character.digit(hex.charAt(++i), 16);
            bytes[i / 2] = (byte)(highNibble + lowNibble);
        }
        return bytes;
    }
}

