/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.client;

import com.oracle.bmc.http.client.HttpProvider;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

class DefaultHolder {
    private static HttpProvider DEFAULT = null;

    DefaultHolder() {
    }

    public static synchronized HttpProvider getDefault() {
        if (DEFAULT == null) {
            DEFAULT = DefaultHolder.findHttpProvider();
        }
        return DEFAULT;
    }

    private static HttpProvider findHttpProvider() {
        Iterator<HttpProvider> itr = ServiceLoader.load(HttpProvider.class).iterator();
        ServiceConfigurationError lastException = null;
        while (itr.hasNext()) {
            try {
                return itr.next();
            }
            catch (ServiceConfigurationError e) {
                lastException = e;
            }
        }
        if (lastException == null) {
            throw new NoSuchElementException("No http provider available; add dependency on one of the oci-java-sdk-common-httpclient-* choices, e.g. oci-java-sdk-common-httpclient-jersey");
        }
        throw lastException;
    }
}

