/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util.reflection;

import java.util.HashMap;
import java.util.Map;

public class ReflectionContextState {
    public static final String CURRENT_PROPERTY_PATH = "current.property.path";
    public static final String FULL_PROPERTY_PATH = "current.property.path";
    private static final String GETTING_BY_KEY_PROPERTY = "xwork.getting.by.key.property";
    private static final String SET_MAP_KEY = "set.map.key";
    public static final String CREATE_NULL_OBJECTS = "xwork.NullHandler.createNullObjects";
    public static final String DENY_METHOD_EXECUTION = "xwork.MethodAccessor.denyMethodExecution";
    public static final String DENY_INDEXED_ACCESS_EXECUTION = "xwork.IndexedPropertyAccessor.denyMethodExecution";

    public static boolean isCreatingNullObjects(Map context) {
        return ReflectionContextState.getBooleanProperty(CREATE_NULL_OBJECTS, context);
    }

    public static void setCreatingNullObjects(Map context, boolean creatingNullObjects) {
        ReflectionContextState.setBooleanValue(CREATE_NULL_OBJECTS, context, creatingNullObjects);
    }

    public static boolean isGettingByKeyProperty(Map context) {
        return ReflectionContextState.getBooleanProperty(GETTING_BY_KEY_PROPERTY, context);
    }

    public static void setDenyMethodExecution(Map context, boolean denyMethodExecution) {
        ReflectionContextState.setBooleanValue(DENY_METHOD_EXECUTION, context, denyMethodExecution);
    }

    public static boolean isDenyMethodExecution(Map context) {
        return ReflectionContextState.getBooleanProperty(DENY_METHOD_EXECUTION, context);
    }

    public static void setGettingByKeyProperty(Map context, boolean gettingByKeyProperty) {
        ReflectionContextState.setBooleanValue(GETTING_BY_KEY_PROPERTY, context, gettingByKeyProperty);
    }

    public static boolean isReportingConversionErrors(Map context) {
        return ReflectionContextState.getBooleanProperty("report.conversion.errors", context);
    }

    public static void setReportingConversionErrors(Map context, boolean reportingErrors) {
        ReflectionContextState.setBooleanValue("report.conversion.errors", context, reportingErrors);
    }

    public static Class getLastBeanClassAccessed(Map context) {
        return (Class)context.get("last.bean.accessed");
    }

    public static void setLastBeanPropertyAccessed(Map context, String property) {
        context.put("last.property.accessed", property);
    }

    public static String getLastBeanPropertyAccessed(Map context) {
        return (String)context.get("last.property.accessed");
    }

    public static void setLastBeanClassAccessed(Map context, Class clazz) {
        context.put("last.bean.accessed", clazz);
    }

    public static String getCurrentPropertyPath(Map context) {
        return (String)context.get("current.property.path");
    }

    public static String getFullPropertyPath(Map context) {
        return (String)context.get("current.property.path");
    }

    public static void setFullPropertyPath(Map context, String path) {
        context.put("current.property.path", path);
    }

    public static void updateCurrentPropertyPath(Map context, Object name) {
        String currentPath = ReflectionContextState.getCurrentPropertyPath(context);
        if (name != null) {
            currentPath = currentPath != null ? currentPath + "." + name.toString() : name.toString();
            context.put("current.property.path", currentPath);
        }
    }

    public static void setSetMap(Map context, Map setMap, String path) {
        HashMap<String, Map> mapOfSetMaps = (HashMap<String, Map>)context.get(SET_MAP_KEY);
        if (mapOfSetMaps == null) {
            mapOfSetMaps = new HashMap<String, Map>();
            context.put(SET_MAP_KEY, mapOfSetMaps);
        }
        mapOfSetMaps.put(path, setMap);
    }

    public static Map getSetMap(Map context, String path) {
        Map mapOfSetMaps = (Map)context.get(SET_MAP_KEY);
        if (mapOfSetMaps == null) {
            return null;
        }
        return (Map)mapOfSetMaps.get(path);
    }

    private static boolean getBooleanProperty(String property, Map context) {
        Boolean myBool = (Boolean)context.get(property);
        return myBool == null ? false : myBool;
    }

    private static void setBooleanValue(String property, Map context, boolean value) {
        context.put(property, new Boolean(value));
    }

    public static void clearCurrentPropertyPath(Map context) {
        context.put("current.property.path", null);
    }

    public static void clear(Map context) {
        if (context != null) {
            context.put("last.bean.accessed", null);
            context.put("last.property.accessed", null);
            context.put("current.property.path", null);
            context.put("current.property.path", null);
        }
    }
}

