/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class PrefixMethodInvocationUtil {
    private static final Logger LOG = LoggerFactory.getLogger(PrefixMethodInvocationUtil.class);
    private static final String DEFAULT_INVOCATION_METHODNAME = "execute";

    public static void invokePrefixMethod(ActionInvocation actionInvocation, String[] prefixes) throws InvocationTargetException, IllegalAccessException {
        Method method;
        Object action = actionInvocation.getAction();
        String methodName = actionInvocation.getProxy().getMethod();
        if (methodName == null) {
            methodName = DEFAULT_INVOCATION_METHODNAME;
        }
        if ((method = PrefixMethodInvocationUtil.getPrefixedMethod(prefixes, methodName, action)) != null) {
            method.invoke(action, new Object[0]);
        }
    }

    public static Method getPrefixedMethod(String[] prefixes, String methodName, Object action) {
        assert (prefixes != null);
        String capitalizedMethodName = PrefixMethodInvocationUtil.capitalizeMethodName(methodName);
        for (int a = 0; a < prefixes.length; ++a) {
            String prefixedMethodName = prefixes[a] + capitalizedMethodName;
            try {
                Method method = action.getClass().getMethod(prefixedMethodName, new Class[0]);
                return method;
            }
            catch (NoSuchMethodException e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("cannot find method [" + prefixedMethodName + "] in action [" + action + "]", new String[0]);
                continue;
            }
        }
        return null;
    }

    public static String capitalizeMethodName(String methodName) {
        assert (methodName != null);
        return methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
    }
}

