/*
 * Decompiled with CFR 0.152.
 */
package com.openai.client.okhttp;

import com.openai.core.RequestOptions;
import com.openai.core.Timeout;
import com.openai.core.http.Headers;
import com.openai.core.http.HttpClient;
import com.openai.core.http.HttpMethod;
import com.openai.core.http.HttpRequest;
import com.openai.core.http.HttpRequestBody;
import com.openai.core.http.HttpResponse;
import com.openai.errors.OpenAIIoException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.time.Duration;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Cache;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 #2\u00020\u0001:\u0002\"#B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0017H\u0002J\u0014\u0010\u0018\u001a\u00020\u0019*\u00020\n2\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\f\u0010\u001b\u001a\u00020\u001c*\u00020\u001dH\u0002J\f\u0010\u001e\u001a\u00020\b*\u00020\u001fH\u0002J\f\u0010 \u001a\u00020!*\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/openai/client/okhttp/OkHttpClient;", "Lcom/openai/core/http/HttpClient;", "okHttpClient", "Lokhttp3/OkHttpClient;", "(Lokhttp3/OkHttpClient;)V", "close", "", "execute", "Lcom/openai/core/http/HttpResponse;", "request", "Lcom/openai/core/http/HttpRequest;", "requestOptions", "Lcom/openai/core/RequestOptions;", "executeAsync", "Ljava/util/concurrent/CompletableFuture;", "newCall", "Lokhttp3/Call;", "requiresBody", "", "method", "Lcom/openai/core/http/HttpMethod;", "toHeaders", "Lcom/openai/core/http/Headers;", "Lokhttp3/Headers;", "toRequest", "Lokhttp3/Request;", "client", "toRequestBody", "Lokhttp3/RequestBody;", "Lcom/openai/core/http/HttpRequestBody;", "toResponse", "Lokhttp3/Response;", "toUrl", "", "Builder", "Companion", "openai-java-client-okhttp"})
@SourceDebugExtension(value={"SMAP\nOkHttpClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OkHttpClient.kt\ncom/openai/client/okhttp/OkHttpClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,247:1\n1#2:248\n1855#3:249\n1855#3,2:250\n1856#3:252\n1855#3,2:253\n1855#3:255\n1855#3,2:256\n1856#3:258\n1855#3,2:259\n*S KotlinDebug\n*F\n+ 1 OkHttpClient.kt\ncom/openai/client/okhttp/OkHttpClient\n*L\n111#1:249\n112#1:250,2\n111#1:252\n144#1:253,2\n145#1:255\n146#1:256,2\n145#1:258\n183#1:259,2\n*E\n"})
public final class OkHttpClient
implements HttpClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final okhttp3.OkHttpClient okHttpClient;

    private OkHttpClient(okhttp3.OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public HttpResponse execute(@NotNull HttpRequest request, @NotNull RequestOptions requestOptions) {
        HttpResponse httpResponse;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        Call call = this.newCall(request, requestOptions);
        try {
            httpResponse = this.toResponse(call.execute());
        }
        catch (IOException e) {
            throw new OpenAIIoException("Request failed", (Throwable)e);
        }
        finally {
            HttpRequestBody httpRequestBody = request.body();
            if (httpRequestBody != null) {
                httpRequestBody.close();
            }
        }
        return httpResponse;
    }

    @NotNull
    public CompletableFuture<HttpResponse> executeAsync(@NotNull HttpRequest request, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        CompletableFuture<HttpResponse> future = new CompletableFuture<HttpResponse>();
        HttpRequestBody httpRequestBody = request.body();
        if (httpRequestBody != null) {
            HttpRequestBody $this$executeAsync_u24lambda_u241 = httpRequestBody;
            boolean bl = false;
            future.whenComplete((arg_0, arg_1) -> OkHttpClient.executeAsync$lambda$1$lambda$0((Function2)new Function2<HttpResponse, Throwable, Unit>($this$executeAsync_u24lambda_u241){
                final /* synthetic */ HttpRequestBody $this_run;
                {
                    this.$this_run = $receiver;
                    super(2);
                }

                public final void invoke(HttpResponse httpResponse, Throwable throwable) {
                    this.$this_run.close();
                }
            }, arg_0, arg_1));
        }
        this.newCall(request, requestOptions).enqueue(new Callback(future, this){
            final /* synthetic */ CompletableFuture<HttpResponse> $future;
            final /* synthetic */ OkHttpClient this$0;
            {
                this.$future = $future;
                this.this$0 = $receiver;
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                this.$future.complete(OkHttpClient.access$toResponse(this.this$0, response));
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$future.completeExceptionally((Throwable)new OpenAIIoException("Request failed", (Throwable)e));
            }
        });
        return future;
    }

    public void close() {
        block0: {
            this.okHttpClient.dispatcher().executorService().shutdown();
            this.okHttpClient.connectionPool().evictAll();
            Cache cache = this.okHttpClient.cache();
            if (cache == null) break block0;
            cache.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Call newCall(HttpRequest request, RequestOptions requestOptions) {
        HttpLoggingInterceptor.Level logLevel;
        String string;
        String string2;
        OkHttpClient.Builder clientBuilder = this.okHttpClient.newBuilder();
        String string3 = System.getenv("OPENAI_LOG");
        if (string3 != null) {
            String string4 = string3.toLowerCase(Locale.ROOT);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        } else {
            string2 = string = null;
        }
        Object object = Intrinsics.areEqual((Object)string, (Object)"info") ? HttpLoggingInterceptor.Level.BASIC : (logLevel = Intrinsics.areEqual((Object)string, (Object)"debug") ? HttpLoggingInterceptor.Level.BODY : null);
        if (logLevel != null) {
            void $this$newCall_u24lambda_u242;
            String string5 = string = new HttpLoggingInterceptor(null, 1, null).setLevel(logLevel);
            OkHttpClient.Builder builder = clientBuilder;
            boolean bl = false;
            $this$newCall_u24lambda_u242.redactHeader("Authorization");
            builder.addNetworkInterceptor((Interceptor)string);
        }
        Timeout timeout = requestOptions.getTimeout();
        if (timeout != null) {
            Timeout it = timeout;
            boolean bl = false;
            clientBuilder.connectTimeout(it.connect()).readTimeout(it.read()).writeTimeout(it.write()).callTimeout(it.request());
        }
        okhttp3.OkHttpClient client = clientBuilder.build();
        return client.newCall(this.toRequest(request, client));
    }

    private final Request toRequest(HttpRequest $this$toRequest, okhttp3.OkHttpClient client) {
        RequestBody body;
        HttpRequestBody httpRequestBody = $this$toRequest.body();
        RequestBody requestBody = body = httpRequestBody != null ? this.toRequestBody(httpRequestBody) : null;
        if (body == null && this.requiresBody($this$toRequest.method())) {
            body = RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (String)"", null, (int)1, null);
        }
        Request.Builder builder = new Request.Builder().url(this.toUrl($this$toRequest)).method($this$toRequest.method().name(), body);
        Iterable $this$forEach$iv = $this$toRequest.headers().names();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String name = (String)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = $this$toRequest.headers().values(name);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String it = (String)element$iv2;
                boolean bl2 = false;
                builder.addHeader(name, it);
            }
        }
        if (!$this$toRequest.headers().names().contains("X-Stainless-Read-Timeout") && client.readTimeoutMillis() != 0) {
            builder.addHeader("X-Stainless-Read-Timeout", String.valueOf(Duration.ofMillis(client.readTimeoutMillis()).getSeconds()));
        }
        if (!$this$toRequest.headers().names().contains("X-Stainless-Timeout") && client.callTimeoutMillis() != 0) {
            builder.addHeader("X-Stainless-Timeout", String.valueOf(Duration.ofMillis(client.callTimeoutMillis()).getSeconds()));
        }
        return builder.build();
    }

    private final boolean requiresBody(HttpMethod method) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[method.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private final String toUrl(HttpRequest $this$toUrl) {
        HttpUrl.Builder builder = HttpUrl.Companion.get($this$toUrl.baseUrl()).newBuilder();
        Iterable $this$forEach$iv = $this$toUrl.pathSegments();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String p0 = (String)element$iv;
            boolean bl = false;
            builder.addPathSegment(p0);
        }
        $this$forEach$iv = $this$toUrl.queryParams().keys();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String key = (String)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = $this$toUrl.queryParams().values(key);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String it = (String)element$iv2;
                boolean bl2 = false;
                builder.addQueryParameter(key, it);
            }
        }
        return builder.toString();
    }

    private final RequestBody toRequestBody(HttpRequestBody $this$toRequestBody) {
        String string = $this$toRequestBody.contentType();
        MediaType mediaType = string != null ? MediaType.Companion.get(string) : null;
        long length = $this$toRequestBody.contentLength();
        return new RequestBody(mediaType, length, $this$toRequestBody){
            final /* synthetic */ MediaType $mediaType;
            final /* synthetic */ long $length;
            final /* synthetic */ HttpRequestBody $this_toRequestBody;
            {
                this.$mediaType = $mediaType;
                this.$length = $length;
                this.$this_toRequestBody = $receiver;
            }

            @Nullable
            public MediaType contentType() {
                return this.$mediaType;
            }

            public long contentLength() {
                return this.$length;
            }

            public boolean isOneShot() {
                return !this.$this_toRequestBody.repeatable();
            }

            public void writeTo(@NotNull BufferedSink sink) {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                this.$this_toRequestBody.writeTo(sink.outputStream());
            }
        };
    }

    private final HttpResponse toResponse(Response $this$toResponse) {
        Headers headers = this.toHeaders($this$toResponse.headers());
        return new HttpResponse($this$toResponse, headers){
            final /* synthetic */ Response $this_toResponse;
            final /* synthetic */ Headers $headers;
            {
                this.$this_toResponse = $receiver;
                this.$headers = $headers;
            }

            public int statusCode() {
                return this.$this_toResponse.code();
            }

            @NotNull
            public Headers headers() {
                return this.$headers;
            }

            @NotNull
            public InputStream body() {
                ResponseBody responseBody = this.$this_toResponse.body();
                Intrinsics.checkNotNull((Object)responseBody);
                return responseBody.byteStream();
            }

            public void close() {
                ResponseBody responseBody = this.$this_toResponse.body();
                Intrinsics.checkNotNull((Object)responseBody);
                responseBody.close();
            }
        };
    }

    private final Headers toHeaders(okhttp3.Headers $this$toHeaders) {
        Headers.Builder headersBuilder = Headers.Companion.builder();
        Iterable $this$forEach$iv = (Iterable)$this$toHeaders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            String name = (String)pair.component1();
            String value = (String)pair.component2();
            headersBuilder.put(name, value);
        }
        return headersBuilder.build();
    }

    private static final void executeAsync$lambda$1$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    @JvmStatic
    @NotNull
    public static final Builder builder() {
        return Companion.builder();
    }

    public static final /* synthetic */ HttpResponse access$toResponse(OkHttpClient $this, Response $receiver) {
        return $this.toResponse($receiver);
    }

    public /* synthetic */ OkHttpClient(okhttp3.OkHttpClient okHttpClient, DefaultConstructorMarker $constructor_marker) {
        this(okHttpClient);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u0003\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0005\u001a\u00020\u00002\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u0007\u001a\u00020\u00002\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u000fJ\u0010\u0010\u000b\u001a\u00020\u00002\b\u0010\u000b\u001a\u0004\u0018\u00010\fR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/openai/client/okhttp/OkHttpClient$Builder;", "", "()V", "hostnameVerifier", "Ljavax/net/ssl/HostnameVerifier;", "proxy", "Ljava/net/Proxy;", "sslSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "timeout", "Lcom/openai/core/Timeout;", "trustManager", "Ljavax/net/ssl/X509TrustManager;", "build", "Lcom/openai/client/okhttp/OkHttpClient;", "Ljava/time/Duration;", "openai-java-client-okhttp"})
    @SourceDebugExtension(value={"SMAP\nOkHttpClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OkHttpClient.kt\ncom/openai/client/okhttp/OkHttpClient$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,247:1\n1#2:248\n*E\n"})
    public static final class Builder {
        @NotNull
        private Timeout timeout = Timeout.Companion.default();
        @Nullable
        private Proxy proxy;
        @Nullable
        private SSLSocketFactory sslSocketFactory;
        @Nullable
        private X509TrustManager trustManager;
        @Nullable
        private HostnameVerifier hostnameVerifier;

        @NotNull
        public final Builder timeout(@NotNull Timeout timeout) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
            Builder $this$timeout_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$timeout_u24lambda_u240.timeout = timeout;
            return builder;
        }

        @NotNull
        public final Builder timeout(@NotNull Duration timeout) {
            Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
            return this.timeout(Timeout.Companion.builder().request(timeout).build());
        }

        @NotNull
        public final Builder proxy(@Nullable Proxy proxy) {
            Builder builder;
            Builder $this$proxy_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$proxy_u24lambda_u241.proxy = proxy;
            return builder;
        }

        @NotNull
        public final Builder sslSocketFactory(@Nullable SSLSocketFactory sslSocketFactory) {
            Builder builder;
            Builder $this$sslSocketFactory_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$sslSocketFactory_u24lambda_u242.sslSocketFactory = sslSocketFactory;
            return builder;
        }

        @NotNull
        public final Builder trustManager(@Nullable X509TrustManager trustManager) {
            Builder builder;
            Builder $this$trustManager_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$trustManager_u24lambda_u243.trustManager = trustManager;
            return builder;
        }

        @NotNull
        public final Builder hostnameVerifier(@Nullable HostnameVerifier hostnameVerifier) {
            Builder builder;
            Builder $this$hostnameVerifier_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$hostnameVerifier_u24lambda_u244.hostnameVerifier = hostnameVerifier;
            return builder;
        }

        @NotNull
        public final OkHttpClient build() {
            OkHttpClient.Builder builder;
            OkHttpClient.Builder $this$build_u24lambda_u246 = builder = new OkHttpClient.Builder().connectTimeout(this.timeout.connect()).readTimeout(this.timeout.read()).writeTimeout(this.timeout.write()).callTimeout(this.timeout.request()).proxy(this.proxy);
            boolean bl = false;
            SSLSocketFactory sslSocketFactory = this.sslSocketFactory;
            X509TrustManager trustManager = this.trustManager;
            if (sslSocketFactory != null && trustManager != null) {
                $this$build_u24lambda_u246.sslSocketFactory(sslSocketFactory, trustManager);
            } else if (!(sslSocketFactory != null == (trustManager != null))) {
                boolean bl2 = false;
                String string = "Both or none of `sslSocketFactory` and `trustManager` must be set, but only one was set";
                throw new IllegalStateException(string.toString());
            }
            HostnameVerifier hostnameVerifier = this.hostnameVerifier;
            if (hostnameVerifier != null) {
                HostnameVerifier p0 = hostnameVerifier;
                boolean bl3 = false;
                $this$build_u24lambda_u246.hostnameVerifier(p0);
            }
            OkHttpClient.Builder $this$build_u24lambda_u247 = builder = builder.build();
            boolean bl4 = false;
            $this$build_u24lambda_u247.dispatcher().setMaxRequestsPerHost($this$build_u24lambda_u247.dispatcher().getMaxRequests());
            DefaultConstructorMarker defaultConstructorMarker = null;
            OkHttpClient.Builder builder2 = builder;
            return new OkHttpClient((okhttp3.OkHttpClient)builder2, defaultConstructorMarker);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/openai/client/okhttp/OkHttpClient$Companion;", "", "()V", "builder", "Lcom/openai/client/okhttp/OkHttpClient$Builder;", "openai-java-client-okhttp"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Builder builder() {
            return new Builder();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HttpMethod.values().length];
            try {
                nArray[HttpMethod.POST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HttpMethod.PUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HttpMethod.PATCH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

