/*
 * Decompiled with CFR 0.152.
 */
package com.oopsguy.kaptcha.autoconfigure.util;

import com.oopsguy.kaptcha.autoconfigure.BaseProperties;
import com.oopsguy.kaptcha.autoconfigure.KaptchaProperties;
import java.util.Properties;

public class ConfigUtils {
    public static Properties kaptchaPropertiesToProperties(BaseProperties kaptchaProperties) {
        Properties properties = new Properties();
        Boolean border = kaptchaProperties.getBorder().getEnabled();
        properties.setProperty("kaptcha.border", border == null ? "" : (Boolean.FALSE.equals(border) ? "no" : "yes"));
        properties.setProperty("kaptcha.border.color", ConfigUtils.nullToString(kaptchaProperties.getBorder().getColor()));
        properties.setProperty("kaptcha.border.thickness", ConfigUtils.nullToString(kaptchaProperties.getBorder().getThickness()));
        properties.setProperty("kaptcha.noise.color", ConfigUtils.nullToString(kaptchaProperties.getNoise().getColor()));
        properties.setProperty("kaptcha.noise.impl", ConfigUtils.nullToString(kaptchaProperties.getNoise().getImpl()));
        properties.setProperty("kaptcha.obscurificator.impl", ConfigUtils.nullToString(kaptchaProperties.getObscurificator().getImpl()));
        properties.setProperty("kaptcha.producer.impl", ConfigUtils.nullToString(kaptchaProperties.getProducer().getImpl()));
        properties.setProperty("kaptcha.textproducer.impl", ConfigUtils.nullToString(kaptchaProperties.getTextProducer().getImpl()));
        properties.setProperty("kaptcha.textproducer.char.string", ConfigUtils.nullToString(kaptchaProperties.getTextProducer().getCharacter().getString()));
        properties.setProperty("kaptcha.textproducer.char.length", ConfigUtils.nullToString(kaptchaProperties.getTextProducer().getCharacter().getLength()));
        properties.setProperty("kaptcha.textproducer.char.space", ConfigUtils.nullToString(kaptchaProperties.getTextProducer().getCharacter().getSpace()));
        properties.setProperty("kaptcha.textproducer.font.names", String.join((CharSequence)",", kaptchaProperties.getTextProducer().getFont().getNames()));
        properties.setProperty("kaptcha.textproducer.font.color", ConfigUtils.nullToString(kaptchaProperties.getTextProducer().getFont().getColor()));
        properties.setProperty("kaptcha.textproducer.font.size", ConfigUtils.nullToString(kaptchaProperties.getTextProducer().getFont().getSize()));
        properties.setProperty("kaptcha.word.impl", ConfigUtils.nullToString(kaptchaProperties.getWord().getImpl()));
        properties.setProperty("kaptcha.background.impl", ConfigUtils.nullToString(kaptchaProperties.getBackground().getImpl()));
        properties.setProperty("kaptcha.background.clear.from", ConfigUtils.nullToString(kaptchaProperties.getBackground().getColorFrom()));
        properties.setProperty("kaptcha.background.clear.to", ConfigUtils.nullToString(kaptchaProperties.getBackground().getColorTo()));
        properties.setProperty("kaptcha.image.width", ConfigUtils.nullToString(kaptchaProperties.getImage().getWidth()));
        properties.setProperty("kaptcha.image.height", ConfigUtils.nullToString(kaptchaProperties.getImage().getHeight()));
        return properties;
    }

    public static Properties kaptchaSubPropertiesToProperties(String name, KaptchaProperties.SingleKaptchaProperties properties) {
        Properties props = ConfigUtils.kaptchaPropertiesToProperties(properties);
        props.setProperty("kaptcha.session.key", ConfigUtils.emptyToDefault(properties.getSession().getKey(), name + "_" + "KAPTCHA_SESSION_KEY"));
        props.setProperty("kaptcha.session.date", ConfigUtils.emptyToDefault(properties.getSession().getDate(), name + "_" + "KAPTCHA_SESSION_DATE"));
        return props;
    }

    private static String nullToString(Object value) {
        if (value != null) {
            return String.valueOf(value);
        }
        return "";
    }

    private static String emptyToDefault(String val, String defaultVal) {
        if (val == null || "".equals(val)) {
            return defaultVal;
        }
        return val;
    }
}

