/*
 * Decompiled with CFR 0.152.
 */
package com.oopsguy.kaptcha.autoconfigure;

import com.google.code.kaptcha.servlet.KaptchaServlet;
import com.oopsguy.kaptcha.autoconfigure.KaptchaProperties;
import com.oopsguy.kaptcha.autoconfigure.util.ConfigUtils;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Resource;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.util.StringUtils;

public class ServletRegisterInitializer
implements ServletContextInitializer {
    private static final String KAPTCHA_SERVLET_BEAN_NAME_SUBFFIX = "KapthcaServlet";
    @Resource
    private KaptchaProperties kaptchaProperties;
    @Resource(name="kaptchaProps")
    private Properties kaptchaProps;

    public void onStartup(ServletContext servletContext) throws ServletException {
        Map<String, KaptchaProperties.SingleKaptchaProperties> items = this.kaptchaProperties.getItems();
        if (items == null || items.isEmpty()) {
            return;
        }
        for (Map.Entry<String, KaptchaProperties.SingleKaptchaProperties> entry : items.entrySet()) {
            KaptchaProperties.SingleKaptchaProperties props = entry.getValue();
            if (StringUtils.isEmpty((Object)props.getPath())) {
                return;
            }
            ServletRegistration.Dynamic serviceServlet = servletContext.addServlet(entry.getKey() + KAPTCHA_SERVLET_BEAN_NAME_SUBFFIX, (Servlet)new KaptchaServlet());
            serviceServlet.addMapping(new String[]{props.getPath()});
            serviceServlet.setAsyncSupported(true);
            Properties subProps = ConfigUtils.kaptchaSubPropertiesToProperties(entry.getKey(), props);
            for (Map.Entry<Object, Object> en : this.kaptchaProps.entrySet()) {
                boolean isSkip;
                boolean bl = isSkip = subProps.containsKey(en.getKey()) && !StringUtils.isEmpty((Object)String.valueOf(subProps.get(en.getKey()))) || StringUtils.isEmpty((Object)en.getValue());
                if (isSkip) continue;
                subProps.setProperty(String.valueOf(en.getKey()), String.valueOf(en.getValue()));
            }
            for (Map.Entry<Object, Object> en : subProps.entrySet()) {
                serviceServlet.setInitParameter(String.valueOf(en.getKey()), String.valueOf(en.getValue()));
            }
        }
    }
}

