/*
 * Decompiled with CFR 0.152.
 */
package com.oopsguy.kaptcha.autoconfigure;

import com.google.code.kaptcha.Producer;
import com.google.code.kaptcha.impl.DefaultKaptcha;
import com.google.code.kaptcha.util.Config;
import com.oopsguy.kaptcha.autoconfigure.KaptchaProperties;
import com.oopsguy.kaptcha.autoconfigure.ServletRegisterInitializer;
import com.oopsguy.kaptcha.autoconfigure.util.ConfigUtils;
import java.util.Properties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@Configuration
@EnableConfigurationProperties(value={KaptchaProperties.class})
public class KaptchaAutoConfigure {
    @Bean(name={"kaptchaProps"})
    protected Properties kaptchaProps(KaptchaProperties kaptchaProperties) {
        return ConfigUtils.kaptchaPropertiesToProperties(kaptchaProperties);
    }

    @Bean
    @ConditionalOnMissingBean(value={Producer.class})
    @DependsOn(value={"kaptchaProps"})
    public Producer defaultKaptcha(Properties kaptchaProps) {
        DefaultKaptcha defaultKaptcha = new DefaultKaptcha();
        Config config = new Config(kaptchaProps);
        defaultKaptcha.setConfig(config);
        return defaultKaptcha;
    }

    @Bean
    @DependsOn(value={"kaptchaProps"})
    public ServletContextInitializer webConfig() {
        return new ServletRegisterInitializer();
    }
}

