/*
 * Decompiled with CFR 0.152.
 */
package com.onlyoffice.service.settings;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.onlyoffice.manager.request.RequestManager;
import com.onlyoffice.manager.settings.SettingsManager;
import com.onlyoffice.manager.url.UrlManager;
import com.onlyoffice.model.commandservice.CommandRequest;
import com.onlyoffice.model.commandservice.CommandResponse;
import com.onlyoffice.model.commandservice.commandrequest.Command;
import com.onlyoffice.model.common.CommonResponse;
import com.onlyoffice.model.convertservice.ConvertRequest;
import com.onlyoffice.model.convertservice.ConvertResponse;
import com.onlyoffice.model.settings.HttpClientSettings;
import com.onlyoffice.model.settings.security.Security;
import com.onlyoffice.model.settings.validation.ValidationResult;
import com.onlyoffice.model.settings.validation.status.Status;
import com.onlyoffice.service.settings.SettingsValidationService;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.json.JSONObject;

public class DefaultSettingsValidationService
implements SettingsValidationService {
    private RequestManager requestManager;
    private UrlManager urlManager;
    private SettingsManager settingsManager;
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public ValidationResult checkDocumentServer() throws Exception {
        HttpClientSettings httpClientSettings = HttpClientSettings.builder().ignoreSSLCertificate(this.settingsManager.isIgnoreSSLCertificate()).build();
        return this.checkDocumentServer(this.urlManager.getInnerDocumentServerUrl(), httpClientSettings);
    }

    @Override
    public ValidationResult checkDocumentServer(String url, HttpClientSettings httpClientSettings) throws Exception {
        String healthCheckUrl = this.settingsManager.getDocsIntegrationSdkProperties().getDocumentServer().getHealthCheckUrl();
        healthCheckUrl = this.urlManager.sanitizeUrl(url) + healthCheckUrl;
        return this.requestManager.executeGetRequest(healthCheckUrl, httpClientSettings, new RequestManager.Callback<ValidationResult>(){

            @Override
            public ValidationResult doWork(Object response) throws IOException {
                String content = IOUtils.toString((InputStream)((HttpEntity)response).getContent(), (String)"utf-8").trim();
                if (content.equalsIgnoreCase("true")) {
                    return ValidationResult.builder().status(Status.SUCCESS).build();
                }
                return ValidationResult.builder().status(Status.FAILED).error(CommonResponse.Error.HEALTHCHECK).build();
            }
        });
    }

    @Override
    public ValidationResult checkCommandService() throws Exception {
        String url = this.urlManager.getInnerDocumentServerUrl();
        Security security = Security.builder().key(this.settingsManager.getSecurityKey()).header(this.settingsManager.getSecurityHeader()).prefix(this.settingsManager.getSecurityPrefix()).build();
        HttpClientSettings httpClientSettings = HttpClientSettings.builder().ignoreSSLCertificate(this.settingsManager.isIgnoreSSLCertificate()).build();
        return this.checkCommandService(url, security, httpClientSettings);
    }

    @Override
    public ValidationResult checkCommandService(String url, Security security, HttpClientSettings httpClientSettings) throws Exception {
        String commandServiceUrl = this.settingsManager.getDocsIntegrationSdkProperties().getDocumentServer().getCommandService().getUrl();
        CommandRequest commandRequest = CommandRequest.builder().c(Command.VERSION).build();
        return this.requestManager.executePostRequest(this.urlManager.sanitizeUrl(url) + commandServiceUrl, commandRequest, security, httpClientSettings, new RequestManager.Callback<ValidationResult>(){

            @Override
            public ValidationResult doWork(Object response) throws IOException {
                String content = IOUtils.toString((InputStream)((HttpEntity)response).getContent(), (String)"utf-8");
                CommandResponse commandResponse = (CommandResponse)DefaultSettingsValidationService.this.objectMapper.readValue(content, CommandResponse.class);
                if (commandResponse.getError() != null && commandResponse.getError().equals(CommandResponse.Error.NO)) {
                    return ValidationResult.builder().status(Status.SUCCESS).build();
                }
                return ValidationResult.builder().status(Status.FAILED).error(commandResponse.getError()).build();
            }
        });
    }

    @Override
    public ValidationResult checkConvertService() throws Exception {
        String url = this.urlManager.getInnerDocumentServerUrl();
        Security security = Security.builder().key(this.settingsManager.getSecurityKey()).header(this.settingsManager.getSecurityHeader()).prefix(this.settingsManager.getSecurityPrefix()).build();
        HttpClientSettings httpClientSettings = HttpClientSettings.builder().ignoreSSLCertificate(this.settingsManager.isIgnoreSSLCertificate()).build();
        return this.checkConvertService(url, null, security, httpClientSettings);
    }

    @Override
    public ValidationResult checkConvertService(String url, String productInnerUrl, Security security, final HttpClientSettings httpClientSettings) throws Exception {
        String convertServiceUrl = this.settingsManager.getDocsIntegrationSdkProperties().getDocumentServer().getConvertService().getUrl();
        ConvertRequest convertRequest = ConvertRequest.builder().async(false).filetype("txt").outputtype("docx").key(new SimpleDateFormat("MMddyyyyHHmmss").format(new Date())).url(this.urlManager.getTestConvertUrl(productInnerUrl)).build();
        return this.requestManager.executePostRequest(this.urlManager.sanitizeUrl(url) + convertServiceUrl, convertRequest, security, httpClientSettings, new RequestManager.Callback<ValidationResult>(){

            @Override
            public ValidationResult doWork(Object response) throws Exception {
                String content = IOUtils.toString((InputStream)((HttpEntity)response).getContent(), (String)"utf-8").trim();
                JSONObject result = new JSONObject(content);
                if (result.has("error")) {
                    Integer errorCode = result.getInt("error");
                    return ValidationResult.builder().status(Status.FAILED).error(ConvertResponse.Error.valueOfCode(errorCode)).build();
                }
                String fileUrl = result.getString("fileUrl");
                return DefaultSettingsValidationService.this.requestManager.executeGetRequest(fileUrl, httpClientSettings, new RequestManager.Callback<ValidationResult>(){

                    @Override
                    public ValidationResult doWork(Object response) throws IOException {
                        byte[] bytes = EntityUtils.toByteArray((HttpEntity)((HttpEntity)response));
                        if (bytes.length > 0) {
                            return ValidationResult.builder().status(Status.SUCCESS).build();
                        }
                        return ValidationResult.builder().status(Status.FAILED).error(CommonResponse.Error.DOWNLOAD_RESULT).build();
                    }
                });
            }
        });
    }

    @Generated
    public DefaultSettingsValidationService(RequestManager requestManager, UrlManager urlManager, SettingsManager settingsManager) {
        this.requestManager = requestManager;
        this.urlManager = urlManager;
        this.settingsManager = settingsManager;
    }

    @Generated
    protected RequestManager getRequestManager() {
        return this.requestManager;
    }

    @Generated
    protected void setRequestManager(RequestManager requestManager) {
        this.requestManager = requestManager;
    }

    @Generated
    protected UrlManager getUrlManager() {
        return this.urlManager;
    }

    @Generated
    protected void setUrlManager(UrlManager urlManager) {
        this.urlManager = urlManager;
    }

    @Generated
    protected SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    @Generated
    protected void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }
}

