/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.failover.BlackList.append;

import com.oceanbase.jdbc.HostAddress;
import com.oceanbase.jdbc.internal.failover.BlackList.append.AppendStrategy;
import com.oceanbase.jdbc.internal.logging.Logger;
import com.oceanbase.jdbc.internal.logging.LoggerFactory;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class RetryDuration
implements AppendStrategy {
    private static final Logger logger = LoggerFactory.getLogger(RetryDuration.class);
    private long durationMs;
    private int retryTimes;
    private static long maxDurationMs;
    private static ConcurrentMap<HostAddress, HashSet<Long>> failureRecords;

    public RetryDuration(long durationMs, int retryTimes) {
        this.durationMs = durationMs;
        this.retryTimes = retryTimes;
    }

    public String toString() {
        return "RetryDuration{}";
    }

    @Override
    public String toJson() {
        return "\"APPEND_STRATEGY\":{\"NAME\":\"RETRYDURATION\",\"RETRYTIMES\":" + this.retryTimes + ",\"DURATION\":" + this.durationMs + "}";
    }

    public long getDuration() {
        return this.durationMs;
    }

    public int getRetryTimes() {
        return this.retryTimes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean needToAppend(HostAddress host, Properties properties) {
        boolean need = false;
        HostAddress hostAddress = host;
        synchronized (hostAddress) {
            Set recentFailedTimeList;
            Set history = failureRecords.putIfAbsent(host, new HashSet());
            if (history == null) {
                logger.warn("failureRecords add {}", (Object)host.host);
            }
            int count = 0;
            Set set = recentFailedTimeList = (Set)failureRecords.get(host);
            synchronized (set) {
                long failedTimeMs = Long.parseLong((String)properties.get("failedTime"));
                logger.debug("{} --> {}", (Object)host.host, (Object)recentFailedTimeList);
                logger.debug("{} add {}", (Object)host.host, (Object)failedTimeMs);
                recentFailedTimeList.add(failedTimeMs);
                logger.debug("{} --> {}", (Object)host.host, failureRecords.get(host));
                Iterator longIterator = recentFailedTimeList.iterator();
                while (longIterator.hasNext()) {
                    long ts = (Long)longIterator.next();
                    if (failedTimeMs - ts > maxDurationMs) {
                        logger.debug("{} --> {}", (Object)host.host, (Object)recentFailedTimeList);
                        logger.debug("{} remove {}", (Object)host.host, (Object)ts);
                        longIterator.remove();
                        logger.debug("{} --> {}", (Object)host.host, failureRecords.get(host));
                        continue;
                    }
                    if (failedTimeMs - ts > this.durationMs) continue;
                    ++count;
                }
            }
            boolean bl = need = count >= this.retryTimes;
            if (need) {
                logger.warn("failureRecords remove {}", (Object)host.host);
                RetryDuration.removeFromFailureRecords(host);
            }
        }
        return need;
    }

    public static void removeFromFailureRecords(HostAddress host) {
        if (host != null) {
            failureRecords.remove(host);
        }
    }

    public static void updateMaxDuration(long newDuration) {
        maxDurationMs = Math.max(newDuration, maxDurationMs);
    }

    static {
        failureRecords = new ConcurrentHashMap<HostAddress, HashSet<Long>>();
    }
}

