/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.com.send.parameters;

import com.oceanbase.jdbc.Blob;
import com.oceanbase.jdbc.internal.ColumnType;
import com.oceanbase.jdbc.internal.com.send.parameters.LongDataParameterHolder;
import com.oceanbase.jdbc.internal.io.output.PacketOutputStream;
import com.oceanbase.jdbc.internal.util.Utils;
import com.oceanbase.jdbc.util.Options;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class OBStreamParameter
implements Cloneable,
LongDataParameterHolder {
    private final Blob blob;
    private final boolean hasLobLocator;
    private final byte[] lobLocatorBinary;
    private InputStream is;
    private long length;
    private final boolean noBackslashEscapes;

    public OBStreamParameter(InputStream is, long length, boolean noBackslashEscapes) {
        this.blob = null;
        this.hasLobLocator = false;
        this.lobLocatorBinary = null;
        this.is = is;
        this.length = length;
        this.noBackslashEscapes = noBackslashEscapes;
    }

    public OBStreamParameter(InputStream is, boolean noBackSlashEscapes) {
        this(is, Long.MAX_VALUE, noBackSlashEscapes);
    }

    public OBStreamParameter(byte[] lobLocatorBinary, boolean noBackslashEscapes) {
        this.blob = null;
        this.hasLobLocator = true;
        this.lobLocatorBinary = lobLocatorBinary;
        this.is = null;
        this.length = 0L;
        this.noBackslashEscapes = noBackslashEscapes;
    }

    public OBStreamParameter(Blob blob, boolean noBackslashEscapes) {
        this.blob = blob;
        this.hasLobLocator = false;
        this.lobLocatorBinary = null;
        this.is = null;
        this.length = 0L;
        this.noBackslashEscapes = noBackslashEscapes;
    }

    private void setInputStream() throws IOException {
        if (this.blob != null) {
            try {
                this.is = this.blob.getBinaryStream();
                this.length = this.blob.length();
            }
            catch (SQLException throwables) {
                IOException ioException = new IOException();
                ioException.initCause(throwables);
                throw ioException;
            }
        }
    }

    @Override
    public void writeTo(PacketOutputStream pos) throws IOException {
        this.setInputStream();
        if (this.is != null) {
            pos.write(39);
            if (this.length == Long.MAX_VALUE) {
                pos.writeHex(this.is, false, this.noBackslashEscapes);
            } else {
                pos.writeHex(this.is, this.length, false, this.noBackslashEscapes);
            }
            pos.write(39);
        }
    }

    @Override
    public int getApproximateTextProtocolLength() {
        return -1;
    }

    @Override
    public void writeBinary(PacketOutputStream pos) throws IOException {
        this.setInputStream();
        if (this.hasLobLocator && this.lobLocatorBinary != null) {
            pos.writeFieldLength(this.lobLocatorBinary.length);
            pos.write(this.lobLocatorBinary);
        } else if (this.is != null) {
            if (this.length == Long.MAX_VALUE) {
                pos.write(this.is, false, this.noBackslashEscapes);
            } else {
                pos.write(this.is, this.length, false, this.noBackslashEscapes);
            }
        }
    }

    @Override
    public String toString() {
        return "<Stream>";
    }

    @Override
    public ColumnType getColumnType() {
        return this.hasLobLocator ? ColumnType.ORA_BLOB : ColumnType.STRING;
    }

    @Override
    public boolean isNullData() {
        return false;
    }

    @Override
    public boolean isLongData() {
        return !this.hasLobLocator;
    }

    @Override
    public boolean writePieceData(PacketOutputStream writer, boolean first, Options options) throws IOException {
        int piece;
        if (first) {
            this.setInputStream();
        }
        int pieceLen = options.pieceLength;
        byte[] buffer = new byte[pieceLen];
        int len = this.is.read(buffer);
        boolean ret = false;
        if (len < 0) {
            writer.write(3);
            writer.write(0);
            writer.writeLong(0L);
            writer.flush();
            return false;
        }
        byte[] data = new byte[len];
        System.arraycopy(buffer, 0, data, 0, len);
        data = Utils.toHexString(data).getBytes();
        int lastLen = this.is.available();
        if (first && lastLen != 0) {
            piece = 1;
            ret = true;
        } else if (first && lastLen == 0) {
            piece = 3;
            ret = false;
        } else if (!first && lastLen != 0) {
            piece = 2;
            ret = true;
        } else {
            piece = 3;
            ret = false;
        }
        writer.write(piece);
        writer.write(0);
        writer.writeLong(data.length);
        writer.write(data);
        writer.flush();
        return ret;
    }

    @Override
    public boolean writeLongData(PacketOutputStream pos, Options options, int statementId, short paramIndex) throws IOException {
        return false;
    }
}

