/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jwt.proc;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.factories.DefaultJWEDecrypterFactory;
import com.nimbusds.jose.crypto.factories.DefaultJWSVerifierFactory;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.proc.BadJWEException;
import com.nimbusds.jose.proc.BadJWSException;
import com.nimbusds.jose.proc.JWEDecrypterFactory;
import com.nimbusds.jose.proc.JWEKeySelector;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerifierFactory;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.jwt.proc.BadJWTException;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import com.nimbusds.jwt.proc.JWTClaimsVerifier;
import java.security.Key;
import java.text.ParseException;
import java.util.List;
import java.util.ListIterator;

public class DefaultJWTProcessor<C extends SecurityContext>
implements ConfigurableJWTProcessor<C> {
    private static final BadJOSEException PLAIN_JWT_REJECTED_EXCEPTION = new BadJOSEException("Unsecured (plain) JWTs are rejected, extend class to handle");
    private static final BadJOSEException NO_JWS_KEY_SELECTOR_EXCEPTION = new BadJOSEException("Signed JWT rejected: No JWS key selector is configured");
    private static final BadJOSEException NO_JWE_KEY_SELECTOR_EXCEPTION = new BadJOSEException("Encrypted JWT rejected: No JWE key selector is configured");
    private static final JOSEException NO_JWS_VERIFIER_FACTORY_EXCEPTION = new JOSEException("No JWS verifier is configured");
    private static final JOSEException NO_JWE_DECRYPTER_FACTORY_EXCEPTION = new JOSEException("No JWE decrypter is configured");
    private static final BadJOSEException NO_JWS_KEY_CANDIDATES_EXCEPTION = new BadJOSEException("Signed JWT rejected: No matching key(s) found");
    private static final BadJOSEException NO_JWE_KEY_CANDIDATES_EXCEPTION = new BadJOSEException("Encrypted JWT rejected: No matching key(s) found");
    private static final BadJOSEException INVALID_SIGNATURE = new BadJWSException("Signed JWT rejected: Invalid signature");
    private static final BadJWTException INVALID_NESTED_JWT_EXCEPTION = new BadJWTException("The payload is not a nested JWT");
    private static final BadJOSEException NO_MATCHING_VERIFIERS_EXCEPTION = new BadJOSEException("JWS object rejected: No matching verifier(s) found");
    private static final BadJOSEException NO_MATCHING_DECRYPTERS_EXCEPTION = new BadJOSEException("Encrypted JWT rejected: No matching decrypter(s) found");
    private JWSKeySelector<C> jwsKeySelector;
    private JWEKeySelector<C> jweKeySelector;
    private JWSVerifierFactory jwsVerifierFactory = new DefaultJWSVerifierFactory();
    private JWEDecrypterFactory jweDecrypterFactory = new DefaultJWEDecrypterFactory();
    private JWTClaimsVerifier claimsVerifier = new DefaultJWTClaimsVerifier();

    @Override
    public JWSKeySelector<C> getJWSKeySelector() {
        return this.jwsKeySelector;
    }

    @Override
    public void setJWSKeySelector(JWSKeySelector<C> jwsKeySelector) {
        this.jwsKeySelector = jwsKeySelector;
    }

    @Override
    public JWEKeySelector<C> getJWEKeySelector() {
        return this.jweKeySelector;
    }

    @Override
    public void setJWEKeySelector(JWEKeySelector<C> jweKeySelector) {
        this.jweKeySelector = jweKeySelector;
    }

    @Override
    public JWSVerifierFactory getJWSVerifierFactory() {
        return this.jwsVerifierFactory;
    }

    @Override
    public void setJWSVerifierFactory(JWSVerifierFactory factory) {
        this.jwsVerifierFactory = factory;
    }

    @Override
    public JWEDecrypterFactory getJWEDecrypterFactory() {
        return this.jweDecrypterFactory;
    }

    @Override
    public void setJWEDecrypterFactory(JWEDecrypterFactory factory) {
        this.jweDecrypterFactory = factory;
    }

    @Override
    public JWTClaimsVerifier getJWTClaimsVerifier() {
        return this.claimsVerifier;
    }

    @Override
    public void setJWTClaimsVerifier(JWTClaimsVerifier claimsVerifier) {
        this.claimsVerifier = claimsVerifier;
    }

    private JWTClaimsSet verifyAndReturnClaims(JWT jwt) throws BadJWTException {
        JWTClaimsSet claimsSet;
        try {
            claimsSet = jwt.getJWTClaimsSet();
        }
        catch (ParseException e) {
            throw new BadJWTException(e.getMessage(), e);
        }
        if (this.getJWTClaimsVerifier() != null) {
            this.getJWTClaimsVerifier().verify(claimsSet);
        }
        return claimsSet;
    }

    @Override
    public JWTClaimsSet process(String jwtString, C context) throws ParseException, BadJOSEException, JOSEException {
        return this.process(JWTParser.parse(jwtString), context);
    }

    @Override
    public JWTClaimsSet process(JWT jwt, C context) throws BadJOSEException, JOSEException {
        if (jwt instanceof SignedJWT) {
            return this.process((SignedJWT)jwt, context);
        }
        if (jwt instanceof EncryptedJWT) {
            return this.process((EncryptedJWT)jwt, context);
        }
        if (jwt instanceof PlainJWT) {
            return this.process((PlainJWT)jwt, context);
        }
        throw new JOSEException("Unexpected JWT object type: " + jwt.getClass());
    }

    @Override
    public JWTClaimsSet process(PlainJWT plainJWT, C context) throws BadJOSEException, JOSEException {
        this.verifyAndReturnClaims(plainJWT);
        throw PLAIN_JWT_REJECTED_EXCEPTION;
    }

    @Override
    public JWTClaimsSet process(SignedJWT signedJWT, C context) throws BadJOSEException, JOSEException {
        if (this.getJWSKeySelector() == null) {
            throw NO_JWS_KEY_SELECTOR_EXCEPTION;
        }
        if (this.getJWSVerifierFactory() == null) {
            throw NO_JWS_VERIFIER_FACTORY_EXCEPTION;
        }
        List<Key> keyCandidates = this.getJWSKeySelector().selectJWSKeys((JWSHeader)signedJWT.getHeader(), context);
        if (keyCandidates == null || keyCandidates.isEmpty()) {
            throw NO_JWS_KEY_CANDIDATES_EXCEPTION;
        }
        ListIterator<Key> it = keyCandidates.listIterator();
        while (it.hasNext()) {
            JWSVerifier verifier = this.getJWSVerifierFactory().createJWSVerifier((JWSHeader)signedJWT.getHeader(), it.next());
            if (verifier == null) continue;
            boolean validSignature = signedJWT.verify(verifier);
            if (validSignature) {
                return this.verifyAndReturnClaims(signedJWT);
            }
            if (it.hasNext()) continue;
            throw INVALID_SIGNATURE;
        }
        throw NO_MATCHING_VERIFIERS_EXCEPTION;
    }

    @Override
    public JWTClaimsSet process(EncryptedJWT encryptedJWT, C context) throws BadJOSEException, JOSEException {
        if (this.getJWEKeySelector() == null) {
            throw NO_JWE_KEY_SELECTOR_EXCEPTION;
        }
        if (this.getJWEDecrypterFactory() == null) {
            throw NO_JWE_DECRYPTER_FACTORY_EXCEPTION;
        }
        List<Key> keyCandidates = this.getJWEKeySelector().selectJWEKeys((JWEHeader)encryptedJWT.getHeader(), context);
        if (keyCandidates == null || keyCandidates.isEmpty()) {
            throw NO_JWE_KEY_CANDIDATES_EXCEPTION;
        }
        ListIterator<Key> it = keyCandidates.listIterator();
        while (it.hasNext()) {
            JWEDecrypter decrypter = this.getJWEDecrypterFactory().createJWEDecrypter((JWEHeader)encryptedJWT.getHeader(), it.next());
            if (decrypter == null) continue;
            try {
                encryptedJWT.decrypt(decrypter);
            }
            catch (JOSEException e) {
                if (it.hasNext()) continue;
                throw new BadJWEException("Encrypted JWT rejected: " + e.getMessage(), e);
            }
            if ("JWT".equalsIgnoreCase(encryptedJWT.getHeader().getContentType())) {
                SignedJWT nestedJWT = encryptedJWT.getPayload().toSignedJWT();
                if (nestedJWT == null) {
                    throw INVALID_NESTED_JWT_EXCEPTION;
                }
                return this.process(nestedJWT, context);
            }
            return this.verifyAndReturnClaims(encryptedJWT);
        }
        throw NO_MATCHING_DECRYPTERS_EXCEPTION;
    }
}

