/*
 * Decompiled with CFR 0.152.
 */
package com.neovisionaries.security;

import java.io.UnsupportedEncodingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

class Utils {
    private Utils() {
    }

    public static byte[] getBytesUTF8(String string) {
        if (string == null) {
            return null;
        }
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String toStringUTF8(byte[] input) {
        if (input == null) {
            return null;
        }
        try {
            return new String(input, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static byte[] ensureSize(byte[] data, int size) {
        if (data == null) {
            return new byte[size];
        }
        if (size <= data.length) {
            return data;
        }
        byte[] data2 = new byte[size];
        System.arraycopy(data, 0, data2, 0, data.length);
        return data2;
    }

    public static SecretKeySpec createSecretKeySpec(String key, String algorithm, int size) {
        return Utils.createSecretKeySpec(Utils.getBytesUTF8(key), algorithm, size);
    }

    public static SecretKeySpec createSecretKeySpec(byte[] key, String algorithm, int size) {
        key = Utils.ensureSize(key, size);
        return new SecretKeySpec(key, 0, size, algorithm);
    }

    public static IvParameterSpec createIvParameterSpec(String iv, int size) {
        return Utils.createIvParameterSpec(Utils.getBytesUTF8(iv), size);
    }

    public static IvParameterSpec createIvParameterSpec(byte[] iv, int size) {
        iv = Utils.ensureSize(iv, size);
        return new IvParameterSpec(iv, 0, size);
    }
}

