/*
 * Decompiled with CFR 0.152.
 */
package com.neovisionaries.security;

import com.neovisionaries.security.Utils;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import org.apache.commons.codec.BinaryDecoder;
import org.apache.commons.codec.BinaryEncoder;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.binary.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodecCipher {
    private static final Base64 DEFAULT_CODER = new Base64();
    private Cipher cipher;
    private BinaryEncoder encoder;
    private BinaryDecoder decoder;
    private Key key;
    private AlgorithmParameters params;
    private AlgorithmParameterSpec spec;
    private Certificate certificate;
    private SecureRandom random;

    public CodecCipher() {
    }

    public CodecCipher(Cipher cipher, BinaryEncoder encoder, BinaryDecoder decoder) {
        this.cipher = cipher;
        this.encoder = encoder;
        this.decoder = decoder;
    }

    public <TCoder extends BinaryEncoder & BinaryDecoder> CodecCipher(Cipher cipher, TCoder coder) {
        this(cipher, coder, (BinaryDecoder)coder);
    }

    public CodecCipher(Cipher cipher) {
        this(cipher, (BinaryEncoder)null, (BinaryDecoder)null);
    }

    public CodecCipher(String transformation, BinaryEncoder encoder, BinaryDecoder decoder) throws IllegalArgumentException {
        this(CodecCipher.getCipherInstance(transformation), encoder, decoder);
    }

    public <TCoder extends BinaryEncoder & BinaryDecoder> CodecCipher(String transformation, TCoder coder) throws IllegalArgumentException {
        this(transformation, coder, (BinaryDecoder)coder);
    }

    public <TCoder extends BinaryEncoder & BinaryDecoder> CodecCipher(String transformation) throws IllegalArgumentException {
        this(transformation, (BinaryEncoder)null, (BinaryDecoder)null);
    }

    public CodecCipher(String transformation, String provider, BinaryEncoder encoder, BinaryDecoder decoder) throws IllegalArgumentException {
        this(CodecCipher.getCipherInstance(transformation, provider), encoder, decoder);
    }

    public <TCoder extends BinaryEncoder & BinaryDecoder> CodecCipher(String transformation, String provider, TCoder coder) throws IllegalArgumentException {
        this(transformation, provider, coder, (BinaryDecoder)coder);
    }

    public CodecCipher(String transformation, String provider) throws IllegalArgumentException {
        this(transformation, provider, (BinaryEncoder)null, (BinaryDecoder)null);
    }

    public CodecCipher(String transformation, Provider provider, BinaryEncoder encoder, BinaryDecoder decoder) throws IllegalArgumentException {
        this(CodecCipher.getCipherInstance(transformation, provider), encoder, decoder);
    }

    public <TCoder extends BinaryEncoder & BinaryDecoder> CodecCipher(String transformation, Provider provider, TCoder coder) throws IllegalArgumentException {
        this(transformation, provider, coder, (BinaryDecoder)coder);
    }

    public CodecCipher(String transformation, Provider provider) throws IllegalArgumentException {
        this(transformation, provider, (BinaryEncoder)null, (BinaryDecoder)null);
    }

    private static Cipher getCipherInstance(String transformation) throws IllegalArgumentException {
        try {
            return Cipher.getInstance(transformation);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static Cipher getCipherInstance(String transformation, String provider) {
        try {
            return Cipher.getInstance(transformation, provider);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static Cipher getCipherInstance(String transformation, Provider provider) {
        try {
            return Cipher.getInstance(transformation, provider);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Cipher getCipher() {
        return this.cipher;
    }

    public CodecCipher setCipher(Cipher cipher) {
        if (cipher == null) {
            throw new IllegalArgumentException("cipher is null.");
        }
        this.cipher = cipher;
        return this;
    }

    public String getAlgorithm() {
        if (this.cipher == null) {
            return null;
        }
        String transformation = this.cipher.getAlgorithm();
        if (transformation == null) {
            return null;
        }
        int pos = transformation.indexOf(47);
        if (pos < 0) {
            return transformation;
        }
        return transformation.substring(0, pos);
    }

    public BinaryEncoder getEncoder() {
        return this.encoder;
    }

    public CodecCipher setEncoder(BinaryEncoder encoder) {
        this.encoder = encoder;
        return this;
    }

    public BinaryDecoder getDecoder() {
        return this.decoder;
    }

    public CodecCipher setDecoder(BinaryDecoder decoder) {
        this.decoder = decoder;
        return this;
    }

    public <TCoder extends BinaryEncoder & BinaryDecoder> CodecCipher setCoder(TCoder coder) {
        this.encoder = coder;
        this.decoder = coder;
        return this;
    }

    public CodecCipher setInit(Key key) throws IllegalArgumentException {
        return this.setInit(key, null, null, null);
    }

    public CodecCipher setInit(Key key, SecureRandom random) throws IllegalArgumentException {
        return this.setInit(key, null, null, random);
    }

    public CodecCipher setInit(Key key, AlgorithmParameters params) throws IllegalArgumentException {
        return this.setInit(key, params, null, null);
    }

    public CodecCipher setInit(Key key, AlgorithmParameters params, SecureRandom random) throws IllegalArgumentException {
        return this.setInit(key, params, null, random);
    }

    public CodecCipher setInit(Key key, AlgorithmParameterSpec spec) throws IllegalArgumentException {
        return this.setInit(key, null, spec, null);
    }

    public CodecCipher setInit(Key key, AlgorithmParameterSpec spec, SecureRandom random) throws IllegalArgumentException {
        return this.setInit(key, null, spec, random);
    }

    public CodecCipher setInit(Certificate certificate) throws IllegalArgumentException {
        return this.setInit(certificate, null);
    }

    public CodecCipher setInit(Certificate certificate, SecureRandom random) throws IllegalArgumentException {
        if (certificate == null) {
            throw new IllegalArgumentException("certificate is null.");
        }
        return this.setInit(null, null, null, certificate, random);
    }

    private CodecCipher setInit(Key key, AlgorithmParameters params, AlgorithmParameterSpec spec, SecureRandom random) {
        if (key == null) {
            throw new IllegalArgumentException("key is null.");
        }
        return this.setInit(key, params, spec, null, random);
    }

    private CodecCipher setInit(Key key, AlgorithmParameters params, AlgorithmParameterSpec spec, Certificate certificate, SecureRandom random) {
        this.key = key;
        this.params = params;
        this.spec = spec;
        this.certificate = certificate;
        this.random = random;
        return this;
    }

    public String encrypt(String input) throws IllegalStateException {
        return this.cipher(input, 1);
    }

    public String decrypt(String input) throws IllegalStateException {
        return this.cipher(input, 2);
    }

    public byte[] encrypt(byte[] input) throws IllegalStateException {
        return this.cipher(input, 1);
    }

    public byte[] decrypt(byte[] input) throws IllegalStateException {
        return this.cipher(input, 2);
    }

    private String cipher(String input, int mode) {
        if (input == null) {
            return null;
        }
        byte[] inputBytes = Utils.getBytesUTF8(input);
        byte[] outputBytes = this.cipher(inputBytes, mode);
        return Utils.toStringUTF8(outputBytes);
    }

    private byte[] cipher(byte[] input, int mode) {
        try {
            return this.doCipher(input, mode);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private byte[] doCipher(byte[] input, int mode) throws DecoderException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, EncoderException {
        if (input == null) {
            return null;
        }
        if (this.cipher == null) {
            throw new IllegalStateException("setCipher() has not been called.");
        }
        if (this.key == null && this.certificate == null) {
            throw new IllegalStateException("setInit() has not been called.");
        }
        if (mode == 2) {
            input = this.decode(input);
        }
        this.initCipher(mode);
        byte[] output = this.cipher.doFinal(input);
        if (mode == 1) {
            output = this.encode(output);
        }
        return output;
    }

    private void initCipher(int mode) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (this.key != null) {
            if (this.params != null) {
                if (this.random != null) {
                    this.cipher.init(mode, this.key, this.params, this.random);
                } else {
                    this.cipher.init(mode, this.key, this.params);
                }
            } else if (this.spec != null) {
                if (this.random != null) {
                    this.cipher.init(mode, this.key, this.spec, this.random);
                } else {
                    this.cipher.init(mode, this.key, this.spec);
                }
            } else if (this.random != null) {
                this.cipher.init(mode, this.key, this.random);
            } else {
                this.cipher.init(mode, this.key);
            }
        } else if (this.random != null) {
            this.cipher.init(mode, this.certificate, this.random);
        } else {
            this.cipher.init(mode, this.certificate);
        }
    }

    private byte[] encode(byte[] input) throws EncoderException {
        if (this.encoder != null) {
            return this.encoder.encode(input);
        }
        return DEFAULT_CODER.encode(input);
    }

    private byte[] decode(byte[] input) throws DecoderException {
        if (this.decoder != null) {
            return this.decoder.decode(input);
        }
        return DEFAULT_CODER.decode(input);
    }
}

