/*
 * Decompiled with CFR 0.152.
 */
package com.neovisionaries.security;

import com.neovisionaries.security.CodecCipher;
import com.neovisionaries.security.Utils;
import java.security.Key;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.BinaryDecoder;
import org.apache.commons.codec.BinaryEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AESCipher
extends CodecCipher {
    private static final String TRANSFORMATION = "AES/CBC/PKCS5Padding";

    public AESCipher() {
        super(TRANSFORMATION);
    }

    public AESCipher(String transformation) {
        super(transformation);
    }

    public AESCipher(BinaryEncoder encoder, BinaryDecoder decoder) {
        super(TRANSFORMATION, encoder, decoder);
    }

    public AESCipher(String transformation, BinaryEncoder encoder, BinaryDecoder decoder) {
        super(transformation, encoder, decoder);
    }

    public <TCoder extends BinaryEncoder & BinaryDecoder> AESCipher(TCoder coder) {
        super(TRANSFORMATION, coder);
    }

    public <TCoder extends BinaryEncoder & BinaryDecoder> AESCipher(String transformation, TCoder coder) {
        super(transformation, coder);
    }

    public AESCipher setKey(SecretKey key, IvParameterSpec iv) {
        return (AESCipher)this.setInit((Key)key, iv);
    }

    public AESCipher setKey(byte[] key, byte[] iv) {
        SecretKeySpec secretKey = Utils.createSecretKeySpec(key, this.getAlgorithm(), 16);
        IvParameterSpec spec = null;
        if (iv != null) {
            spec = Utils.createIvParameterSpec(iv, 16);
        }
        return this.setKey(secretKey, spec);
    }

    public AESCipher setKey(String key, byte[] iv) {
        byte[] key2 = Utils.getBytesUTF8(key);
        return this.setKey(key2, iv);
    }

    public AESCipher setKey(String key, String iv) {
        byte[] key2 = Utils.getBytesUTF8(key);
        byte[] iv2 = Utils.getBytesUTF8(iv);
        return this.setKey(key2, iv2);
    }

    public AESCipher setKey(String key) {
        return this.setKey(key, (byte[])null);
    }

    public AESCipher setKey(byte[] key, String iv) {
        byte[] iv2 = Utils.getBytesUTF8(iv);
        return this.setKey(key, iv2);
    }

    public AESCipher setKey(byte[] key) {
        return this.setKey(key, (byte[])null);
    }
}

