/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa.sql;

import com.mysema.commons.lang.CloseableIterator;
import com.mysema.commons.lang.IteratorAdapter;
import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.NonUniqueResultException;
import com.mysema.query.Query;
import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.SearchResults;
import com.mysema.query.jpa.AbstractSQLQuery;
import com.mysema.query.jpa.NativeSQLSerializer;
import com.mysema.query.jpa.impl.JPAUtil;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.sql.Union;
import com.mysema.query.sql.UnionImpl;
import com.mysema.query.sql.UnionUtils;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.FactoryExpressionUtils;
import com.mysema.query.types.Path;
import com.mysema.query.types.SubQueryExpression;
import com.mysema.query.types.query.ListSubQuery;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJPASQLQuery<Q extends AbstractJPASQLQuery<Q>>
extends AbstractSQLQuery<Q> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractJPASQLQuery.class);
    @Nullable
    private Map<Object, String> constants;
    private final EntityManager entityManager;
    protected final SQLTemplates templates;
    protected final Map<String, Object> hints = new HashMap<String, Object>();
    @Nullable
    protected SubQueryExpression<?>[] union;
    private boolean unionAll;
    @Nullable
    protected LockModeType lockMode;
    @Nullable
    protected FlushModeType flushMode;
    protected boolean factoryExpressionUsed = false;

    public AbstractJPASQLQuery(EntityManager entityManager, SQLTemplates sqlTemplates) {
        this(entityManager, sqlTemplates, (QueryMetadata)new DefaultQueryMetadata());
    }

    public AbstractJPASQLQuery(EntityManager entityManager, SQLTemplates sqlTemplates, QueryMetadata metadata) {
        super(metadata);
        this.entityManager = entityManager;
        this.templates = sqlTemplates;
    }

    private String buildQueryString(boolean forCountRow) {
        NativeSQLSerializer serializer = new NativeSQLSerializer(this.templates);
        if (this.union != null) {
            serializer.serializeUnion(this.union, this.queryMixin.getMetadata(), this.unionAll);
        } else {
            if (this.queryMixin.getMetadata().getJoins().isEmpty()) {
                throw new IllegalArgumentException("No joins given");
            }
            serializer.serialize(this.queryMixin.getMetadata(), forCountRow);
        }
        this.constants = serializer.getConstantToLabel();
        return serializer.toString();
    }

    public javax.persistence.Query createQuery(Expression<?> ... args) {
        this.queryMixin.getMetadata().setValidate(false);
        this.queryMixin.addToProjection(args);
        return this.createQuery(this.toQueryString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private javax.persistence.Query createQuery(String queryString) {
        FactoryExpression wrapped;
        javax.persistence.Query query;
        this.logQuery(queryString);
        List projection = this.queryMixin.getMetadata().getProjection();
        if (projection.get(0) instanceof EntityPath) {
            if (projection.size() != 1) throw new IllegalArgumentException("Only single element entity projections are supported");
            query = this.entityManager.createNativeQuery(queryString, ((Expression)projection.get(0)).getType());
        } else {
            query = this.entityManager.createNativeQuery(queryString);
        }
        if (this.lockMode != null) {
            query.setLockMode(this.lockMode);
        }
        if (this.flushMode != null) {
            query.setFlushMode(this.flushMode);
        }
        for (Map.Entry<String, Object> entry : this.hints.entrySet()) {
            query.setHint(entry.getKey(), entry.getValue());
        }
        JPAUtil.setConstants(query, this.constants, this.queryMixin.getMetadata().getParams());
        FactoryExpression factoryExpression = wrapped = projection.size() > 1 ? FactoryExpressionUtils.wrap((List)projection) : null;
        if ((projection.size() != 1 || !(projection.get(0) instanceof FactoryExpression)) && wrapped == null) return query;
        this.factoryExpressionUsed = true;
        if (wrapped == null) return query;
        this.getMetadata().clearProjection();
        this.getMetadata().addProjection(new Expression[]{wrapped});
        return query;
    }

    public List<Object[]> list(Expression<?>[] args) {
        javax.persistence.Query query = this.createQuery(args);
        return this.getResultList(query);
    }

    private List<?> getResultList(javax.persistence.Query query) {
        if (this.factoryExpressionUsed) {
            List results = query.getResultList();
            ArrayList<Object> rv = new ArrayList<Object>(results.size());
            FactoryExpression expr = (FactoryExpression)this.getMetadata().getProjection().get(0);
            for (Object o : results) {
                if (o != null) {
                    if (!o.getClass().isArray()) {
                        o = new Object[]{o};
                    }
                    rv.add(expr.newInstance((Object[])o));
                    continue;
                }
                rv.add(null);
            }
            return rv;
        }
        return query.getResultList();
    }

    @Nullable
    private Object getSingleResult(javax.persistence.Query query) {
        if (this.factoryExpressionUsed) {
            Object[] result = query.getSingleResult();
            FactoryExpression expr = (FactoryExpression)this.getMetadata().getProjection().get(0);
            if (result != null) {
                if (!result.getClass().isArray()) {
                    result = new Object[]{result};
                }
                return expr.newInstance(result);
            }
            return null;
        }
        return query.getSingleResult();
    }

    public <RT> List<RT> list(Expression<RT> projection) {
        javax.persistence.Query query = this.createQuery(projection);
        return this.getResultList(query);
    }

    public CloseableIterator<Object[]> iterate(Expression<?>[] args) {
        return new IteratorAdapter(this.list(args).iterator());
    }

    public <RT> CloseableIterator<RT> iterate(Expression<RT> projection) {
        return new IteratorAdapter(this.list(projection).iterator());
    }

    public <RT> SearchResults<RT> listResults(Expression<RT> projection) {
        this.queryMixin.addToProjection(new Expression[]{projection});
        javax.persistence.Query query = this.createQuery(this.toCountRowsString());
        long total = ((Number)query.getSingleResult()).longValue();
        if (total > 0L) {
            QueryModifiers modifiers = this.queryMixin.getMetadata().getModifiers();
            String queryString = this.toQueryString();
            query = this.createQuery(queryString);
            List<?> list = this.getResultList(query);
            this.reset();
            return new SearchResults(list, modifiers, total);
        }
        this.reset();
        return SearchResults.emptyResults();
    }

    protected void logQuery(String queryString) {
        if (logger.isDebugEnabled()) {
            logger.debug(queryString.replace('\n', ' '));
        }
    }

    protected void reset() {
        this.queryMixin.getMetadata().reset();
        this.constants = null;
    }

    protected String toCountRowsString() {
        return this.buildQueryString(true);
    }

    protected String toQueryString() {
        return this.buildQueryString(false);
    }

    public <RT> Union<RT> union(ListSubQuery<RT> ... sq) {
        return this.innerUnion((SubQueryExpression<?>[])sq);
    }

    public <RT> Union<RT> union(SubQueryExpression<RT> ... sq) {
        return this.innerUnion(sq);
    }

    public <RT> Union<RT> unionAll(ListSubQuery<RT> ... sq) {
        this.unionAll = true;
        return this.innerUnion((SubQueryExpression<?>[])sq);
    }

    public <RT> Union<RT> unionAll(SubQueryExpression<RT> ... sq) {
        this.unionAll = true;
        return this.innerUnion(sq);
    }

    public <RT> Q union(Path<?> alias, ListSubQuery<RT> ... sq) {
        return (Q)((Object)((AbstractJPASQLQuery)((Object)this.from(UnionUtils.combineUnion(sq, alias, (SQLTemplates)this.templates, (boolean)false)))));
    }

    public <RT> Q union(Path<?> alias, SubQueryExpression<RT> ... sq) {
        return (Q)((Object)((AbstractJPASQLQuery)((Object)this.from(UnionUtils.combineUnion(sq, alias, (SQLTemplates)this.templates, (boolean)false)))));
    }

    public <RT> Q unionAll(Path<?> alias, ListSubQuery<RT> ... sq) {
        return (Q)((Object)((AbstractJPASQLQuery)((Object)this.from(UnionUtils.combineUnion(sq, alias, (SQLTemplates)this.templates, (boolean)true)))));
    }

    public <RT> Q unionAll(Path<?> alias, SubQueryExpression<RT> ... sq) {
        return (Q)((Object)((AbstractJPASQLQuery)((Object)this.from(UnionUtils.combineUnion(sq, alias, (SQLTemplates)this.templates, (boolean)true)))));
    }

    private <RT> Union<RT> innerUnion(SubQueryExpression<?> ... sq) {
        this.queryMixin.getMetadata().setValidate(false);
        if (!this.queryMixin.getMetadata().getJoins().isEmpty()) {
            throw new IllegalArgumentException("Don't mix union and from");
        }
        this.union = sq;
        return new UnionImpl((Query)this, this.union[0].getMetadata().getProjection());
    }

    public <RT> RT uniqueResult(Expression<RT> expr) {
        javax.persistence.Query query = this.createQuery(expr);
        return (RT)this.uniqueResult(query);
    }

    public Object[] uniqueResult(Expression<?>[] args) {
        javax.persistence.Query query = this.createQuery(args);
        Object obj = this.uniqueResult(query);
        if (obj != null) {
            Object[] objectArray;
            if (obj.getClass().isArray()) {
                objectArray = (Object[])obj;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = obj;
            }
            return objectArray;
        }
        return null;
    }

    @Nullable
    private Object uniqueResult(javax.persistence.Query query) {
        try {
            Object object = this.getSingleResult(query);
            return object;
        }
        catch (NoResultException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            Object var3_5 = null;
            return var3_5;
        }
        catch (javax.persistence.NonUniqueResultException e) {
            throw new NonUniqueResultException();
        }
        finally {
            this.reset();
        }
    }

    public Q setLockMode(LockModeType lockMode) {
        this.lockMode = lockMode;
        return (Q)((Object)this);
    }

    public Q setFlushMode(FlushModeType flushMode) {
        this.flushMode = flushMode;
        return (Q)((Object)this);
    }

    public Q setHint(String name, Object value) {
        this.hints.put(name, value);
        return (Q)((Object)this);
    }
}

