/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa;

import com.mysema.query.types.Constant;
import com.mysema.query.types.Operator;
import com.mysema.query.types.OperatorImpl;
import com.mysema.query.types.Ops;
import com.mysema.query.types.PathType;
import com.mysema.query.types.Templates;
import javax.annotation.Nullable;

public class JPQLTemplates
extends Templates {
    public static final char DEFAULT_ESCAPE = '!';
    public static final Operator<String> TYPE = new OperatorImpl("TYPE", new Class[]{Object.class});
    public static final Operator<Object> CAST = new OperatorImpl("CAST", new Class[]{Object.class, Object.class});
    public static final Operator<Boolean> MEMBER_OF = new OperatorImpl("MEMBER_OF", new Class[]{Object.class, Object.class});
    public static final JPQLTemplates DEFAULT = new JPQLTemplates();

    protected JPQLTemplates() {
        this('!');
    }

    protected JPQLTemplates(char escape) {
        super(escape);
        this.add(Ops.AND, "{0} and {1}", 36);
        this.add(Ops.NOT, "not {0}", 3);
        this.add(Ops.OR, "{0} or {1}", 38);
        this.add(Ops.XNOR, "{0} xnor {1}", 39);
        this.add(Ops.XOR, "{0} xor {1}", 39);
        this.add(Ops.BETWEEN, "{0} between {1} and {2}", 30);
        this.add(Ops.MathOps.SQRT, "sqrt({0})");
        this.add(Ops.MOD, "mod({0},{1})", 0);
        this.add(Ops.NE, "{0} <> {1}", 25);
        this.add(Ops.IS_NULL, "{0} is null", 26);
        this.add(Ops.IS_NOT_NULL, "{0} is not null", 26);
        this.add(CAST, "cast({0} as {1s})");
        this.add(Ops.NUMCAST, "cast({0} as {1s})");
        this.add(MEMBER_OF, "{0} member of {1}");
        this.add(Ops.IN, "{0} in {1}");
        this.add(Ops.COL_IS_EMPTY, "{0} is empty");
        this.add(Ops.COL_SIZE, "size({0})");
        this.add(Ops.ARRAY_SIZE, "size({0})");
        this.add(Ops.LIKE, "{0} like {1} escape '" + escape + "'", 1);
        this.add(Ops.CONCAT, "concat({0},{1})", 0);
        this.add(Ops.MATCHES, "{0} like {1}  escape '" + escape + "'", 27);
        this.add(Ops.MATCHES_IC, "{0} like {1} escape '" + escape + "'", 27);
        this.add(Ops.LOWER, "lower({0})");
        this.add(Ops.SUBSTR_1ARG, "substring({0},{1s}+1)");
        this.add(Ops.SUBSTR_2ARGS, "substring({0},{1s}+1,{2s}-{1s})");
        this.add(Ops.TRIM, "trim({0})");
        this.add(Ops.UPPER, "upper({0})");
        this.add(Ops.EQ_IGNORE_CASE, "{0l} = {1l}");
        this.add(Ops.CHAR_AT, "cast(substring({0},{1s}+1,1) as char)");
        this.add(Ops.STRING_IS_EMPTY, "length({0}) = 0");
        this.add(Ops.STRING_CONTAINS, "{0} like {%1%} escape '" + escape + "'");
        this.add(Ops.STRING_CONTAINS_IC, "{0l} like {%%1%%} escape '" + escape + "'");
        this.add(Ops.ENDS_WITH, "{0} like {%1} escape '" + escape + "'");
        this.add(Ops.ENDS_WITH_IC, "{0l} like {%%1} escape '" + escape + "'");
        this.add(Ops.STARTS_WITH, "{0} like {1%} escape '" + escape + "'");
        this.add(Ops.STARTS_WITH_IC, "{0l} like {1%%} escape '" + escape + "'");
        this.add(Ops.INDEX_OF, "locate({1},{0})-1");
        this.add(Ops.INDEX_OF_2ARGS, "locate({1},{0},{2s}+1)-1");
        this.add(Ops.DateTimeOps.SYSDATE, "sysdate");
        this.add(Ops.DateTimeOps.CURRENT_DATE, "current_date");
        this.add(Ops.DateTimeOps.CURRENT_TIME, "current_time");
        this.add(Ops.DateTimeOps.CURRENT_TIMESTAMP, "current_timestamp");
        this.add(Ops.DateTimeOps.MILLISECOND, "0");
        this.add(Ops.DateTimeOps.SECOND, "second({0})");
        this.add(Ops.DateTimeOps.MINUTE, "minute({0})");
        this.add(Ops.DateTimeOps.HOUR, "hour({0})");
        this.add(Ops.DateTimeOps.DAY_OF_MONTH, "day({0})");
        this.add(Ops.DateTimeOps.MONTH, "month({0})");
        this.add(Ops.DateTimeOps.YEAR, "year({0})");
        this.add(Ops.DateTimeOps.YEAR_MONTH, "year({0}) * 100 + month({0})");
        this.add((Operator)PathType.PROPERTY, "{0}.{1s}");
        this.add((Operator)PathType.VARIABLE, "{0s}");
        this.add(Ops.CASE_EQ, "case {1} end");
        this.add(Ops.CASE_EQ_WHEN, "when {0} = {1} then {2} {3}");
        this.add(Ops.CASE_EQ_ELSE, "else {0}");
        this.add(Ops.INSTANCE_OF, "type({0}) = {1}");
        this.add(TYPE, "type({0})");
    }

    public boolean wrapElements(Operator<?> operator) {
        return false;
    }

    public boolean isTypeAsString() {
        return false;
    }

    public boolean isEnumInPathSupported() {
        return true;
    }

    public boolean isSelect1Supported() {
        return false;
    }

    @Nullable
    public String getExistsProjection() {
        return null;
    }

    public boolean wrapConstant(Constant<?> expr) {
        return false;
    }

    public boolean isWithForOn() {
        return false;
    }
}

