/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.ConstantImpl;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Ops;
import com.mysema.query.types.expr.BooleanExpression;
import com.mysema.query.types.expr.BooleanOperation;
import com.mysema.query.types.expr.NumberExpression;
import com.mysema.query.types.expr.NumberOperation;
import com.mysema.query.types.expr.SimpleExpression;
import com.mysema.query.types.expr.SimpleOperation;
import com.mysema.query.types.expr.StringExpression;
import com.mysema.query.types.expr.StringOperation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public final class CaseBuilder {
    public Initial when(BooleanExpression b) {
        return new Initial(b);
    }

    public static class Initial {
        private final BooleanExpression when;

        public Initial(BooleanExpression b) {
            this.when = b;
        }

        public <A> Cases<A, Expression<A>> then(A constant) {
            return this.then((A)((Object)new ConstantImpl<A>(constant)));
        }

        public Cases<Boolean, BooleanExpression> then(BooleanExpression expr) {
            return this.thenBoolean(expr);
        }

        private Cases<Boolean, BooleanExpression> thenBoolean(Expression<Boolean> expr) {
            return new Cases<Boolean, BooleanExpression>(Boolean.class){

                @Override
                protected BooleanExpression createResult(Class<Boolean> type, Expression<Boolean> last) {
                    return BooleanOperation.create(Ops.CASE, last);
                }
            }.addCase(this.when, expr);
        }

        public Cases<String, StringExpression> then(StringExpression expr) {
            return this.thenString(expr);
        }

        private Cases<String, StringExpression> thenString(Expression<String> expr) {
            return new Cases<String, StringExpression>(String.class){

                @Override
                protected StringExpression createResult(Class<String> type, Expression<String> last) {
                    return StringOperation.create(Ops.CASE, last);
                }
            }.addCase(this.when, expr);
        }

        public <A> Cases<A, Expression<A>> then(Expression<A> expr) {
            return new Cases<A, Expression<A>>(expr.getType()){

                @Override
                protected Expression<A> createResult(Class<A> type, Expression<A> last) {
                    return SimpleOperation.create(type, Ops.CASE, last);
                }
            }.addCase(this.when, expr);
        }

        public <A extends Number> Cases<A, NumberExpression<A>> then(NumberExpression<A> expr) {
            return this.thenNumber(expr);
        }

        private <A extends Number> Cases<A, NumberExpression<A>> thenNumber(Expression<A> expr) {
            return new Cases<A, NumberExpression<A>>(expr.getType()){

                @Override
                protected NumberExpression<A> createResult(Class<A> type, Expression<A> last) {
                    return NumberOperation.create(type, Ops.CASE, last);
                }
            }.addCase(this.when, expr);
        }

        public Cases<String, StringExpression> then(String str) {
            return this.thenString(ConstantImpl.create(str));
        }

        public <A extends Number> Cases<A, NumberExpression<A>> then(A num) {
            return this.thenNumber(new ConstantImpl<A>(num));
        }

        public Cases<Boolean, BooleanExpression> then(boolean b) {
            return this.thenBoolean(ConstantImpl.create(b));
        }
    }

    public static class CaseWhen<A, Q extends Expression<A>> {
        private final BooleanExpression b;
        private final Cases<A, Q> cases;

        public CaseWhen(Cases<A, Q> cases, BooleanExpression b) {
            this.cases = cases;
            this.b = b;
        }

        public Cases<A, Q> then(A constant) {
            return this.then((Expression<A>)new ConstantImpl<A>(constant));
        }

        public Cases<A, Q> then(Expression<A> expr) {
            return this.cases.addCase(this.b, expr);
        }
    }

    public static abstract class Cases<A, Q extends Expression<A>> {
        private final List<CaseElement<A>> cases = new ArrayList<CaseElement<A>>();
        private final Class<A> type;

        public Cases(Class<A> type) {
            this.type = type;
        }

        Cases<A, Q> addCase(BooleanExpression condition, Expression<A> expr) {
            this.cases.add(0, new CaseElement<A>(condition, expr));
            return this;
        }

        protected abstract Q createResult(Class<A> var1, Expression<A> var2);

        public Q otherwise(A constant) {
            return this.otherwise((Expression<A>)new ConstantImpl<A>(constant));
        }

        public Q otherwise(Expression<A> expr) {
            this.cases.add(0, new CaseElement<A>(null, expr));
            SimpleExpression<Object> last = null;
            for (CaseElement<A> element : this.cases) {
                if (last == null) {
                    last = SimpleOperation.create(this.type, Ops.CASE_ELSE, element.getTarget());
                    continue;
                }
                last = SimpleOperation.create(this.type, Ops.CASE_WHEN, element.getCondition(), element.getTarget(), last);
            }
            return this.createResult(this.type, last);
        }

        public CaseWhen<A, Q> when(BooleanExpression b) {
            return new CaseWhen(this, b);
        }
    }

    private static class CaseElement<A> {
        @Nullable
        private final BooleanExpression condition;
        private final Expression<A> target;

        public CaseElement(@Nullable BooleanExpression condition, Expression<A> target) {
            this.condition = condition;
            this.target = target;
        }

        public BooleanExpression getCondition() {
            return this.condition;
        }

        public Expression<A> getTarget() {
            return this.target;
        }
    }
}

