/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types;

import com.google.common.base.Function;
import com.mysema.query.types.Constant;
import com.mysema.query.types.ConstantImpl;
import com.mysema.query.types.Expression;
import com.mysema.query.types.OperationImpl;
import com.mysema.query.types.Ops;
import java.util.Locale;

public final class Converters {
    private final String escape;
    private final String escape1;
    private final String escape2;
    private final String escape3;
    public final Function<Expression<String>, Expression<String>> toLowerCase = new Function<Expression<String>, Expression<String>>(){

        public Expression<String> apply(Expression<String> arg) {
            if (arg instanceof Constant) {
                return ConstantImpl.create(arg.toString().toLowerCase(Locale.ENGLISH));
            }
            return new OperationImpl<String>(String.class, Ops.LOWER, arg);
        }
    };
    public final Function<Expression<String>, Expression<String>> toUpperCase = new Function<Expression<String>, Expression<String>>(){

        public Expression<String> apply(Expression<String> arg) {
            if (arg instanceof Constant) {
                return ConstantImpl.create(arg.toString().toUpperCase(Locale.ENGLISH));
            }
            return new OperationImpl<String>(String.class, Ops.UPPER, arg);
        }
    };
    public final Function<Expression<String>, Expression<String>> toStartsWithViaLike = new Function<Expression<String>, Expression<String>>(){

        public Expression<String> apply(Expression<String> arg) {
            if (arg instanceof Constant) {
                return ConstantImpl.create(Converters.this.escapeForLike((Constant)arg) + "%");
            }
            return new OperationImpl<String>(String.class, Ops.CONCAT, arg, ConstantImpl.create("%"));
        }
    };
    public final Function<Expression<String>, Expression<String>> toStartsWithViaLikeLower = new Function<Expression<String>, Expression<String>>(){

        public Expression<String> apply(Expression<String> arg) {
            if (arg instanceof Constant) {
                return ConstantImpl.create(Converters.this.escapeForLike((Constant)arg).toLowerCase(Locale.ENGLISH) + "%");
            }
            OperationImpl<String> concated = new OperationImpl<String>(String.class, Ops.CONCAT, arg, ConstantImpl.create("%"));
            return new OperationImpl<String>(String.class, Ops.LOWER, concated);
        }
    };
    public final Function<Expression<String>, Expression<String>> toEndsWithViaLike = new Function<Expression<String>, Expression<String>>(){

        public Expression<String> apply(Expression<String> arg) {
            if (arg instanceof Constant) {
                return ConstantImpl.create("%" + Converters.this.escapeForLike((Constant)arg));
            }
            return new OperationImpl<String>(String.class, Ops.CONCAT, ConstantImpl.create("%"), arg);
        }
    };
    public final Function<Expression<String>, Expression<String>> toEndsWithViaLikeLower = new Function<Expression<String>, Expression<String>>(){

        public Expression<String> apply(Expression<String> arg) {
            if (arg instanceof Constant) {
                return ConstantImpl.create("%" + Converters.this.escapeForLike((Constant)arg).toLowerCase(Locale.ENGLISH));
            }
            OperationImpl<String> concated = new OperationImpl<String>(String.class, Ops.CONCAT, ConstantImpl.create("%"), arg);
            return new OperationImpl<String>(String.class, Ops.LOWER, concated);
        }
    };
    public final Function<Expression<String>, Expression<String>> toContainsViaLike = new Function<Expression<String>, Expression<String>>(){

        public Expression<String> apply(Expression<String> arg) {
            if (arg instanceof Constant) {
                return ConstantImpl.create("%" + Converters.this.escapeForLike((Constant)arg) + "%");
            }
            OperationImpl<String> concated = new OperationImpl<String>(String.class, Ops.CONCAT, ConstantImpl.create("%"), arg);
            return new OperationImpl<String>(String.class, Ops.CONCAT, concated, ConstantImpl.create("%"));
        }
    };
    public final Function<Expression<String>, Expression<String>> toContainsViaLikeLower = new Function<Expression<String>, Expression<String>>(){

        public Expression<String> apply(Expression<String> arg) {
            if (arg instanceof Constant) {
                return ConstantImpl.create("%" + Converters.this.escapeForLike((Constant)arg).toLowerCase(Locale.ENGLISH) + "%");
            }
            OperationImpl<String> concated = new OperationImpl<String>(String.class, Ops.CONCAT, ConstantImpl.create("%"), arg);
            concated = new OperationImpl<String>(String.class, Ops.CONCAT, concated, ConstantImpl.create("%"));
            return new OperationImpl<String>(String.class, Ops.LOWER, concated);
        }
    };

    public Converters(char escape) {
        this.escape = String.valueOf(escape);
        this.escape1 = escape + "%";
        this.escape2 = escape + "_";
        this.escape3 = escape + "" + escape;
    }

    public String escapeForLike(Constant<String> expr) {
        String str = expr.getConstant();
        if (str.contains(this.escape) || str.contains("%") || str.contains("_")) {
            str = str.replace(this.escape, this.escape3).replace("%", this.escape1).replace("_", this.escape2);
        }
        return str;
    }
}

