/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query;

import com.google.common.base.Objects;
import com.mysema.query.QueryException;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.ExtractorVisitor;
import com.mysema.query.types.Operation;
import com.mysema.query.types.Operator;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.Visitor;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public final class BooleanBuilder
implements Predicate,
Cloneable,
Operation<Boolean> {
    private static final long serialVersionUID = -4129485177345542519L;
    @Nullable
    private Predicate predicate;

    public BooleanBuilder() {
    }

    public BooleanBuilder(Predicate initial) {
        this.predicate = (Predicate)initial.accept(ExtractorVisitor.DEFAULT, null);
    }

    @Override
    public <R, C> R accept(Visitor<R, C> v, C context) {
        if (this.predicate != null) {
            return this.predicate.accept(v, context);
        }
        throw new QueryException("BooleanBuilder has no value");
    }

    public BooleanBuilder and(@Nullable Predicate right) {
        if (right != null) {
            this.predicate = this.predicate == null ? right : ExpressionUtils.and(this.predicate, right);
        }
        return this;
    }

    public BooleanBuilder andAnyOf(Predicate ... args) {
        if (args.length > 0) {
            this.and(ExpressionUtils.anyOf(args));
        }
        return this;
    }

    public BooleanBuilder andNot(Predicate right) {
        return this.and(right.not());
    }

    public BooleanBuilder clone() throws CloneNotSupportedException {
        return (BooleanBuilder)super.clone();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BooleanBuilder) {
            return Objects.equal((Object)((BooleanBuilder)o).getValue(), (Object)this.predicate);
        }
        return false;
    }

    @Override
    public Expression<?> getArg(int index) {
        if (index == 0) {
            return this.predicate;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public List<Expression<?>> getArgs() {
        return Collections.singletonList(this.predicate);
    }

    @Override
    public Operator<? super Boolean> getOperator() {
        return Ops.DELEGATE;
    }

    @Nullable
    public Predicate getValue() {
        return this.predicate;
    }

    public int hashCode() {
        return this.predicate != null ? this.predicate.hashCode() : 0;
    }

    public boolean hasValue() {
        return this.predicate != null;
    }

    @Override
    public BooleanBuilder not() {
        if (this.predicate != null) {
            this.predicate = this.predicate.not();
        }
        return this;
    }

    public BooleanBuilder or(@Nullable Predicate right) {
        if (right != null) {
            this.predicate = this.predicate == null ? right : ExpressionUtils.or(this.predicate, right);
        }
        return this;
    }

    public BooleanBuilder orAllOf(Predicate ... args) {
        if (args.length > 0) {
            this.or(ExpressionUtils.allOf(args));
        }
        return this;
    }

    public BooleanBuilder orNot(Predicate right) {
        return this.or(right.not());
    }

    @Override
    public Class<? extends Boolean> getType() {
        return Boolean.class;
    }

    public String toString() {
        return this.predicate != null ? this.predicate.toString() : super.toString();
    }
}

