/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.BaseMapper;
import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.query.ChainQuery;
import com.mybatisflex.core.query.FieldsBuilder;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.query.RelationsBuilder;
import com.mybatisflex.core.relation.RelationManager;
import com.mybatisflex.core.util.LambdaGetter;
import com.mybatisflex.core.util.LambdaUtil;
import com.mybatisflex.core.util.SqlUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public interface MapperQueryChain<T>
extends ChainQuery<T> {
    public BaseMapper<T> baseMapper();

    public QueryWrapper toQueryWrapper();

    default public long count() {
        return this.baseMapper().selectCountByQuery(this.toQueryWrapper());
    }

    default public boolean exists() {
        return SqlUtil.toBool(this.count());
    }

    @Override
    default public T one() {
        return this.baseMapper().selectOneByQuery(this.toQueryWrapper());
    }

    @Override
    default public <R> R oneAs(Class<R> asType) {
        return this.baseMapper().selectOneByQueryAs(this.toQueryWrapper(), asType);
    }

    default public Object obj() {
        return this.baseMapper().selectObjectByQuery(this.toQueryWrapper());
    }

    default public <R> R objAs(Class<R> asType) {
        return this.baseMapper().selectObjectByQueryAs(this.toQueryWrapper(), asType);
    }

    default public Optional<Object> objOpt() {
        return Optional.ofNullable(this.obj());
    }

    default public <R> Optional<R> objAsOpt(Class<R> asType) {
        return Optional.ofNullable(this.objAs(asType));
    }

    default public List<Object> objList() {
        return this.baseMapper().selectObjectListByQuery(this.toQueryWrapper());
    }

    default public <R> List<R> objListAs(Class<R> asType) {
        return this.baseMapper().selectObjectListByQueryAs(this.toQueryWrapper(), asType);
    }

    @Override
    default public List<T> list() {
        return this.baseMapper().selectListByQuery(this.toQueryWrapper());
    }

    @Override
    default public <R> List<R> listAs(Class<R> asType) {
        return this.baseMapper().selectListByQueryAs(this.toQueryWrapper(), asType);
    }

    @Override
    default public Page<T> page(Page<T> page) {
        return this.baseMapper().paginate(page, this.toQueryWrapper());
    }

    @Override
    default public <R> Page<R> pageAs(Page<R> page, Class<R> asType) {
        return this.baseMapper().paginateAs(page, this.toQueryWrapper(), asType);
    }

    default public FieldsBuilder<T> withFields() {
        return new FieldsBuilder(this);
    }

    default public RelationsBuilder<T> withRelations() {
        return new RelationsBuilder(this);
    }

    default public RelationsBuilder<T> withRelations(LambdaGetter<T> ... columns) {
        if (columns != null && columns.length > 0) {
            String[] array = (String[])Arrays.stream(columns).map(LambdaUtil::getFieldName).toArray(String[]::new);
            RelationManager.addQueryRelations(array);
        }
        return new RelationsBuilder(this);
    }
}

