/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.mybatis;

import com.mybatisflex.core.audit.AuditManager;
import com.mybatisflex.core.mybatis.FlexPreparedStatementHandler;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.ibatis.cursor.Cursor;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.ExecutorException;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.statement.CallableStatementHandler;
import org.apache.ibatis.executor.statement.SimpleStatementHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

public class FlexStatementHandler
implements StatementHandler {
    private final StatementHandler delegate;
    private final BoundSql boundSql;
    private final boolean auditEnable = AuditManager.isAuditEnable();
    private final Configuration configuration;
    private final String stmtId;

    public FlexStatementHandler(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) {
        this.configuration = ms.getConfiguration();
        this.stmtId = ms.getId();
        switch (ms.getStatementType()) {
            case STATEMENT: {
                this.delegate = new SimpleStatementHandler(executor, ms, parameter, rowBounds, resultHandler, boundSql);
                break;
            }
            case PREPARED: {
                this.delegate = new FlexPreparedStatementHandler(executor, ms, parameter, rowBounds, resultHandler, boundSql);
                break;
            }
            case CALLABLE: {
                this.delegate = new CallableStatementHandler(executor, ms, parameter, rowBounds, resultHandler, boundSql);
                break;
            }
            default: {
                throw new ExecutorException("Unknown statement type: " + ms.getStatementType());
            }
        }
        this.boundSql = this.delegate.getBoundSql();
    }

    public Statement prepare(Connection connection, Integer transactionTimeout) throws SQLException {
        return this.delegate.prepare(connection, transactionTimeout);
    }

    public void parameterize(Statement statement) throws SQLException {
        this.delegate.parameterize(statement);
    }

    public void batch(Statement statement) throws SQLException {
        if (this.auditEnable) {
            AuditManager.startAudit(() -> {
                this.delegate.batch(statement);
                return null;
            }, this.stmtId, statement, this.boundSql, this.configuration);
        } else {
            this.delegate.batch(statement);
        }
    }

    public int update(Statement statement) throws SQLException {
        return this.auditEnable ? AuditManager.startAudit(() -> this.delegate.update(statement), this.stmtId, statement, this.boundSql, this.configuration).intValue() : this.delegate.update(statement);
    }

    public <E> List<E> query(Statement statement, ResultHandler resultHandler) throws SQLException {
        return this.auditEnable ? AuditManager.startAudit(() -> this.delegate.query(statement, resultHandler), this.stmtId, statement, this.boundSql, this.configuration) : this.delegate.query(statement, resultHandler);
    }

    public <E> Cursor<E> queryCursor(Statement statement) throws SQLException {
        return this.auditEnable ? AuditManager.startAudit(() -> this.delegate.queryCursor(statement), this.stmtId, statement, this.boundSql, this.configuration) : this.delegate.queryCursor(statement);
    }

    public BoundSql getBoundSql() {
        return this.delegate.getBoundSql();
    }

    public ParameterHandler getParameterHandler() {
        return this.delegate.getParameterHandler();
    }
}

