/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.row;

import com.mybatisflex.core.javassist.ModifyAttrsRecord;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.row.RowKey;
import com.mybatisflex.core.row.RowUtil;
import com.mybatisflex.core.util.ArrayUtil;
import com.mybatisflex.core.util.ConvertUtil;
import com.mybatisflex.core.util.SqlUtil;
import com.mybatisflex.core.util.StringUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class Row
extends HashMap<String, Object>
implements ModifyAttrsRecord {
    private static final Object[] NULL_ARGS = new Object[0];
    private RowKey[] primaryKeys;
    private Set<String> modifyAttrs = new LinkedHashSet<String>();

    public static Row of(String key, Object value) {
        Row row = new Row();
        return row.set(key, value);
    }

    @Override
    public Set<String> getModifyAttrs() {
        return this.modifyAttrs;
    }

    public static Row ofKey(String primaryKey, Object value) {
        Row row = new Row();
        String[] primaryKeyStrings = primaryKey.split(",");
        row.primaryKeys = new RowKey[primaryKeyStrings.length];
        for (int i = 0; i < primaryKeyStrings.length; ++i) {
            row.primaryKeys[i] = RowKey.of(primaryKeyStrings[i].trim());
        }
        if (primaryKeyStrings.length > 1 && !value.getClass().isArray()) {
            throw new IllegalArgumentException("The type of \"" + value + "\" must be an array.");
        }
        if (primaryKeyStrings.length == 1) {
            row.put(primaryKey.trim(), value);
        } else {
            Object[] values = (Object[])value;
            for (int i = 0; i < primaryKeyStrings.length; ++i) {
                row.put(primaryKeyStrings[i].trim(), values[i]);
            }
        }
        return row;
    }

    public static Row ofKey(RowKey ... rowKeys) {
        Row row = new Row();
        row.primaryKeys = rowKeys;
        return row;
    }

    public static Row ofKey(RowKey rowKey, Object value) {
        Row row = new Row();
        row.primaryKeys = new RowKey[]{rowKey};
        row.put(rowKey.keyColumn, value);
        return row;
    }

    public static Row ofKey(RowKey[] rowKeys, Object[] value) {
        Row row = new Row();
        row.primaryKeys = rowKeys;
        for (int i = 0; i < rowKeys.length; ++i) {
            row.put(rowKeys[i].keyColumn, value[i]);
        }
        return row;
    }

    public Row set(String column, Object value) {
        if (StringUtil.isBlank(column)) {
            throw new IllegalArgumentException("key column not be null or empty.");
        }
        SqlUtil.keepColumnSafely(column);
        this.put(column, value);
        boolean isPrimaryKey = false;
        if (this.primaryKeys != null) {
            for (RowKey rowKey : this.primaryKeys) {
                if (!rowKey.getKeyColumn().equals(column)) continue;
                isPrimaryKey = true;
                break;
            }
        }
        if (!isPrimaryKey) {
            this.addModifyAttr(column);
        }
        return this;
    }

    public Row set(QueryColumn queryColumn, Object value) {
        return this.set(queryColumn.getName(), value);
    }

    public Object get(String key, Object defaultValue) {
        Object result = super.get(key);
        return result != null ? result : defaultValue;
    }

    public String getString(String key) {
        Object s = super.get(key);
        return s != null ? s.toString() : null;
    }

    public String getString(String key, String defaultValue) {
        Object s = super.get(key);
        if (s == null) {
            return defaultValue;
        }
        String r = s.toString();
        return r.trim().length() == 0 ? defaultValue : r;
    }

    public Integer getInt(String key) {
        return ConvertUtil.toInt(super.get(key));
    }

    public Integer getInt(String key, Integer defaultValue) {
        Integer r = ConvertUtil.toInt(super.get(key));
        return r != null ? r : defaultValue;
    }

    public Long getLong(String key) {
        return ConvertUtil.toLong(super.get(key));
    }

    public Long getLong(String key, Long defaultValue) {
        Long r = ConvertUtil.toLong(super.get(key));
        return r != null ? r : defaultValue;
    }

    public Double getDouble(String key) {
        return ConvertUtil.toDouble(super.get(key));
    }

    public Double getDouble(String key, Double defaultValue) {
        Double r = ConvertUtil.toDouble(super.get(key));
        return r != null ? r : defaultValue;
    }

    public Float getFloat(String key, Float defaultValue) {
        Float r = ConvertUtil.toFloat(super.get(key));
        return r != null ? r : defaultValue;
    }

    public Float getFloat(String key) {
        return ConvertUtil.toFloat(super.get(key));
    }

    public Short getShort(String key, Short defaultValue) {
        Short r = ConvertUtil.toShort(super.get(key));
        return r != null ? r : defaultValue;
    }

    public Short getShort(String key) {
        return ConvertUtil.toShort(super.get(key));
    }

    public BigInteger getBigInteger(String key) {
        return ConvertUtil.toBigInteger(super.get(key));
    }

    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        BigInteger r = ConvertUtil.toBigInteger(super.get(key));
        return r != null ? r : defaultValue;
    }

    public BigDecimal getBigDecimal(String key) {
        return ConvertUtil.toBigDecimal(super.get(key));
    }

    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        BigDecimal r = ConvertUtil.toBigDecimal(super.get(key));
        return r != null ? r : defaultValue;
    }

    public Boolean getBoolean(String key) {
        return ConvertUtil.toBoolean(super.get(key));
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        Boolean r = ConvertUtil.toBoolean(super.get(key));
        return r != null ? r : defaultValue;
    }

    public Date getDate(String key) {
        return ConvertUtil.toDate(super.get(key));
    }

    public Date getDate(String key, Date defaultValue) {
        Date r = ConvertUtil.toDate(super.get(key));
        return r != null ? r : defaultValue;
    }

    public LocalDateTime getLocalDateTime(String key) {
        return ConvertUtil.toLocalDateTime(super.get(key));
    }

    public LocalDateTime getLocalDateTime(String key, LocalDateTime defaultValue) {
        LocalDateTime r = ConvertUtil.toLocalDateTime(super.get(key));
        return r != null ? r : defaultValue;
    }

    public Time getTime(String key) {
        return (Time)super.get(key);
    }

    public Time getTime(String key, Time defaultValue) {
        Time r = (Time)super.get(key);
        return r != null ? r : defaultValue;
    }

    public Timestamp getTimestamp(String key) {
        return (Timestamp)super.get(key);
    }

    public Timestamp getTimestamp(String key, Timestamp defaultValue) {
        Timestamp r = (Timestamp)super.get(key);
        return r != null ? r : defaultValue;
    }

    public Byte getByte(String key) {
        return ConvertUtil.toByte(super.get(key));
    }

    public byte[] getBytes(String key) {
        return (byte[])super.get(key);
    }

    @Override
    public Object remove(Object key) {
        this.removeModifyAttr(key.toString());
        return super.remove(key);
    }

    public <T> T toEntity(Class<T> entityClass) {
        return RowUtil.toEntity(this, entityClass);
    }

    public <T> T toObject(Class<T> objectClass) {
        return RowUtil.toObject(this, objectClass);
    }

    public Map<String, Object> toCamelKeysMap() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (String key : this.keySet()) {
            ret.put(StringUtil.underlineToCamel(key), this.get(key));
        }
        return ret;
    }

    public Map<String, Object> toUnderlineKeysMap() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (String key : this.keySet()) {
            ret.put(StringUtil.camelToUnderline(key), this.get(key));
        }
        return ret;
    }

    void keepModifyAttrs(Collection<String> attrs) {
        if (attrs == null) {
            throw new NullPointerException("attrs is null.");
        }
        this.clearModifyFlag();
        this.modifyAttrs.addAll(attrs);
    }

    Object[] obtainModifyValues() {
        Object[] values = new Object[this.modifyAttrs.size()];
        int index = 0;
        for (String modifyAttr : this.modifyAttrs) {
            values[index++] = this.get(modifyAttr);
        }
        return values;
    }

    String[] obtainsPrimaryKeyStrings() {
        String[] returnKeys = new String[this.primaryKeys.length];
        for (int i = 0; i < this.primaryKeys.length; ++i) {
            returnKeys[i] = this.primaryKeys[i].keyColumn;
        }
        return returnKeys;
    }

    RowKey[] obtainsPrimaryKeys() {
        return this.primaryKeys;
    }

    Object[] obtainsPrimaryValues() {
        if (ArrayUtil.isEmpty(this.primaryKeys)) {
            return NULL_ARGS;
        }
        Object[] values = new Object[this.primaryKeys.length];
        for (int i = 0; i < this.primaryKeys.length; ++i) {
            values[i] = this.get(this.primaryKeys[i].keyColumn);
        }
        return values;
    }

    Object[] obtainAllModifyValues() {
        return ArrayUtil.concat(this.obtainModifyValues(), this.obtainsPrimaryValues());
    }
}

