/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.row;

import com.mybatisflex.core.FlexGlobalConfig;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.query.CPI;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.row.Row;
import com.mybatisflex.core.row.RowMapperInvoker;
import com.mybatisflex.core.transaction.TransactionContext;
import com.mybatisflex.core.transaction.TransactionalManager;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.util.MapUtil;

public class Db {
    private static final Map<String, RowMapperInvoker> INVOKER_MAP = new ConcurrentHashMap<String, RowMapperInvoker>();
    static RowMapperInvoker defaultRowMapperInvoker;

    public static RowMapperInvoker invoker() {
        if (defaultRowMapperInvoker == null) {
            FlexGlobalConfig defaultConfig = FlexGlobalConfig.getDefaultConfig();
            SqlSessionFactory sqlSessionFactory = defaultConfig.getSqlSessionFactory();
            defaultRowMapperInvoker = new RowMapperInvoker(sqlSessionFactory);
        }
        return defaultRowMapperInvoker;
    }

    public static RowMapperInvoker invoker(String environmentId) {
        return (RowMapperInvoker)MapUtil.computeIfAbsent(INVOKER_MAP, (Object)environmentId, key -> {
            SqlSessionFactory sqlSessionFactory = FlexGlobalConfig.getConfig(key).getSqlSessionFactory();
            return new RowMapperInvoker(sqlSessionFactory);
        });
    }

    public static int insert(String tableName, Row row) {
        return Db.invoker().insert(tableName, row);
    }

    public static int insertBySql(String sql, Object ... args) {
        return Db.invoker().insertBySql(sql, args);
    }

    public static int[] insertBatch(String tableName, Collection<Row> rows) {
        return Db.insertBatch(tableName, rows, rows.size());
    }

    public static int[] insertBatch(String tableName, Collection<Row> rows, int batchSize) {
        return Db.invoker().insertBatch(tableName, rows, batchSize);
    }

    public static int insertBatchWithFirstRowColumns(String tableName, List<Row> rows) {
        return Db.invoker().insertBatchWithFirstRowColumns(tableName, rows);
    }

    public static int deleteBySql(String sql, Object ... args) {
        return Db.invoker().deleteBySql(sql, args);
    }

    public static int deleteById(String tableName, Row row) {
        return Db.invoker().deleteById(tableName, row);
    }

    public static int deleteById(String tableName, String primaryKey, Object id) {
        return Db.invoker().deleteById(tableName, primaryKey, id);
    }

    public static int deleteBatchByIds(String tableName, String primaryKey, Collection<?> ids) {
        return Db.invoker().deleteBatchByIds(tableName, primaryKey, ids);
    }

    public static int deleteByMap(String tableName, Map<String, Object> whereColumns) {
        return Db.invoker().deleteByQuery(tableName, new QueryWrapper().where(whereColumns));
    }

    public static int deleteByCondition(String tableName, QueryCondition condition) {
        return Db.invoker().deleteByQuery(tableName, new QueryWrapper().where(condition));
    }

    public static int deleteByQuery(String tableName, QueryWrapper queryWrapper) {
        return Db.invoker().deleteByQuery(tableName, queryWrapper);
    }

    public static int updateBySql(String sql, Object ... args) {
        return Db.invoker().updateBySql(sql, args);
    }

    public static int updateById(String tableName, Row row) {
        return Db.invoker().updateById(tableName, row);
    }

    public static int updateByMap(String tableName, Row data, Map<String, Object> whereColumns) {
        return Db.invoker().updateByQuery(tableName, data, new QueryWrapper().where(whereColumns));
    }

    public static int updateByCondition(String tableName, Row data, QueryCondition condition) {
        return Db.invoker().updateByQuery(tableName, data, new QueryWrapper().where(condition));
    }

    public static int updateByQuery(String tableName, Row data, QueryWrapper queryWrapper) {
        return Db.invoker().updateByQuery(tableName, data, queryWrapper);
    }

    public static int updateBatchById(String tableName, List<Row> rows) {
        return Db.invoker().updateBatchById(tableName, rows);
    }

    public static Row selectOneBySql(String sql, Object ... args) {
        return Db.invoker().selectOneBySql(sql, args);
    }

    public static Row selectOneById(String tableName, Row row) {
        return Db.invoker().selectOneById(tableName, row);
    }

    public static Row selectOneById(String tableName, String primaryKey, Object id) {
        return Db.invoker().selectOneById(tableName, primaryKey, id);
    }

    public static Row selectOneByMap(String tableName, Map whereColumns) {
        return Db.invoker().selectOneByQuery(tableName, new QueryWrapper().where(whereColumns));
    }

    public static Row selectOneByCondition(String tableName, QueryCondition condition) {
        return Db.invoker().selectOneByQuery(tableName, new QueryWrapper().where(condition));
    }

    public static Row selectOneByQuery(String tableName, QueryWrapper queryWrapper) {
        return Db.invoker().selectOneByQuery(tableName, queryWrapper);
    }

    public static Row selectOneByQuery(QueryWrapper queryWrapper) {
        List<QueryTable> queryTables = CPI.getQueryTables(queryWrapper);
        if (queryTables == null || queryTables.isEmpty()) {
            throw FlexExceptions.wrap("table must not be null or empty in Db.selectOneByQuery", new Object[0]);
        }
        return Db.invoker().selectOneByQuery(null, queryWrapper);
    }

    public static List<Row> selectListBySql(String sql, Object ... args) {
        return Db.invoker().selectListBySql(sql, args);
    }

    public static List<Row> selectListByMap(String tableName, Map<String, Object> whereColumns) {
        return Db.invoker().selectListByQuery(tableName, new QueryWrapper().where(whereColumns));
    }

    public static List<Row> selectListByMap(String tableName, Map<String, Object> whereColumns, int count) {
        return Db.invoker().selectListByQuery(tableName, new QueryWrapper().where(whereColumns).limit(count));
    }

    public static List<Row> selectListByCondition(String tableName, QueryCondition condition) {
        return Db.invoker().selectListByQuery(tableName, new QueryWrapper().where(condition));
    }

    public static List<Row> selectListByCondition(String tableName, QueryCondition condition, int count) {
        return Db.invoker().selectListByQuery(tableName, new QueryWrapper().where(condition).limit(count));
    }

    public static List<Row> selectListByQuery(String tableName, QueryWrapper queryWrapper) {
        return Db.invoker().selectListByQuery(tableName, queryWrapper);
    }

    public static List<Row> selectListByQuery(QueryWrapper queryWrapper) {
        List<QueryTable> queryTables = CPI.getQueryTables(queryWrapper);
        if (queryTables == null || queryTables.isEmpty()) {
            throw FlexExceptions.wrap("table must not be null or empty in Db.selectListByQuery", new Object[0]);
        }
        return Db.invoker().selectListByQuery(null, queryWrapper);
    }

    public static List<Row> selectAll(String tableName) {
        return Db.invoker().selectAll(tableName);
    }

    public static Object selectObject(String sql, Object ... args) {
        return Db.invoker().selectObject(sql, args);
    }

    public static List<Object> selectObjectList(String sql, Object ... args) {
        return Db.invoker().selectObjectList(sql, args);
    }

    public static long selectCount(String sql, Object ... args) {
        return Db.invoker().selectCount(sql, args);
    }

    public static long selectCountByCondition(String tableName, QueryCondition condition) {
        return Db.invoker().selectCountByQuery(tableName, new QueryWrapper().where(condition));
    }

    public static long selectCountByQuery(String tableName, QueryWrapper queryWrapper) {
        return Db.invoker().selectCountByQuery(tableName, queryWrapper);
    }

    public static long selectCountByQuery(QueryWrapper queryWrapper) {
        List<QueryTable> queryTables = CPI.getQueryTables(queryWrapper);
        if (queryTables == null || queryTables.isEmpty()) {
            throw FlexExceptions.wrap("table must not be null or empty in Db.selectCountByQuery", new Object[0]);
        }
        return Db.invoker().selectCountByQuery(null, queryWrapper);
    }

    public static Page<Row> paginate(String tableName, int pageNumber, int pageSize, QueryCondition condition) {
        return Db.invoker().paginate(tableName, new Page<Row>(pageNumber, pageSize), QueryWrapper.create().where(condition));
    }

    public static Page<Row> paginate(String tableName, int pageNumber, int pageSize, int totalRow, QueryCondition condition) {
        return Db.invoker().paginate(tableName, new Page<Row>(pageNumber, pageSize, totalRow), QueryWrapper.create().where(condition));
    }

    public static Page<Row> paginate(String tableName, int pageNumber, int pageSize, QueryWrapper queryWrapper) {
        return Db.invoker().paginate(tableName, new Page<Row>(pageNumber, pageSize), queryWrapper);
    }

    public static Page<Row> paginate(String tableName, int pageNumber, int pageSize, int totalRow, QueryWrapper queryWrapper) {
        return Db.invoker().paginate(tableName, new Page<Row>(pageNumber, pageSize, totalRow), queryWrapper);
    }

    public static Page<Row> paginate(String tableName, Page<Row> page, QueryWrapper queryWrapper) {
        return Db.invoker().paginate(tableName, page, queryWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tx(Supplier<Boolean> supplier) {
        String higherXID = TransactionContext.getXID();
        try {
            String xid = TransactionalManager.startTransactional();
            Boolean success = false;
            boolean rollbacked = false;
            try {
                success = supplier.get();
            }
            catch (Exception e) {
                rollbacked = true;
                TransactionalManager.rollback(xid);
                e.printStackTrace();
            }
            finally {
                if (success != null && success.booleanValue()) {
                    TransactionalManager.commit(xid);
                } else if (!rollbacked) {
                    TransactionalManager.rollback(xid);
                }
            }
            boolean bl = success != null && success != false;
            return bl;
        }
        finally {
            if (higherXID != null) {
                TransactionContext.hold(higherXID);
            }
        }
    }
}

