/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryOrderBy;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.query.WrapperUtil;
import com.mybatisflex.core.table.TableDef;
import com.mybatisflex.core.util.SqlUtil;
import com.mybatisflex.core.util.StringUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class QueryColumn
implements Serializable {
    protected QueryTable table;
    protected String name;
    protected String alias;

    public QueryColumn() {
    }

    public QueryColumn(String name) {
        SqlUtil.keepColumnSafely(name);
        this.name = name;
    }

    public QueryColumn(String tableName, String name) {
        SqlUtil.keepColumnSafely(name);
        this.table = new QueryTable(tableName);
        this.name = name;
    }

    public QueryColumn(TableDef tableDef, String name) {
        SqlUtil.keepColumnSafely(name);
        this.table = new QueryTable(tableDef.getTableName());
        this.name = name;
    }

    public QueryTable getTable() {
        return this.table;
    }

    public void setTable(QueryTable table) {
        this.table = table;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public QueryColumn as(String alias) {
        SqlUtil.keepColumnSafely(alias);
        QueryColumn newColumn = new QueryColumn();
        newColumn.table = this.table;
        newColumn.name = this.name;
        newColumn.alias = alias;
        return newColumn;
    }

    public QueryCondition eq(Object value) {
        return QueryCondition.create(this, "=", value);
    }

    public QueryCondition ne(Object value) {
        return QueryCondition.create(this, "!=", value);
    }

    public QueryCondition like(Object value) {
        return QueryCondition.create(this, "LIKE", "%" + value + "%");
    }

    public QueryCondition likeLeft(Object value) {
        return QueryCondition.create(this, "LIKE", "%" + value);
    }

    public QueryCondition likeRight(Object value) {
        return QueryCondition.create(this, "LIKE", value + "%");
    }

    public QueryCondition gt(Object value) {
        return QueryCondition.create(this, ">", value);
    }

    public QueryCondition ge(Object value) {
        return QueryCondition.create(this, ">=", value);
    }

    public QueryCondition lt(Object value) {
        return QueryCondition.create(this, "<", value);
    }

    public QueryCondition le(Object value) {
        return QueryCondition.create(this, "<=", value);
    }

    public QueryCondition isNull() {
        return QueryCondition.create(this, "IS NULL", null);
    }

    public QueryCondition isNotNull() {
        return QueryCondition.create(this, "IS NOT NULL", null);
    }

    public QueryCondition in(Object ... arrays) {
        if (arrays != null && arrays.length == 1 && arrays[0] == null) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, "IN", arrays);
    }

    public QueryCondition in(QueryWrapper queryWrapper) {
        return QueryCondition.create(this, "IN", queryWrapper);
    }

    public QueryCondition in(Collection<?> collection) {
        if (collection != null && !collection.isEmpty()) {
            return this.in(collection.toArray());
        }
        return QueryCondition.createEmpty();
    }

    public QueryCondition notIn(Object ... arrays) {
        if (arrays != null && arrays.length == 1 && arrays[0] == null) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, "NOT IN", arrays);
    }

    public QueryCondition notIn(Collection<?> collection) {
        if (collection != null && !collection.isEmpty()) {
            return this.notIn(collection.toArray());
        }
        return QueryCondition.createEmpty();
    }

    public QueryCondition notIn(QueryWrapper queryWrapper) {
        return QueryCondition.create(this, "NOT IN", queryWrapper);
    }

    public QueryCondition between(Object start, Object end) {
        return QueryCondition.create(this, "BETWEEN", new Object[]{start, end});
    }

    public QueryCondition notBetween(Object start, Object end) {
        return QueryCondition.create(this, "NOT BETWEEN", new Object[]{start, end});
    }

    public QueryOrderBy asc() {
        QueryOrderBy queryOrderBy = new QueryOrderBy(this);
        return queryOrderBy;
    }

    public QueryOrderBy desc() {
        return new QueryOrderBy(this, "DESC");
    }

    protected String wrap(IDialect dialect, String table, String column) {
        if (StringUtil.isNotBlank(table)) {
            return dialect.wrap(table) + "." + dialect.wrap(column);
        }
        return dialect.wrap(column);
    }

    String toConditionSql(List<QueryTable> queryTables, IDialect dialect) {
        String tableName = WrapperUtil.getColumnTableName(queryTables, this.table);
        return this.wrap(dialect, tableName, this.name);
    }

    String toSelectSql(List<QueryTable> queryTables, IDialect dialect) {
        String tableName = WrapperUtil.getColumnTableName(queryTables, this.table);
        return this.wrap(dialect, tableName, this.name) + WrapperUtil.buildAsAlias(dialect.wrap(this.alias));
    }

    public String toString() {
        return "QueryColumn{table=" + this.table + ", name='" + this.name + '\'' + ", alias='" + this.alias + '\'' + '}';
    }
}

