/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.keygen;

import com.mybatisflex.core.FlexGlobalConfig;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.keygen.IKeyGenerator;
import com.mybatisflex.core.keygen.KeyGeneratorFactory;
import com.mybatisflex.core.keygen.MybatisKeyGeneratorUtil;
import com.mybatisflex.core.table.IdInfo;
import com.mybatisflex.core.table.TableInfo;
import com.mybatisflex.core.util.ConvertUtil;
import java.sql.Statement;
import java.util.Map;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.reflection.invoker.Invoker;
import org.apache.ibatis.session.Configuration;

public class CustomKeyGenerator
implements KeyGenerator {
    protected Configuration configuration;
    protected IKeyGenerator keyGenerator;
    protected TableInfo tableInfo;
    protected IdInfo idInfo;

    public CustomKeyGenerator(Configuration configuration, TableInfo tableInfo, IdInfo idInfo) {
        this.configuration = configuration;
        FlexGlobalConfig.KeyConfig globalKeyConfig = FlexGlobalConfig.getConfig(configuration).getKeyConfig();
        String keyValue = MybatisKeyGeneratorUtil.getKeyValue(idInfo, globalKeyConfig);
        this.keyGenerator = KeyGeneratorFactory.getKeyGenerator(keyValue);
        this.tableInfo = tableInfo;
        this.idInfo = idInfo;
        this.ensuresKeyGeneratorNotNull();
    }

    private void ensuresKeyGeneratorNotNull() {
        if (this.keyGenerator == null) {
            throw FlexExceptions.wrap("The name of \"%s\" key generator not exist.\nplease check annotation @Id(value=\"%s\") at field: %s#%s", this.idInfo.getValue(), this.idInfo.getValue(), this.tableInfo.getEntityClass().getName(), this.idInfo.getProperty());
        }
    }

    public void processBefore(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
        Object entity = ((Map)parameter).get("$$entity");
        Object generateId = this.keyGenerator.generate(entity, this.idInfo.getColumn());
        try {
            Invoker setInvoker = this.tableInfo.getReflector().getSetInvoker(this.idInfo.getProperty());
            Object id = ConvertUtil.convert(generateId, setInvoker.getType());
            setInvoker.invoke(entity, new Object[]{id});
        }
        catch (Exception e) {
            throw FlexExceptions.wrap(e);
        }
    }

    public void processAfter(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
    }
}

