/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.audit.http;

import com.mybatisflex.core.util.StringUtil;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.ibatis.logging.LogFactory;

public class HttpUtil {
    private static final String POST = "POST";
    private static String CHARSET = "UTF-8";
    private static int connectTimeout = 15000;
    private static int readTimeout = 15000;
    private static final SSLSocketFactory sslSocketFactory = HttpUtil.initSSLSocketFactory();
    private static final TrustAnyHostnameVerifier trustAnyHostnameVerifier = new TrustAnyHostnameVerifier();

    private static SSLSocketFactory initSSLSocketFactory() {
        try {
            TrustManager[] tm = new TrustManager[]{new TrustAnyTrustManager()};
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, tm, new SecureRandom());
            return sslContext.getSocketFactory();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setCharSet(String charSet) {
        if (StringUtil.isBlank(charSet)) {
            throw new IllegalArgumentException("charSet can not be blank.");
        }
        CHARSET = charSet;
    }

    public static void setConnectTimeout(int connectTimeout) {
        HttpUtil.connectTimeout = connectTimeout;
    }

    public static void setReadTimeout(int readTimeout) {
        HttpUtil.readTimeout = readTimeout;
    }

    private static HttpURLConnection getHttpConnection(String url, String method, Map<String, String> headers) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, KeyManagementException {
        URL _url = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)_url.openConnection();
        if (conn instanceof HttpsURLConnection) {
            ((HttpsURLConnection)conn).setSSLSocketFactory(sslSocketFactory);
            ((HttpsURLConnection)conn).setHostnameVerifier(trustAnyHostnameVerifier);
        }
        conn.setRequestMethod(method);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setConnectTimeout(connectTimeout);
        conn.setReadTimeout(readTimeout);
        conn.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        return conn;
    }

    public static String post(String url, Map<String, String> queryParas, String data, Map<String, String> headers) {
        HttpURLConnection conn = null;
        try {
            Object out;
            conn = HttpUtil.getHttpConnection(HttpUtil.buildUrlQuery(url, queryParas), POST, headers);
            conn.connect();
            if (data != null) {
                out = conn.getOutputStream();
                Throwable throwable = null;
                try {
                    ((OutputStream)out).write(data.getBytes(CHARSET));
                    ((OutputStream)out).flush();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (out != null) {
                        if (throwable != null) {
                            try {
                                ((OutputStream)out).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((OutputStream)out).close();
                        }
                    }
                }
            }
            out = HttpUtil.readString(conn);
            return out;
        }
        catch (IOException e) {
            LogFactory.getLog(HttpUtil.class).error("post error.", (Throwable)e);
            String string = null;
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public static String post(String url, Map<String, String> queryParas, String data) {
        return HttpUtil.post(url, queryParas, data, null);
    }

    public static String post(String url, String data, Map<String, String> headers) {
        return HttpUtil.post(url, null, data, headers);
    }

    public static String post(String url, String data) {
        return HttpUtil.post(url, null, data, null);
    }

    private static String readString(HttpURLConnection conn) throws IOException {
        try (InputStreamReader isr = new InputStreamReader(conn.getInputStream(), CHARSET);){
            int num;
            StringBuilder ret = new StringBuilder();
            char[] buf = new char[1024];
            while ((num = isr.read(buf, 0, buf.length)) != -1) {
                ret.append(buf, 0, num);
            }
            String string = ret.toString();
            return string;
        }
    }

    private static String buildUrlQuery(String url, Map<String, String> queryParas) {
        boolean isFirst;
        if (queryParas == null || queryParas.isEmpty()) {
            return url;
        }
        StringBuilder sb = new StringBuilder(url);
        if (url.indexOf(63) == -1) {
            isFirst = true;
            sb.append('?');
        } else {
            isFirst = false;
        }
        for (Map.Entry<String, String> entry : queryParas.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append('&');
            }
            String key = entry.getKey();
            String value = entry.getValue();
            if (StringUtil.isNotBlank(value)) {
                try {
                    value = URLEncoder.encode(value, CHARSET);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            sb.append(key).append('=').append(value);
        }
        return sb.toString();
    }

    private static class TrustAnyTrustManager
    implements X509TrustManager {
        private TrustAnyTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }

    private static class TrustAnyHostnameVerifier
    implements HostnameVerifier {
        private TrustAnyHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

