/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.audit;

import com.mybatisflex.core.audit.AuditMessage;
import com.mybatisflex.core.audit.ConsoleMessageReporter;
import com.mybatisflex.core.audit.MessageCollector;
import com.mybatisflex.core.audit.MessageReporter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ScheduledMessageCollector
implements MessageCollector,
Runnable {
    private long period;
    private ScheduledExecutorService scheduler;
    private MessageReporter messageSender;
    private List<AuditMessage> messages = Collections.synchronizedList(new ArrayList());
    private ReentrantReadWriteLock rrwLock = new ReentrantReadWriteLock();

    public ScheduledMessageCollector() {
        this(10L, new ConsoleMessageReporter());
    }

    public ScheduledMessageCollector(long period, MessageReporter messageSender) {
        this.period = period;
        this.messageSender = messageSender;
        this.scheduler = Executors.newSingleThreadScheduledExecutor(runnable -> {
            Thread thread = new Thread(runnable, "ScheduledMessageCollector");
            thread.setDaemon(true);
            return thread;
        });
        this.scheduler.scheduleAtFixedRate(this, period, period, TimeUnit.SECONDS);
    }

    @Override
    public void collect(AuditMessage message) {
        try {
            this.rrwLock.readLock().lock();
            this.messages.add(message);
        }
        finally {
            this.rrwLock.readLock().unlock();
        }
    }

    @Override
    public void run() {
        ArrayList<AuditMessage> sendMessages;
        if (this.messages.isEmpty()) {
            return;
        }
        try {
            this.rrwLock.writeLock().lock();
            sendMessages = new ArrayList<AuditMessage>(this.messages);
            this.messages.clear();
        }
        finally {
            this.rrwLock.writeLock().unlock();
        }
        this.messageSender.sendMessages(sendMessages);
    }

    public void release() {
        this.run();
        this.scheduler.shutdown();
    }
}

