/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.audit;

import com.mybatisflex.core.audit.AuditMessage;
import com.mybatisflex.core.audit.MessageCollector;
import com.mybatisflex.core.util.DateUtil;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;

public class ConsoleMessageCollector
implements MessageCollector {
    private SqlDebugPrinter printer = (sql, takedTimeMillis) -> {
        if (takedTimeMillis != null) {
            System.out.println("Flex exec sql taked " + takedTimeMillis + " ms >>>  " + sql);
        } else {
            System.out.println("Flex exec sql >>>  " + sql);
        }
    };

    public ConsoleMessageCollector() {
    }

    public ConsoleMessageCollector(SqlDebugPrinter printer) {
        this.printer = printer;
    }

    @Override
    public void collect(AuditMessage message) {
        String sql = this.getFullSql(message.getQuery(), message.getQueryParams());
        this.printer.print(sql, message.getElapsedTime());
    }

    private String getFullSql(String sql, List<Object> params) {
        if (params != null) {
            for (Object value : params) {
                if (value == null) {
                    sql = sql.replaceFirst("\\?", "null");
                    continue;
                }
                if (value instanceof Number || value instanceof Boolean) {
                    sql = sql.replaceFirst("\\?", value.toString());
                    continue;
                }
                StringBuilder sb = new StringBuilder();
                sb.append("'");
                if (value instanceof Date) {
                    sb.append(DateUtil.toDateTimeString((Date)value));
                } else if (value instanceof LocalDateTime) {
                    sb.append(DateUtil.toDateTimeString(DateUtil.toDate((LocalDateTime)value)));
                } else {
                    sb.append(value);
                }
                sb.append("'");
                sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(sb.toString()));
            }
        }
        return sql;
    }

    public static interface SqlDebugPrinter {
        public void print(String var1, Long var2);
    }
}

