/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jdbc;

import com.mockrunner.jdbc.ResultSetFactory;
import com.mockrunner.mock.jdbc.MockParameterMap;
import com.mockrunner.mock.jdbc.MockResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class EvaluableResultSet
extends MockResultSet {
    public EvaluableResultSet(String id) {
        super(id);
    }

    public EvaluableResultSet(String id, String cursorName) {
        super(id, cursorName);
    }

    @Override
    public MockResultSet evaluate(String sql, MockParameterMap parameters) {
        try {
            MockResultSet newResultSet = new MockResultSet(this.getId(), this.getCursorName());
            ResultSetMetaData metaData = this.getMetaData();
            for (int i = 1; i <= this.getColumnCount(); ++i) {
                String columnName = metaData.getColumnName(i);
                List<Object> values = this.getColumn(columnName);
                ArrayList<Object> newValues = new ArrayList<Object>(values.size());
                int row = 0;
                for (Object value : values) {
                    if (value instanceof Evaluable) {
                        newValues.add(((Evaluable)value).evaluate(sql, parameters, columnName, row));
                    } else {
                        newValues.add(value);
                    }
                    ++row;
                }
                newResultSet.addColumn(columnName, newValues);
            }
            return newResultSet;
        }
        catch (SQLException e) {
            throw new RuntimeException("Never triggered", e);
        }
    }

    public static class Factory
    implements ResultSetFactory {
        protected final boolean columnsCaseSensitive;

        public Factory(boolean columnsCaseSensitive) {
            this.columnsCaseSensitive = columnsCaseSensitive;
        }

        @Override
        public EvaluableResultSet create(String id) {
            EvaluableResultSet resultSet = new EvaluableResultSet(id);
            if (this.columnsCaseSensitive) {
                resultSet.setColumnsCaseSensitive(true);
            }
            return resultSet;
        }
    }

    public static interface Evaluable {
        public Object evaluate(String var1, MockParameterMap var2, String var3, int var4);
    }
}

