/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jdbc;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.jdbc.XMLResultSetFactory;
import com.mockrunner.mock.jdbc.MockResultSet;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class XMLResultSetFactorySQLDeveloperSupport
extends XMLResultSetFactory {
    public static final int ORACLE_SQLDEVELOPER_DIALECT = 2;
    protected String copyFileName;

    public XMLResultSetFactorySQLDeveloperSupport(File file) {
        super(file);
        this.copyFileName = file.getAbsolutePath();
    }

    public XMLResultSetFactorySQLDeveloperSupport(String fileName) {
        super(fileName);
        this.copyFileName = fileName;
    }

    @Override
    public MockResultSet create(String id) {
        MockResultSet mockResultSet;
        switch (this.getDialect()) {
            case 2: {
                mockResultSet = this.createSQLDeveloperResultSet(id);
                break;
            }
            default: {
                mockResultSet = super.create(id);
            }
        }
        return mockResultSet;
    }

    public MockResultSet createSQLDeveloperResultSet(String id) {
        MockResultSet resultSet = new MockResultSet(id);
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        File fileToParse = this.getXMLFile();
        if (null == fileToParse) {
            throw new RuntimeException("File " + this.copyFileName + " not found.");
        }
        try {
            doc = builder.build(fileToParse);
            Element root = doc.getRootElement();
            List rows = root.getChildren("ROW");
            Iterator ri = rows.iterator();
            boolean firstIteration = true;
            while (ri.hasNext()) {
                Element cRow = (Element)ri.next();
                List cRowChildren = cRow.getChildren();
                Iterator cri = cRowChildren.iterator();
                Object[] cRowValues = new String[cRowChildren.size()];
                int curCol = 0;
                while (cri.hasNext()) {
                    Element crValue = (Element)cri.next();
                    if (firstIteration) {
                        resultSet.addColumn(crValue.getAttributeValue("NAME"));
                    }
                    String value = this.getTrim() ? crValue.getTextTrim() : crValue.getText();
                    cRowValues[curCol] = value;
                    ++curCol;
                }
                resultSet.addRow(cRowValues);
                firstIteration = false;
            }
        }
        catch (Exception exc) {
            throw new NestedApplicationException("Failure while reading from XML file", (Throwable)exc);
        }
        return resultSet;
    }
}

