/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.ejb;

import com.mockrunner.ejb.Configuration;
import com.mockrunner.ejb.JNDIUtil;
import com.mockrunner.mock.ejb.MockUserTransaction;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;
import org.mockejb.MockContainer;

public class EJBMockObjectFactory {
    private Configuration configuration;
    private UserTransaction transaction;
    private MockContainer container;
    private Context context;

    public EJBMockObjectFactory() {
        this(new Configuration());
    }

    public EJBMockObjectFactory(Configuration configuration) {
        this.configuration = configuration;
        this.initializeContext();
        this.initializeEJBContainer();
        this.initializeUserTransaction();
    }

    private void initializeContext() {
        this.context = JNDIUtil.getContext(this.configuration);
    }

    private void initializeUserTransaction() {
        try {
            try {
                this.transaction = (UserTransaction)this.context.lookup(this.configuration.getUserTransactionJNDIName());
            }
            catch (NameNotFoundException nameExc) {
                this.transaction = this.createMockUserTransaction();
                JNDIUtil.bindUserTransaction(this.configuration, this.context, this.transaction);
            }
        }
        catch (Exception exc) {
            this.transaction = this.createMockUserTransaction();
        }
        if (this.transaction instanceof MockUserTransaction) {
            ((MockUserTransaction)this.transaction).reset();
        }
    }

    private void initializeEJBContainer() {
        this.container = new MockContainer(this.context);
    }

    public MockUserTransaction createMockUserTransaction() {
        return new MockUserTransaction();
    }

    public void initMockContextFactory() throws NamingException {
        JNDIUtil.initMockContextFactory();
    }

    public void resetMockContextFactory() {
        JNDIUtil.resetMockContextFactory();
    }

    public MockUserTransaction getMockUserTransaction() {
        if (!(this.transaction instanceof MockUserTransaction)) {
            return null;
        }
        return (MockUserTransaction)this.transaction;
    }

    public UserTransaction getUserTransaction() {
        return this.transaction;
    }

    public MockContainer getMockContainer() {
        return this.container;
    }

    public Context getContext() {
        return this.context;
    }
}

