/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.gen;

import com.kirkk.analyzer.framework.Jar;
import com.kirkk.analyzer.framework.bcelbundle.JarImpl;
import com.mockrunner.gen.jar.JarFileExtractor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;

public class JarFileExtractorTest
extends TestCase {
    private JarFileExtractor getJarFileExtractor(List<String> mainJars, List<String> exceptionJars) {
        return new JarFileExtractor(mainJars, exceptionJars);
    }

    private List<String> getMainJars() {
        ArrayList<String> jars = new ArrayList<String>();
        jars.add("test1.jar");
        jars.add("test2.jar");
        jars.add("test3.jar");
        return jars;
    }

    private List<String> getExceptionJars() {
        ArrayList<String> jars = new ArrayList<String>();
        jars.add("nested1.jar");
        return jars;
    }

    private JarImpl createEmptyJar(String name) {
        return new JarImpl(name);
    }

    private JarImpl createJarWithDependencies(String name, String[] dependencies) {
        JarImpl jar = this.createEmptyJar(name);
        for (String dependency : dependencies) {
            jar.addOutgoingDependency((Jar)this.createEmptyJar(dependency));
        }
        return jar;
    }

    public void testFilter() {
        JarFileExtractor extractor = this.getJarFileExtractor(this.getMainJars(), new ArrayList<String>());
        Jar[] jars = new Jar[]{this.createEmptyJar("test1.jar"), this.createEmptyJar("test2.jar"), this.createEmptyJar("test3.jar"), this.createEmptyJar("test4.jar"), this.createEmptyJar("test5.jar")};
        jars = extractor.filter(jars);
        JarFileExtractorTest.assertEquals((int)3, (int)jars.length);
        JarFileExtractorTest.assertTrue((boolean)jars[0].getJarFileName().equals("test1.jar"));
        JarFileExtractorTest.assertTrue((boolean)jars[1].getJarFileName().equals("test2.jar"));
        JarFileExtractorTest.assertTrue((boolean)jars[2].getJarFileName().equals("test3.jar"));
    }

    public void testEmpty() {
        JarFileExtractor extractor = this.getJarFileExtractor(this.getMainJars(), new ArrayList<String>());
        Map<String, Set<String>> dependencies = extractor.createDependencies(new Jar[0]);
        JarFileExtractorTest.assertEquals((int)0, (int)dependencies.size());
    }

    public void testNoDependencies() {
        JarFileExtractor extractor = this.getJarFileExtractor(this.getMainJars(), new ArrayList<String>());
        Jar[] jars = new Jar[]{this.createEmptyJar("test1.jar"), this.createEmptyJar("test2.jar"), this.createEmptyJar("test3.jar")};
        Map<String, Set<String>> dependencies = extractor.createDependencies(jars);
        JarFileExtractorTest.assertEquals((int)3, (int)dependencies.size());
        JarFileExtractorTest.assertTrue((boolean)dependencies.get("test1.jar").isEmpty());
        JarFileExtractorTest.assertTrue((boolean)dependencies.get("test2.jar").isEmpty());
        JarFileExtractorTest.assertTrue((boolean)dependencies.get("test3.jar").isEmpty());
    }

    public void testDependencies() {
        JarFileExtractor extractor = this.getJarFileExtractor(this.getMainJars(), new ArrayList<String>());
        Jar[] jars = new Jar[]{this.createJarWithDependencies("test1.jar", new String[]{"1", "2", "3"})};
        Map<String, Set<String>> dependencies = extractor.createDependencies(jars);
        JarFileExtractorTest.assertEquals((int)1, (int)dependencies.size());
        Set<String> jarSet = dependencies.get("test1.jar");
        JarFileExtractorTest.assertEquals((int)3, (int)jarSet.size());
        JarFileExtractorTest.assertTrue((boolean)jarSet.contains("1"));
        JarFileExtractorTest.assertTrue((boolean)jarSet.contains("2"));
        JarFileExtractorTest.assertTrue((boolean)jarSet.contains("3"));
    }

    public void testRecursiveDependencies() {
        JarFileExtractor extractor = this.getJarFileExtractor(this.getMainJars(), new ArrayList<String>());
        JarImpl jar1 = this.createEmptyJar("test1.jar");
        JarImpl nested1 = this.createJarWithDependencies("nested1.jar", new String[]{"1", "2", "3"});
        JarImpl nested2 = this.createJarWithDependencies("nested2.jar", new String[]{"4", "5", "6"});
        jar1.addOutgoingDependency((Jar)nested1);
        jar1.addOutgoingDependency((Jar)nested2);
        JarImpl jar2 = this.createJarWithDependencies("test2.jar", new String[]{"7", "8", "9"});
        Jar[] jars = new Jar[]{jar1, jar2};
        Map<String, Set<String>> dependencies = extractor.createDependencies(jars);
        JarFileExtractorTest.assertEquals((int)2, (int)dependencies.size());
        Set<String> jars1 = dependencies.get("test1.jar");
        JarFileExtractorTest.assertEquals((int)8, (int)jars1.size());
        JarFileExtractorTest.assertTrue((boolean)jars1.contains("1"));
        JarFileExtractorTest.assertTrue((boolean)jars1.contains("2"));
        JarFileExtractorTest.assertTrue((boolean)jars1.contains("3"));
        JarFileExtractorTest.assertTrue((boolean)jars1.contains("4"));
        JarFileExtractorTest.assertTrue((boolean)jars1.contains("5"));
        JarFileExtractorTest.assertTrue((boolean)jars1.contains("6"));
        JarFileExtractorTest.assertTrue((boolean)jars1.contains("nested1.jar"));
        JarFileExtractorTest.assertTrue((boolean)jars1.contains("nested2.jar"));
        Set<String> jars2 = dependencies.get("test2.jar");
        JarFileExtractorTest.assertEquals((int)3, (int)jars2.size());
        JarFileExtractorTest.assertTrue((boolean)jars2.contains("7"));
        JarFileExtractorTest.assertTrue((boolean)jars2.contains("8"));
        JarFileExtractorTest.assertTrue((boolean)jars2.contains("9"));
        extractor = this.getJarFileExtractor(this.getMainJars(), this.getExceptionJars());
        dependencies = extractor.createDependencies(jars);
        JarFileExtractorTest.assertEquals((int)2, (int)dependencies.size());
        jars1 = dependencies.get("test1.jar");
        JarFileExtractorTest.assertEquals((int)5, (int)jars1.size());
        JarFileExtractorTest.assertTrue((boolean)jars1.contains("4"));
        JarFileExtractorTest.assertTrue((boolean)jars1.contains("5"));
        JarFileExtractorTest.assertTrue((boolean)jars1.contains("6"));
        JarFileExtractorTest.assertTrue((boolean)jars1.contains("nested1.jar"));
        JarFileExtractorTest.assertTrue((boolean)jars1.contains("nested2.jar"));
        jars2 = dependencies.get("test2.jar");
        JarFileExtractorTest.assertEquals((int)3, (int)jars2.size());
        JarFileExtractorTest.assertTrue((boolean)jars2.contains("7"));
        JarFileExtractorTest.assertTrue((boolean)jars2.contains("8"));
        JarFileExtractorTest.assertTrue((boolean)jars2.contains("9"));
    }
}

