/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.ThreatAssessmentResult;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IThreatAssessmentResultCollectionPage;
import com.microsoft.graph.requests.extensions.IThreatAssessmentResultCollectionRequest;
import com.microsoft.graph.requests.extensions.ThreatAssessmentResultCollectionPage;
import com.microsoft.graph.requests.extensions.ThreatAssessmentResultCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ThreatAssessmentResultCollectionResponse;
import com.microsoft.graph.requests.extensions.ThreatAssessmentResultRequestBuilder;
import java.util.List;

public class ThreatAssessmentResultCollectionRequest
extends BaseCollectionRequest<ThreatAssessmentResultCollectionResponse, IThreatAssessmentResultCollectionPage>
implements IThreatAssessmentResultCollectionRequest {
    public ThreatAssessmentResultCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ThreatAssessmentResultCollectionResponse.class, IThreatAssessmentResultCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IThreatAssessmentResultCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ThreatAssessmentResultCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IThreatAssessmentResultCollectionPage get() throws ClientException {
        ThreatAssessmentResultCollectionResponse response = (ThreatAssessmentResultCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ThreatAssessmentResult newThreatAssessmentResult, ICallback<ThreatAssessmentResult> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ThreatAssessmentResultRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newThreatAssessmentResult, callback);
    }

    @Override
    public ThreatAssessmentResult post(ThreatAssessmentResult newThreatAssessmentResult) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ThreatAssessmentResultRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newThreatAssessmentResult);
    }

    @Override
    public IThreatAssessmentResultCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IThreatAssessmentResultCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IThreatAssessmentResultCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IThreatAssessmentResultCollectionPage buildFromResponse(ThreatAssessmentResultCollectionResponse response) {
        ThreatAssessmentResultCollectionRequestBuilder builder = response.nextLink != null ? new ThreatAssessmentResultCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ThreatAssessmentResultCollectionPage page = new ThreatAssessmentResultCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

